/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.utils;

import java.util.List;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public final class BasicExtractionUtils {
    private BasicExtractionUtils() {
    }

    public static double getMedian(double[] array) {
        if (array.length > 0 && array.length % 2 == 0) {
            return (array[(array.length - 1) / 2] + array[array.length / 2]) / 2.0;
        }
        return array[(array.length - 1) / 2];
    }

    public static double getMedianTimeStamp(ArrivalRateTuple[] array) {
        if (array.length > 0 && array.length % 2 == 0) {
            return (array[(array.length - 1) / 2].getTimeStamp() + array[array.length / 2].getTimeStamp()) / 2.0;
        }
        return array[(array.length - 1) / 2].getTimeStamp();
    }

    public static double getMedianArrivalRate(ArrivalRateTuple[] array) {
        if (array.length > 0 && array.length % 2 == 0) {
            return (array[(array.length - 1) / 2].getArrivalRate() + array[array.length / 2].getArrivalRate()) / 2.0;
        }
        return array[(array.length - 1) / 2].getArrivalRate();
    }

    public static double getArrivalRate(double time, List<ArrivalRateTuple> arrRates, boolean linearInterpolation) {
        if (arrRates.size() == 0) {
            return 0.0;
        }
        if (time >= arrRates.get(arrRates.size() - 1).getTimeStamp()) {
            return 0.0;
        }
        if (time < arrRates.get(0).getTimeStamp()) {
            if (time >= 0.0) {
                if (linearInterpolation) {
                    return time / arrRates.get(0).getTimeStamp() * arrRates.get(0).getArrivalRate();
                }
                return arrRates.get(0).getArrivalRate();
            }
            return 0.0;
        }
        double assumedStep = arrRates.get(0).getStep(null);
        int index = (int)(time / assumedStep);
        if (index >= arrRates.size() - 1) {
            index = arrRates.size() - 2;
        }
        ArrivalRateTuple lower = arrRates.get(index);
        ArrivalRateTuple higher = arrRates.get(index + 1);
        while (time < lower.getTimeStamp()) {
            lower = arrRates.get(--index);
        }
        while (time >= higher.getTimeStamp()) {
            higher = arrRates.get(++index + 1);
        }
        lower = arrRates.get(index);
        higher = arrRates.get(index + 1);
        if (linearInterpolation) {
            return lower.getArrivalRate() + (time - lower.getTimeStamp()) / (higher.getTimeStamp() - lower.getTimeStamp()) * (higher.getArrivalRate() - lower.getArrivalRate());
        }
        if (time - lower.getTimeStamp() < higher.getTimeStamp() - time) {
            return lower.getArrivalRate();
        }
        return higher.getArrivalRate();
    }

    public static ArrivalRateTuple getNearestArrivalRateTuple(double time, List<ArrivalRateTuple> arrRates) {
        if (arrRates.size() == 0) {
            return null;
        }
        if (time >= arrRates.get(arrRates.size() - 1).getTimeStamp()) {
            return arrRates.get(arrRates.size() - 1);
        }
        if (time < arrRates.get(0).getTimeStamp()) {
            return arrRates.get(0);
        }
        double assumedStep = arrRates.get(0).getStep(null);
        int index = (int)(time / assumedStep);
        if (index >= arrRates.size() - 1) {
            index = arrRates.size() - 2;
        }
        ArrivalRateTuple lower = arrRates.get(index);
        ArrivalRateTuple higher = arrRates.get(index + 1);
        while (time < lower.getTimeStamp()) {
            lower = arrRates.get(--index);
        }
        while (time >= higher.getTimeStamp()) {
            higher = arrRates.get(++index + 1);
        }
        lower = arrRates.get(index);
        higher = arrRates.get(index + 1);
        if (time - lower.getTimeStamp() < higher.getTimeStamp() - time) {
            return lower;
        }
        return higher;
    }
}

