/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.utils;

import java.util.Iterator;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.extractor.utils.BasicTrendExtractionUtilities;
import tools.descartes.dlim.extractor.utils.ExtractionDataContainer;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public final class RegressiveTrendExtractor {
    private static final double DEFAULT_RELATIVE_TREND_OFFSET = 0.5;

    private RegressiveTrendExtractor() {
    }

    public static double[] getTrendEndPointsUsingRegression(ExtractionDataContainer container) {
        int trendPointNum = (int)(container.getDuration() / container.getPeriod()) / container.getSeasonalsPerTrend();
        double[] trendValues = new double[trendPointNum];
        double trendOffset = container.getPeriod() / 2.0;
        ExtractionDataContainer currentSubContainer = container;
        Iterator<ExtractionDataContainer> containerIterator = container.getSubContainerList().iterator();
        if (!container.getSubContainerList().isEmpty()) {
            currentSubContainer = container.getSubContainerList().get(0);
        }
        ArrivalRateTuple[] regPoints = RegressiveTrendExtractor.getArrivalRatePointsForRegression(currentSubContainer);
        int i = 0;
        while (i < trendPointNum) {
            double seasonalStart = container.getPeriod() * (double)i;
            double trendCalibrationTimeStamp = trendOffset + seasonalStart;
            while (trendCalibrationTimeStamp > currentSubContainer.getBeginTime() + currentSubContainer.getDuration() && containerIterator.hasNext()) {
                currentSubContainer = containerIterator.next();
                regPoints = RegressiveTrendExtractor.getArrivalRatePointsForRegression(currentSubContainer);
            }
            ArrivalRateTuple[] originals = RegressiveTrendExtractor.getCorrespondingOriginalArrivalRates(regPoints, seasonalStart, container);
            trendValues[i] = container.getOperatorLiteral().contains("MULT") ? RegressiveTrendExtractor.getMultiplicativeRegressionPoint(regPoints, originals) : (container.getOperatorLiteral().contains("ADD") ? RegressiveTrendExtractor.getAdditiveTrendPoint(regPoints, originals) : -1.0 * RegressiveTrendExtractor.getAdditiveTrendPoint(regPoints, originals));
            ++i;
        }
        return trendValues;
    }

    private static double getMultiplicativeRegressionPoint(ArrivalRateTuple[] regPoints, ArrivalRateTuple[] originals) {
        SimpleRegression regression = new SimpleRegression(false);
        int i = 0;
        while (i < regPoints.length) {
            regression.addData(regPoints[i].getArrivalRate(), originals[i].getArrivalRate());
            ++i;
        }
        return regression.getSlope();
    }

    private static double getAdditiveTrendPoint(ArrivalRateTuple[] regPoints, ArrivalRateTuple[] originals) {
        double sum = 0.0;
        int i = 0;
        while (i < regPoints.length) {
            sum += originals[i].getArrivalRate() - regPoints[i].getArrivalRate();
            ++i;
        }
        return sum / (double)regPoints.length;
    }

    private static ArrivalRateTuple[] getCorrespondingOriginalArrivalRates(ArrivalRateTuple[] regPoints, double seasonalStart, ExtractionDataContainer globalContainer) {
        ArrivalRateTuple[] originals = new ArrivalRateTuple[regPoints.length];
        int regIndex = 0;
        ArrivalRateTuple prev = globalContainer.getArrivalRateList().get(0);
        for (ArrivalRateTuple next : globalContainer.getArrivalRateList()) {
            double w;
            while ((w = RegressiveTrendExtractor.calculateInterpolationWeight(seasonalStart + regPoints[regIndex].getTimeStamp(), next, prev)) >= 0.0) {
                originals[regIndex] = new ArrivalRateTuple(prev.getTimeStamp() + w * (next.getTimeStamp() - prev.getTimeStamp()), prev.getArrivalRate() + w * (next.getArrivalRate() - prev.getArrivalRate()));
                if (++regIndex >= regPoints.length) break;
            }
            if (regIndex >= regPoints.length) break;
            prev = next;
        }
        return originals;
    }

    private static double calculateInterpolationWeight(double timestamp, ArrivalRateTuple next, ArrivalRateTuple prev) {
        if (timestamp < prev.getTimeStamp() || timestamp >= next.getTimeStamp()) {
            return -1.0;
        }
        double w = timestamp - prev.getTimeStamp();
        return w / (next.getTimeStamp() - prev.getTimeStamp());
    }

    private static ArrivalRateTuple[] getArrivalRatePointsForRegression(ExtractionDataContainer container) {
        int innerBaseCount = 0;
        if (container.getInnerBases() != null) {
            innerBaseCount = container.getInnerBases().length;
        }
        ArrivalRateTuple[] regPoints = new ArrivalRateTuple[innerBaseCount + container.getPeaks().length];
        int i = 0;
        while (i < container.getPeaks().length) {
            regPoints[i * 2] = container.getPeaks()[i];
            ++i;
        }
        if (container.getInnerBases() != null) {
            i = 0;
            while (i < container.getInnerBases().length) {
                regPoints[i * 2 + 1] = container.getInnerBases()[i];
                ++i;
            }
        }
        return regPoints;
    }

    public static void buildTrendPart(Sequence root, ExtractionDataContainer container) {
        BasicTrendExtractionUtilities.buildTrendPart(root, container, container.getPeriod() * 0.5, false);
    }
}

