/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import tools.descartes.dlim.Combinator;
import tools.descartes.dlim.Constant;
import tools.descartes.dlim.DlimFactory;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.Operator;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.Trend;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.assistant.Calibrator;
import tools.descartes.dlim.extractor.utils.ExtractionDataContainer;
import tools.descartes.dlim.generator.Activator;
import tools.descartes.dlim.generator.ModelEvaluator;

public final class BasicTrendExtractionUtilities {
    private BasicTrendExtractionUtilities() {
    }

    public static void buildTrendPart(Sequence root, ExtractionDataContainer container, double trendOffset, boolean calibrateTrendPoints) {
        double trendDuration = container.getPeriod() * (double)container.getSeasonalsPerTrend();
        root.getCombine().clear();
        if (trendDuration > 0.0 && container.getMaxPeakOffset() + trendDuration < container.getDuration() && container.getTrendPointValues().length > 1) {
            DlimFactory factory = DlimPackage.eINSTANCE.getDlimFactory();
            Combinator trendCombinator = factory.createCombinator();
            trendCombinator.setOperator(Operator.get((String)container.getOperatorLiteral()));
            Sequence trendSequence = factory.createSequence();
            trendSequence.setName("trends");
            trendSequence.setTerminateAfterTime(container.getDuration());
            trendCombinator.setFunction((Function)trendSequence);
            root.getCombine().add((Object)trendCombinator);
            TimeDependentFunctionContainer offsetElement = factory.createTimeDependentFunctionContainer();
            offsetElement.setDuration(trendOffset);
            offsetElement.setName("offset");
            offsetElement.setFunction((Function)factory.createConstant());
            trendSequence.getSequenceFunctionContainers().add((Object)offsetElement);
            int i = 0;
            while (i < container.getTrendPointValues().length - 1) {
                TimeDependentFunctionContainer trendElement = factory.createTimeDependentFunctionContainer();
                trendElement.setDuration(trendDuration);
                trendElement.setName("trend" + i);
                trendElement.setFunction((Function)BasicTrendExtractionUtilities.createTrendWithCorrectShape(container.getSeasonalShape()));
                trendSequence.getSequenceFunctionContainers().add((Object)trendElement);
                ++i;
            }
            TimeDependentFunctionContainer holdElement = factory.createTimeDependentFunctionContainer();
            holdElement.setDuration(container.getDuration() - trendOffset - trendDuration * (double)(container.getTrendPointValues().length - 1));
            holdElement.setName("holdLastTrend");
            holdElement.setFunction((Function)factory.createConstant());
            trendSequence.getSequenceFunctionContainers().add((Object)holdElement);
            int i2 = 0;
            for (TimeDependentFunctionContainer e : trendSequence.getSequenceFunctionContainers()) {
                Function f = e.getFunction();
                if (!(f instanceof Trend)) continue;
                Trend trend = (Trend)f;
                if (calibrateTrendPoints) {
                    trend.setFunctionOutputAtStart(BasicTrendExtractionUtilities.calibrateTrendStartValue(root, trend, container.getTrendPointValues()[i2]));
                } else {
                    trend.setFunctionOutputAtStart(container.getTrendPointValues()[i2]);
                }
                ++i2;
                if (calibrateTrendPoints) {
                    trend.setFunctionOutputAtEnd(BasicTrendExtractionUtilities.calibrateTrendEndValue(root, trend, container.getTrendPointValues()[i2]));
                    continue;
                }
                trend.setFunctionOutputAtEnd(container.getTrendPointValues()[i2]);
            }
            Constant offset1 = (Constant)((TimeDependentFunctionContainer)trendSequence.getSequenceFunctionContainers().get(0)).getFunction();
            offset1.setConstant(((Trend)((TimeDependentFunctionContainer)trendSequence.getSequenceFunctionContainers().get(1)).getFunction()).getFunctionOutputAtStart());
            int lastIndex = trendSequence.getSequenceFunctionContainers().size() - 1;
            Constant offset2 = (Constant)((TimeDependentFunctionContainer)trendSequence.getSequenceFunctionContainers().get(lastIndex)).getFunction();
            offset2.setConstant(((Trend)((TimeDependentFunctionContainer)trendSequence.getSequenceFunctionContainers().get(lastIndex - 1)).getFunction()).getFunctionOutputAtEnd());
        }
    }

    public static void buildRepeatingTrend(Sequence root, int[] seasonalsPerTrend, double[] trendPoints, ExtractionDataContainer container) {
        double trendDuration = 0.0;
        int[] nArray = seasonalsPerTrend;
        int n = seasonalsPerTrend.length;
        int n2 = 0;
        while (n2 < n) {
            int seasonals = nArray[n2];
            trendDuration += (double)seasonals;
            ++n2;
        }
        if ((trendDuration *= container.getPeriod()) > 0.0 && trendPoints.length > 1) {
            DlimFactory factory = DlimPackage.eINSTANCE.getDlimFactory();
            Combinator trendCombinator = factory.createCombinator();
            trendCombinator.setOperator(Operator.get((String)container.getOperatorLiteral()));
            Sequence trendSequenceContainer = factory.createSequence();
            trendSequenceContainer.setName("trendContainer");
            trendSequenceContainer.setTerminateAfterTime(container.getDuration());
            Sequence trendSequence = factory.createSequence();
            trendSequence.setName("trends");
            trendSequence.setTerminateAfterTime(container.getDuration());
            trendCombinator.setFunction((Function)trendSequenceContainer);
            root.getCombine().add((Object)trendCombinator);
            TimeDependentFunctionContainer offsetElement = factory.createTimeDependentFunctionContainer();
            offsetElement.setDuration(container.getMaxPeakOffset());
            offsetElement.setName("offset");
            offsetElement.setFunction((Function)factory.createConstant());
            trendSequenceContainer.getSequenceFunctionContainers().add((Object)offsetElement);
            TimeDependentFunctionContainer trendContainer = factory.createTimeDependentFunctionContainer();
            trendContainer.setDuration(container.getDuration());
            trendContainer.setName("trends");
            trendContainer.setFunction((Function)trendSequence);
            trendSequenceContainer.getSequenceFunctionContainers().add((Object)trendContainer);
            int i = 0;
            while (i < trendPoints.length - 1) {
                TimeDependentFunctionContainer trendElement = factory.createTimeDependentFunctionContainer();
                trendElement.setDuration((double)seasonalsPerTrend[i] * container.getPeriod());
                trendElement.setName("trend" + i);
                trendElement.setFunction((Function)BasicTrendExtractionUtilities.createTrendWithCorrectShape(container.getTrendShape()));
                trendSequence.getSequenceFunctionContainers().add((Object)trendElement);
                ++i;
            }
            i = 0;
            for (TimeDependentFunctionContainer e : trendSequence.getSequenceFunctionContainers()) {
                Function f = e.getFunction();
                if (!(f instanceof Trend)) continue;
                Trend trend = (Trend)f;
                trend.setFunctionOutputAtStart(BasicTrendExtractionUtilities.calibrateTrendStartValue(root, trend, trendPoints[i]));
                trend.setFunctionOutputAtEnd(BasicTrendExtractionUtilities.calibrateTrendEndValue(root, trend, trendPoints[++i]));
            }
            Constant offset1 = (Constant)((TimeDependentFunctionContainer)trendSequenceContainer.getSequenceFunctionContainers().get(0)).getFunction();
            offset1.setConstant(((Trend)((TimeDependentFunctionContainer)trendSequence.getSequenceFunctionContainers().get(0)).getFunction()).getFunctionOutputAtStart());
        }
    }

    private static double calibrateTrendStartValue(Sequence rootSequence, Trend trend, double value) {
        ModelEvaluator evaluator = new ModelEvaluator(rootSequence, 0, "dlim:calibration");
        double startValue = value;
        try {
            startValue = Calibrator.calibrateTrendStartValue(value, trend, evaluator);
        }
        catch (CalibrationException e) {
            Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "CalibrationException:" + e.getMessage(), (Throwable)e));
        }
        return startValue;
    }

    private static double calibrateTrendEndValue(Sequence rootSequence, Trend trend, double value) {
        ModelEvaluator evaluator = new ModelEvaluator(rootSequence, 0, "dlim:calibration");
        double endValue = value;
        try {
            endValue = Calibrator.calibrateTrendEndValue(value, trend, evaluator);
        }
        catch (CalibrationException e) {
            Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "CalibrationException:" + e.getMessage(), (Throwable)e));
        }
        return endValue;
    }

    public static Trend createTrendWithCorrectShape(String shapeString) {
        try {
            return (Trend)DlimPackage.eINSTANCE.getDlimFactory().create((EClass)DlimPackage.eINSTANCE.getEClassifier(shapeString));
        }
        catch (NullPointerException e) {
            return DlimPackage.eINSTANCE.getDlimFactory().createSinTrend();
        }
    }
}

