/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator;

import java.util.ArrayList;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.eclipse.emf.ecore.EObject;
import tools.descartes.dlim.AbsoluteValueFunction;
import tools.descartes.dlim.ArrivalRatesFromFile;
import tools.descartes.dlim.Combinator;
import tools.descartes.dlim.Constant;
import tools.descartes.dlim.CustomFunction;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.Operator;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.ModelEvaluatorUtil;
import tools.descartes.dlim.generator.util.ConcurrentModelEvaluator;
import tools.descartes.dlim.generator.util.FunctionValueCalculator;
import tools.descartes.dlim.generator.util.TimeKeeper;

public class ModelEvaluator {
    private Sequence rootSequence;
    private FunctionValueCalculator calculator;
    private JDKRandomGenerator rndGenerator;

    public ModelEvaluator(Sequence rootSequence, int seed, String noiseMode) {
        this.rootSequence = rootSequence;
        this.rndGenerator = new JDKRandomGenerator();
        this.rndGenerator.setSeed(seed);
        this.calculator = new FunctionValueCalculator(this.rndGenerator, noiseMode);
        ModelEvaluatorUtil.setRootSequence((Sequence)rootSequence);
        TimeKeeper.calculateSequenceTime((Function)rootSequence, 0.0);
        this.precompute((EObject)rootSequence);
    }

    public ModelEvaluator(Sequence rootSequence) {
        this(rootSequence, 5, "dlim:evaluation");
    }

    public double getArrivalRateAtTime(double rootTime) {
        try {
            return this.getFunctionNodeArrivalRate((Function)this.rootSequence, rootTime, rootTime, rootTime);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public ArrayList<ArrivalRateTuple> getArrivalRateAtTimes(double startTime, double endTime, double step) {
        ConcurrentModelEvaluator concurrentEvaluator = new ConcurrentModelEvaluator(this);
        return concurrentEvaluator.evaluateForTimeStamps(startTime, endTime, step);
    }

    public double getArrivalRateDelta(double rootTime, int index, boolean[] wasMult) {
        try {
            wasMult[0] = false;
            double ci = this.calculateFunctionValue((Function)this.rootSequence, rootTime, rootTime, rootTime);
            double ciMinus1 = 0.0;
            if (index < 0) {
                return ci;
            }
            ArrayList<Combinator> combList = new ArrayList<Combinator>();
            for (Combinator c : this.rootSequence.getCombine()) {
                if (!c.getOperator().getLiteral().contains("MULT")) continue;
                combList.add(c);
            }
            for (Combinator c : this.rootSequence.getCombine()) {
                if (c.getOperator().getLiteral().contains("MULT")) continue;
                combList.add(c);
            }
            if (((Combinator)combList.get(index)).getOperator().getLiteral().contains("ADD")) {
                return this.calculateFunctionValue(((Combinator)combList.get(index)).getFunction(), rootTime, rootTime, rootTime);
            }
            if (((Combinator)combList.get(index)).getOperator().getLiteral().contains("SUB")) {
                return -this.calculateFunctionValue(((Combinator)combList.get(index)).getFunction(), rootTime, rootTime, rootTime);
            }
            int i = 0;
            for (Combinator c : combList) {
                ciMinus1 = ci;
                ci = this.combineFunction(ci, c, rootTime, rootTime, rootTime);
                if (i == index) {
                    wasMult[0] = true;
                    return ci - ciMinus1;
                }
                ++i;
            }
            return 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getDuration() {
        return this.rootSequence.getFinalDuration();
    }

    public double getTerminatingDuration() {
        double duration = this.getDuration();
        if (duration >= Double.MAX_VALUE) {
            duration = this.rootSequence.getLoopDuration();
        }
        return duration;
    }

    public String getName() {
        return this.rootSequence.getName();
    }

    public JDKRandomGenerator getRndGenerator() {
        return this.rndGenerator;
    }

    public double getRandomNumber() {
        return this.rndGenerator.nextDouble();
    }

    public void setRandomSeed(int seed) {
        this.rndGenerator.setSeed(seed);
    }

    private double getFunctionNodeArrivalRate(Function f, double x, double rootTime, double loopTime) {
        double arr = this.calculateFunctionValue(f, x, rootTime, loopTime);
        for (Combinator c : f.getCombine()) {
            if (!c.getOperator().getLiteral().contains("MULT")) continue;
            arr = this.combineFunction(arr, c, x, rootTime, loopTime);
        }
        for (Combinator c : f.getCombine()) {
            if (c.getOperator().getLiteral().contains("MULT")) continue;
            arr = this.combineFunction(arr, c, x, rootTime, loopTime);
        }
        return arr;
    }

    private double combineFunction(double originalValue, Combinator c, double x, double rootTime, double loopTime) {
        if (c.getOperator().getLiteral().contains("ADD")) {
            return originalValue + this.getFunctionNodeArrivalRate(c.getFunction(), x, rootTime, loopTime);
        }
        if (c.getOperator().getLiteral().contains("MULT")) {
            return originalValue * this.getFunctionNodeArrivalRate(c.getFunction(), x, rootTime, loopTime);
        }
        return originalValue - this.getFunctionNodeArrivalRate(c.getFunction(), x, rootTime, loopTime);
    }

    private double calculateFunctionValue(Function f, double x, double rootTime, double loopTime) {
        if (f instanceof Sequence) {
            return this.calculateSequenceValue((Sequence)f, x, rootTime, loopTime);
        }
        if (f instanceof ArrivalRatesFromFile) {
            return ((ArrivalRatesFromFile)f).getArrivalRate(x);
        }
        if (f instanceof Constant) {
            return ((Constant)f).getConstant();
        }
        if (f instanceof CustomFunction) {
            System.out.println("Custom Functions are not supported at the moment.");
            return 0.0;
        }
        if (f instanceof AbsoluteValueFunction) {
            return Math.abs(this.getFunctionNodeArrivalRate(((AbsoluteValueFunction)f).getFunction(), x, rootTime, loopTime));
        }
        return this.calculator.getSimpleFunctionValue(f, x);
    }

    /*
     * Unable to fully structure code
     */
    private double calculateSequenceValue(Sequence seq, double x, double rootTime, double loopTime) {
        internalTime = loopTime;
        if (!(loopTime < seq.getFirstIterationStart()) && !(loopTime >= seq.getFirstIterationEnd())) ** GOTO lbl7
        if (ModelEvaluatorUtil.getParentCombinator((Function)seq) != null) {
            return ModelEvaluatorUtil.neutralElement((Operator)ModelEvaluatorUtil.getParentCombinator((Function)seq).getOperator());
        }
        return 0.0;
lbl-1000:
        // 1 sources

        {
            internalTime -= seq.getLoopDuration();
lbl7:
            // 2 sources

            ** while (internalTime >= seq.getFirstIterationStart() + seq.getLoopDuration())
        }
lbl8:
        // 1 sources

        seqTime = loopTime - seq.getFirstIterationStart();
        seqLoopTime = internalTime - seq.getFirstIterationStart();
        clock = seq.getReferenceClock();
        if (clock != null) {
            clock.setSeqTime(seqTime);
            clock.setLoopTime(seqLoopTime);
        }
        seqValue = 0.0;
        for (TimeDependentFunctionContainer e : seq.getSequenceFunctionContainers()) {
            seqValue += this.getElementArrivalRateAtTime(e, rootTime, internalTime, seqLoopTime, seqTime);
        }
        return seqValue;
    }

    private double getElementArrivalRateAtTime(TimeDependentFunctionContainer e, double rootTime, double guardTime, double loopTime, double seqTime) {
        double functionValue;
        if (guardTime < e.getFirstIterationStart() || guardTime >= e.getFirstIterationEnd()) {
            return 0.0;
        }
        double x = rootTime;
        if (e.getPointOfReferenceClockType().toString().contains("CONTAINERCLOCK")) {
            x = guardTime - e.getFirstIterationStart();
        } else if (e.getPointOfReferenceClockType().toString().contains("SEQCLOCK")) {
            x = e.getPointOfReferenceClockObject() == null ? seqTime : e.getPointOfReferenceClockObject().getSeqTime();
        } else if (e.getPointOfReferenceClockType().toString().contains("LOOPCLOCK")) {
            x = e.getPointOfReferenceClockObject() == null ? loopTime : e.getPointOfReferenceClockObject().getLoopTime();
        }
        if (e.getFunction() == null) {
            functionValue = 0.0;
            if (ModelEvaluatorUtil.getParentCombinator((Function)ModelEvaluatorUtil.getParentSequence((TimeDependentFunctionContainer)e)) != null) {
                functionValue = ModelEvaluatorUtil.neutralElement((Operator)ModelEvaluatorUtil.getParentCombinator((Function)ModelEvaluatorUtil.getParentSequence((TimeDependentFunctionContainer)e)).getOperator());
            }
        } else {
            functionValue = this.getFunctionNodeArrivalRate(e.getFunction(), x, rootTime, loopTime);
        }
        return functionValue;
    }

    private void precompute(EObject object) {
        if (object instanceof ArrivalRatesFromFile) {
            ((ArrivalRatesFromFile)object).readFile();
        }
        for (EObject child : object.eContents()) {
            this.precompute(child);
        }
    }

    public boolean containsReferenceClockObject() {
        boolean contains = ModelEvaluatorUtil.containsReferenceClock((Function)this.rootSequence);
        return contains;
    }
}

