/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.exporterHandler;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Execute;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.exporter.IDlimExporter;
import tools.descartes.dlim.exporterHandler.ExporterContainer;
import tools.descartes.dlim.generator.Activator;
import tools.descartes.dlim.generator.ModelEvaluator;

public final class ExporterHandler {
    public static final String IEXPORTER_ID = "tools.descartes.dlim.generator.tools_descartes_dlim_generator_exporters";
    private ArrayList<ExporterContainer> exporters = new ArrayList();
    private static ExporterHandler handlerSingleton;

    public static ExporterHandler getHandlerSingleton() {
        if (handlerSingleton == null) {
            handlerSingleton = new ExporterHandler();
        }
        return handlerSingleton;
    }

    private ExporterHandler() {
        if (handlerSingleton == null) {
            handlerSingleton = this;
            this.execute(Platform.getExtensionRegistry());
        }
    }

    @Execute
    private void execute(IExtensionRegistry registry) {
        this.evaluate(registry);
    }

    private void evaluate(IExtensionRegistry registry) {
        IConfigurationElement[] config = registry.getConfigurationElementsFor(IEXPORTER_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                String label = e.getAttribute("label");
                if (o instanceof IDlimExporter) {
                    this.exporters.add(new ExporterContainer(label, (IDlimExporter)o));
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.getInstance().log((IStatus)new Status(1, "tools.descartes.dlim.generator", ex.getMessage(), (Throwable)ex));
        }
    }

    public String[] getExporterLabels() {
        String[] labels = new String[this.exporters.size()];
        int i = 0;
        for (ExporterContainer e : this.exporters) {
            labels[i] = e.getLabel();
            ++i;
        }
        return labels;
    }

    public void executeExtension(final int exporterIndex, final String projectPath, final String modelPath, final Sequence rootObject) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
                Activator.getInstance().log((IStatus)new Status(1, "tools.descartes.dlim.generator", "Exception in client", e));
            }

            public void run() throws Exception {
                IDlimExporter exporter = ExporterHandler.this.exporters.get(exporterIndex).getExporter();
                exporter.export(projectPath, modelPath, new ModelEvaluator(rootObject));
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }
}

