/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Operator implements Enumerator
{
    ADD(0, "add", "ADD"),
    SUBTRACT(1, "subtract", "SUB"),
    MULT(2, "mult", "MULT");

    public static final int ADD_VALUE = 0;
    public static final int SUBTRACT_VALUE = 1;
    public static final int MULT_VALUE = 2;
    private static final Operator[] VALUES_ARRAY;
    public static final List<Operator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Operator[]{ADD, SUBTRACT, MULT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Operator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator get(int value) {
        switch (value) {
            case 0: {
                return ADD;
            }
            case 1: {
                return SUBTRACT;
            }
            case 2: {
                return MULT;
            }
        }
        return null;
    }

    private Operator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

