/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import tools.descartes.dlim.ArrivalRatesFromFile;
import tools.descartes.dlim.DlimPlugin;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public class ArrivalRatesReader {
    private static final String PLUGIN_ID = "tools.descartes.dlim";

    public List<ArrivalRateTuple> readFile(ArrivalRatesFromFile arrivalRatesFromFile) {
        ArrayList<ArrivalRateTuple> arrRates = new ArrayList<ArrivalRateTuple>();
        Path txtFilePath = new Path(arrivalRatesFromFile.getFilePath().trim());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(txtFilePath.toString()));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] numbers = (line = line.substring(0, line.length() - 1)).split(",");
                    if (numbers.length < 2) continue;
                    double timeStamp = Double.parseDouble(numbers[0].trim());
                    double readArrivalRate = Double.parseDouble(numbers[1].trim());
                    arrRates.add(new ArrivalRateTuple(timeStamp, readArrivalRate));
                }
                return arrRates;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DlimPlugin.INSTANCE.log(new Status(4, PLUGIN_ID, "Arrival Rate File does not exist.", (Throwable)e));
            return Collections.emptyList();
        }
    }
}

