/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased;

import de.mdelab.sdm.interpreter.core.facade.MetamodelFacadeFactory;
import de.mdelab.sdm.interpreter.core.patternmatcher.MatchingStrategy;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.PatternPart;
import java.util.Set;

public class DefaultMatchingStrategy<StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>
extends MatchingStrategy<StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> {
    public DefaultMatchingStrategy(MetamodelFacadeFactory<?, ?, ?, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> facadeFactory) {
        super(facadeFactory);
    }

    @Override
    public PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression> getNextPatternPartForMatching(Set<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>> uncheckedPatternParts) {
        int lowestCost = -1;
        int lowestCostOptional = -1;
        int cost = 0;
        PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression> cheapestPatternPart = null;
        PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression> cheapestPatternPartOptional = null;
        block4: for (PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression> patternPart : uncheckedPatternParts) {
            cost = patternPart.calculateMatchingCost();
            if (cost == -1) continue;
            switch (patternPart.getMatchType()) {
                case MANDATORY: {
                    if (cost == 1) {
                        return patternPart;
                    }
                    if (cost >= lowestCost && cheapestPatternPart != null) continue block4;
                    lowestCost = cost;
                    cheapestPatternPart = patternPart;
                    break;
                }
                case OPTIONAL: {
                    if (cost >= lowestCostOptional && cheapestPatternPartOptional != null) continue block4;
                    lowestCostOptional = cost;
                    cheapestPatternPartOptional = patternPart;
                }
            }
        }
        if (uncheckedPatternParts.size() > 0 && cheapestPatternPart == null && cheapestPatternPartOptional == null) {
            throw new UnsupportedOperationException("Unmatched pattern parts exist but none of them can be matched next.");
        }
        if (cheapestPatternPart != null) {
            return cheapestPatternPart;
        }
        return cheapestPatternPartOptional;
    }
}

