/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.ocl;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.expressions.ExpressionInterpreter;
import de.mdelab.sdm.interpreter.core.facade.IExpressionFacade;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import de.mdelab.sdm.interpreter.core.variables.VariablesScope;
import de.mdelab.sdm.interpreter.ocl.environment.CustomOCLEnvironmentFactory;
import de.mdelab.sdm.interpreter.ocl.environment.MultiResourceLazyExtentMap;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.types.OCLStandardLibrary;

public class OCLExpressionInterpreter<Expression>
extends ExpressionInterpreter<Expression, EClassifier> {
    private OCL previousOCL;
    private VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> previousVariableScope;

    private OCL getOCL(VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        if (this.previousOCL != null && this.previousVariableScope == variablesScope) {
            return this.previousOCL;
        }
        OCL ocl = OCL.newInstance((EnvironmentFactory)new CustomOCLEnvironmentFactory(variablesScope));
        for (String importURI : variablesScope.getExpressionImports("OCL", "1.0")) {
            try {
                ocl.parse(new OCLInput(URIConverter.INSTANCE.createInputStream(URI.createURI((String)importURI))));
            }
            catch (ParserException e) {
                throw new SDMException("Could not parse imported URI '" + importURI + "'.", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new SDMException("Could not parse imported URI '" + importURI + "'.", (Exception)e);
            }
        }
        LinkedList<EObject> contextObjects = new LinkedList<EObject>();
        for (Variable v : variablesScope.getVariables()) {
            if (!(v.getValue() instanceof EObject)) continue;
            contextObjects.add((EObject)v.getValue());
        }
        ocl.setExtentMap((Map)new MultiResourceLazyExtentMap(contextObjects));
        this.previousOCL = ocl;
        this.previousVariableScope = variablesScope;
        return ocl;
    }

    public Variable<EClassifier> evaluateExpression(Expression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        IExpressionFacade expressionFacade = this.getExpressionInterpreterManager().getFacadeFactory().getExpressionFacade();
        OCL ocl = this.getOCL(variablesScope);
        org.eclipse.ocl.ecore.OCLExpression oclExpression = null;
        Object expressionAST = expressionFacade.getExpressionAST(expression);
        if (expressionAST == null) {
            try {
                oclExpression = this.parseExpression(expressionFacade.getExpressionString(expression), contextClassifier, variablesScope, ocl);
            }
            catch (ParserException e) {
                throw new SDMException("Could not parse OCL expression '" + expressionFacade.getExpressionString(expression) + "': " + e.getMessage(), (Exception)((Object)e));
            }
            expressionFacade.setExpressionAST(expression, (Object)oclExpression);
        } else {
            assert (expressionAST instanceof org.eclipse.ocl.ecore.OCLExpression);
            oclExpression = (org.eclipse.ocl.ecore.OCLExpression)expressionAST;
        }
        Object result = null;
        try {
            result = ocl.evaluate(contextInstance, (OCLExpression)oclExpression);
        }
        catch (IllegalArgumentException ex) {
            throw new SDMException("The OCL expression '" + expressionFacade.getExpressionString(expression) + "' could not be evaluated.", (Exception)ex);
        }
        if (ocl.isInvalid(result)) {
            throw new SDMException("The OCL expression '" + expressionFacade.getExpressionString(expression) + "' was evaluated to an invalid result.");
        }
        if (oclExpression.getType() != null) {
            return new Variable("##internalVariable##", (Object)this.getEcoreStandardType((EClassifier)oclExpression.getType(), ocl), result);
        }
        assert (result == null);
        return new Variable("##internalVariable##", (Object)EcorePackage.Literals.EJAVA_OBJECT, null);
    }

    protected EClassifier getEcoreStandardType(EClassifier oclType, OCL ocl) {
        OCLStandardLibrary oclStandardLibrary = ocl.getEnvironment().getOCLStandardLibrary();
        if (oclType == oclStandardLibrary.getBoolean()) {
            return EcorePackage.Literals.EBOOLEAN;
        }
        if (oclType == oclStandardLibrary.getInteger()) {
            return EcorePackage.Literals.EINT;
        }
        if (oclType == oclStandardLibrary.getReal()) {
            return EcorePackage.Literals.EDOUBLE;
        }
        if (oclType == oclStandardLibrary.getString()) {
            return EcorePackage.Literals.ESTRING;
        }
        if (oclType == oclStandardLibrary.getUnlimitedNatural()) {
            return EcorePackage.Literals.ELONG;
        }
        return oclType;
    }

    private org.eclipse.ocl.ecore.OCLExpression parseExpression(String expressionString, EClassifier contextClassifier, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope, OCL ocl) throws ParserException, SDMException {
        if (contextClassifier == null) {
            contextClassifier = EcorePackage.Literals.EOBJECT;
        }
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)contextClassifier);
        return helper.createQuery(expressionString);
    }
}

