/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.cost;

import de.uka.ipd.sdq.dsexplore.analysis.AbstractAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.analysis.cost.CostAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.cost.CostSolverQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.pcm.cost.ComponentCostPerInstance;
import de.uka.ipd.sdq.pcm.cost.ComponentCostPerType;
import de.uka.ipd.sdq.pcm.cost.Cost;
import de.uka.ipd.sdq.pcm.cost.CostRepository;
import de.uka.ipd.sdq.pcm.cost.FixedProcessingResourceCost;
import de.uka.ipd.sdq.pcm.cost.ProcessingResourceCost;
import de.uka.ipd.sdq.pcm.cost.VariableProcessingResourceCost;
import de.uka.ipd.sdq.pcm.cost.costPackage;
import de.uka.ipd.sdq.pcm.cost.helper.CostUtil;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.opt4j.core.Criterion;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.solver.models.PCMInstance;

public class CostEvaluator
extends AbstractAnalysis
implements IAnalysis {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.analysis.cost");
    private CostRepository costModel;
    private Map<Long, CostAnalysisResult> previousCostResults = new HashMap<Long, CostAnalysisResult>();

    public CostEvaluator() {
        super((IAnalysisQualityAttributeDeclaration)new CostSolverQualityAttributeDeclaration());
    }

    private double getInitialCost(PCMInstance pcmInstance) {
        EList costs = this.costModel.getCost();
        double sum = 0.0;
        for (Cost cost : costs) {
            if (!this.doesCostApply(cost, pcmInstance)) continue;
            sum += cost.getInitialCost();
        }
        return sum;
    }

    private boolean doesCostApply(Cost cost, PCMInstance pcmInstance) {
        if (VariableProcessingResourceCost.class.isInstance(cost)) {
            VariableProcessingResourceCost vc = (VariableProcessingResourceCost)cost;
            ResourceContainer rc = (ResourceContainer)vc.getProcessingresourcespecification().eContainer();
            return this.checkWhetherResourceContainerIsUsed(pcmInstance, rc);
        }
        if (cost instanceof ComponentCostPerType) {
            ComponentCostPerType cc = (ComponentCostPerType)cost;
            RepositoryComponent rc = cc.getRepositoryComponent();
            List<AssemblyContext> asctx = this.getAllContainedAssemblyContexts((EList<AssemblyContext>)pcmInstance.getSystem().getAssemblyContexts__ComposedStructure());
            for (AssemblyContext assemblyContext : asctx) {
                if (!EMFHelper.checkIdentity((EObject)assemblyContext.getEncapsulatedComponent__AssemblyContext(), (EObject)rc)) continue;
                return true;
            }
            return false;
        }
        if (cost instanceof FixedProcessingResourceCost) {
            FixedProcessingResourceCost fc = (FixedProcessingResourceCost)cost;
            ResourceContainer rc = (ResourceContainer)fc.getProcessingresourcespecification().eContainer();
            return this.checkWhetherResourceContainerIsUsed(pcmInstance, rc);
        }
        return true;
    }

    private List<AssemblyContext> getAllContainedAssemblyContexts(EList<AssemblyContext> assemblyContextsComposedStructure) {
        ArrayList<AssemblyContext> list = new ArrayList<AssemblyContext>();
        list.addAll((Collection<AssemblyContext>)assemblyContextsComposedStructure);
        for (AssemblyContext assemblyContext : assemblyContextsComposedStructure) {
            if (!(assemblyContext.getEncapsulatedComponent__AssemblyContext() instanceof ComposedStructure)) continue;
            ComposedStructure composite = (ComposedStructure)assemblyContext.getEncapsulatedComponent__AssemblyContext();
            list.addAll(this.getAllContainedAssemblyContexts((EList<AssemblyContext>)composite.getAssemblyContexts__ComposedStructure()));
        }
        return list;
    }

    private boolean checkWhetherResourceContainerIsUsed(PCMInstance pcmInstance, ResourceContainer rc) {
        EList alloc = pcmInstance.getAllocation().getAllocationContexts_Allocation();
        for (AllocationContext allocationContext : alloc) {
            if (!EMFHelper.checkIdentity((EObject)allocationContext.getResourceContainer_AllocationContext(), (EObject)rc)) continue;
            return true;
        }
        return false;
    }

    private double getOperatingCost(PCMInstance pcmInstance) {
        EList costs = this.costModel.getCost();
        double sum = 0.0;
        for (Cost cost : costs) {
            if (!this.doesCostApply(cost, pcmInstance)) continue;
            sum += cost.getOperatingCost();
        }
        return sum;
    }

    private void updateCostModel(PCMInstance pcmInstance) {
        EList allCosts = this.costModel.getCost();
        this.createCostsForReplicas((List<Cost>)allCosts, pcmInstance);
        block0: for (Cost cost : allCosts) {
            if (cost instanceof ComponentCostPerInstance) {
                ((ComponentCostPerInstance)cost).setAllocation(pcmInstance.getAllocation());
                continue;
            }
            if (!VariableProcessingResourceCost.class.isInstance(cost)) continue;
            VariableProcessingResourceCost varCost = (VariableProcessingResourceCost)cost;
            ProcessingResourceSpecification old_prs = ((VariableProcessingResourceCost)cost).getProcessingresourcespecification();
            ResourceContainer old_rc = (ResourceContainer)old_prs.eContainer();
            ProcessingResourceType ars = old_prs.getActiveResourceType_ActiveResourceSpecification();
            EList all_new_rcs = pcmInstance.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
            for (ResourceContainer resourceContainer : all_new_rcs) {
                if (!resourceContainer.getId().equals(old_rc.getId())) continue;
                EList new_resources = resourceContainer.getActiveResourceSpecifications_ResourceContainer();
                boolean resourceTypeFound = false;
                for (ProcessingResourceSpecification new_prs : new_resources) {
                    if (!new_prs.getActiveResourceType_ActiveResourceSpecification().getId().equals(ars.getId())) continue;
                    if (!resourceTypeFound) {
                        varCost.setProcessingresourcespecification(new_prs);
                        resourceTypeFound = true;
                        continue;
                    }
                    throw new RuntimeException("There are two processing resources with the same resource type within one resource container, this cannot be handled by the optimisation yet. Please change your model.");
                }
                continue block0;
            }
        }
    }

    private void createCostsForReplicas(List<Cost> allCosts, PCMInstance pcmInstance) {
        EList containers = pcmInstance.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        ArrayList<ProcessingResourceCost> replicaCosts = new ArrayList<ProcessingResourceCost>();
        ArrayList<ProcessingResourceCost> oldReplicaCosts = new ArrayList<ProcessingResourceCost>();
        for (Cost anyCost : allCosts) {
            ResourceContainer originalContainer = null;
            ProcessingResourceType procResourceType = null;
            ProcessingResourceCost cost = null;
            if (!(anyCost instanceof ProcessingResourceCost)) continue;
            cost = (ProcessingResourceCost)anyCost;
            originalContainer = cost.getProcessingresourcespecification().getResourceContainer_ProcessingResourceSpecification();
            procResourceType = cost.getProcessingresourcespecification().getActiveResourceType_ActiveResourceSpecification();
            if (originalContainer.getEntityName().contains("Replica") && !containers.contains(originalContainer)) {
                oldReplicaCosts.add(cost);
            }
            for (ResourceContainer resourceContainer : containers) {
                if (!resourceContainer.getEntityName().contains("Replica") || !resourceContainer.getId().contains(originalContainer.getId())) continue;
                boolean replicaAlreadyAnnotated = false;
                for (Cost existingCost : allCosts) {
                    ProcessingResourceCost existingProcRateCost;
                    if (!(existingCost instanceof ProcessingResourceCost) || !(existingProcRateCost = (ProcessingResourceCost)existingCost).getProcessingresourcespecification().getResourceContainer_ProcessingResourceSpecification().getId().equals(resourceContainer.getId())) continue;
                    replicaAlreadyAnnotated = true;
                    break;
                }
                if (replicaAlreadyAnnotated) continue;
                ProcessingResourceSpecification replicaProcSpec = null;
                for (ProcessingResourceSpecification procRes : resourceContainer.getActiveResourceSpecifications_ResourceContainer()) {
                    if (!procRes.getActiveResourceType_ActiveResourceSpecification().getId().equals(procResourceType.getId())) continue;
                    replicaProcSpec = procRes;
                    break;
                }
                if (replicaProcSpec == null) {
                    logger.warn((Object)("Could not find processing resource type " + procResourceType.getEntityName() + " in container " + resourceContainer.getEntityName() + ", assuming that there are no costs for it in this replica"));
                    return;
                }
                ProcessingResourceCost replicaCost = (ProcessingResourceCost)EcoreUtil.copy((EObject)cost);
                replicaCost.setProcessingresourcespecification(replicaProcSpec);
                replicaCosts.add(replicaCost);
            }
        }
        allCosts.removeAll(oldReplicaCosts);
        allCosts.addAll(replicaCosts);
    }

    public void analyse(PCMPhenotype pheno, IProgressMonitor monitor) throws CoreException, UserCanceledException, JobFailedException, AnalysisFailedException {
        PCMInstance pcm = pheno.getPCMInstance();
        this.updateCostModel(pcm);
        double initialCost = this.getInitialCost(pcm);
        double operatingCost = this.getOperatingCost(pcm);
        this.previousCostResults.put(pheno.getNumericID(), new CostAnalysisResult(CostUtil.getTotalCost((double)initialCost, (double)operatingCost, (double)this.costModel.getInterest(), (int)this.costModel.getTimePeriodYears()), initialCost, operatingCost, pcm, this.criterionToAspect, (CostSolverQualityAttributeDeclaration)this.qualityAttribute));
        CostUtil.getInstance().resetCache();
    }

    public void initialise(DSEWorkflowConfiguration configuration) throws CoreException {
        CostRepository costs;
        this.costModel = costs = this.getCostModel(configuration);
        this.initialiseCriteria(configuration);
    }

    private CostRepository getCostModel(DSEWorkflowConfiguration configuration) throws CoreException {
        String costModelFileName = configuration.getRawConfiguration().getAttribute("costFile", "");
        CostRepository cr = (CostRepository)EMFHelper.loadFromXMIFile((String)costModelFileName, (EPackage)costPackage.eINSTANCE);
        if (cr == null) {
            throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", 0, "Cost model " + costModelFileName + " could not be loaded.", null));
        }
        return cr;
    }

    public List<Criterion> getCriterions() throws CoreException {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        criterions.addAll(this.criteriaList);
        return criterions;
    }

    public IAnalysisResult retrieveResultsFor(PCMPhenotype pheno, Criterion criterion) throws CoreException, AnalysisFailedException {
        return this.previousCostResults.get(pheno.getNumericID());
    }

    public boolean hasObjectivePerUsageScenario() throws CoreException {
        return false;
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

