/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.lqn;

import de.uka.ipd.sdq.dsexplore.analysis.AbstractAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.ILQNResult;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.LQNNotConvergedResult;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.LQNQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.opt4j.core.Criterion;
import org.palladiosimulator.analyzer.workflow.configurations.PCMWorkflowConfigurationBuilder;
import org.palladiosimulator.solver.RunPCMAnalysisJob;
import org.palladiosimulator.solver.lqn.LqnModelType;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.runconfig.PCMSolverConfigurationBasedConfigBuilder;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;
import org.palladiosimulator.solver.transformations.SolverStrategy;
import org.palladiosimulator.solver.transformations.pcm2lqn.LqnXmlHandler;
import org.palladiosimulator.solver.transformations.pcm2lqn.Pcm2LqnStrategy;

public abstract class AbstractLQNAnalysis
extends AbstractAnalysis
implements IAnalysis {
    protected static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.analysis.lqn.LQNSolverAnalysis");
    private ILaunchConfiguration config;
    protected int iteration = -1;
    private Map<Long, String> previousResultFileName = new HashMap<Long, String>();
    private LinkedList<LqnModelType> recentModels = new LinkedList();
    private static int RECENT_MODEL_CAPACITY = 10;

    public AbstractLQNAnalysis() {
        super((IAnalysisQualityAttributeDeclaration)new LQNQualityAttributeDeclaration());
    }

    public void analyse(PCMPhenotype pheno, IProgressMonitor monitor) throws AnalysisFailedException, CoreException, UserCanceledException {
        ILaunchConfigurationWorkingCopy wcopy = this.config.getWorkingCopy();
        wcopy.setAttribute("solver", this.getSolverMessageString());
        this.config = wcopy.doSave();
        ++this.iteration;
        PCMInstance pcm = this.getPCMInstance();
        try {
            this.launchLQNSolver(pheno, monitor);
        }
        catch (RuntimeException e) {
            this.handleException(e, pcm);
        }
    }

    public IAnalysisResult retrieveResultsFor(PCMPhenotype pheno, Criterion criterion) throws AnalysisFailedException {
        PCMInstance pcm = this.getPCMInstance();
        ILQNResult result = this.retrieveLQNSolverResults(pheno, pcm, criterion);
        return result;
    }

    protected abstract IAnalysisResult handleException(RuntimeException var1, PCMInstance var2);

    protected abstract String getSolverMessageString();

    ILQNResult retrieveLQNSolverResults(PCMPhenotype pheno, PCMInstance pcm, Criterion criterion) throws AnalysisFailedException {
        String resultFileName = this.previousResultFileName.get(pheno.getNumericID());
        LqnModelType model = null;
        for (LqnModelType recentModel : this.recentModels) {
            if (!this.isFileNameBelongsToModel(resultFileName, recentModel)) continue;
            model = recentModel;
        }
        if (model == null) {
            model = LqnXmlHandler.loadModelFromXMI((String)resultFileName);
        }
        if (model == null) {
            logger.error((Object)("LQN model " + resultFileName + " could not be loaded. See previous logging entries for details."));
            return new LQNNotConvergedResult(pcm);
        }
        if (this.recentModels.size() >= RECENT_MODEL_CAPACITY) {
            this.recentModels.pollLast();
        }
        this.recentModels.push(model);
        ILQNResult result = this.retrieveResult(pcm, model, criterion);
        return result;
    }

    private boolean isFileNameBelongsToModel(String xmlFileName, LqnModelType recentModel) {
        String modelString = recentModel.eResource().getURI().toString();
        modelString = modelString.substring(modelString.lastIndexOf("/") + 1);
        return xmlFileName.contains(modelString);
    }

    protected abstract ILQNResult retrieveResult(PCMInstance var1, LqnModelType var2, Criterion var3) throws AnalysisFailedException;

    private void launchLQNSolver(PCMPhenotype pheno, IProgressMonitor monitor) throws AnalysisFailedException, CoreException, UserCanceledException {
        if (monitor == null) {
            throw new AnalysisFailedException(String.valueOf(((Object)((Object)this)).getClass().getName()) + " was not correctly initialised.");
        }
        PCMSolverWorkflowRunConfiguration solverConfiguration = new PCMSolverWorkflowRunConfiguration();
        PCMWorkflowConfigurationBuilder builder = new PCMWorkflowConfigurationBuilder(this.config, "run");
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)solverConfiguration);
        builder = new PCMSolverConfigurationBasedConfigBuilder(this.config, "run");
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)solverConfiguration);
        solverConfiguration.setInteractive(false);
        RunPCMAnalysisJob solverJob = new RunPCMAnalysisJob(solverConfiguration);
        solverJob.setBlackboard(this.blackboard);
        SolverStrategy strategy = solverJob.getStrategy();
        if (!(strategy instanceof Pcm2LqnStrategy)) {
            throw new AnalysisFailedException("PCM solver was not configured to use Pcm2Lqn. Please contact the developers. Strategy was: " + strategy);
        }
        this.previousResultFileName.put(pheno.getNumericID(), ((Pcm2LqnStrategy)strategy).getFilenameResultXML());
        try {
            solverJob.execute(monitor);
            logger.debug((Object)"Finished PCMSolver LQN analysis");
        }
        catch (JobFailedException e) {
            logger.error((Object)e.getMessage());
            throw new AnalysisFailedException((Throwable)e);
        }
    }

    public void initialise(DSEWorkflowConfiguration configuration) throws CoreException {
        this.config = configuration.getRawConfiguration();
        this.initialiseCriteria(configuration);
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

