/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.lqn;

import de.uka.ipd.sdq.dsexplore.analysis.AbstractPerformanceAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.AbstractLQNAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.ILQNResult;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.LQNNotConvergedResult;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.LQNQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.LQNSolverAnalysisResult;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.opt4j.core.Criterion;
import org.palladiosimulator.solver.lqn.LqnModelType;
import org.palladiosimulator.solver.models.PCMInstance;

public class LQNSolverAnalysis
extends AbstractLQNAnalysis {
    boolean hasConverged = true;

    @Override
    protected IAnalysisResult handleException(RuntimeException e, PCMInstance pcm) {
        if (e.getMessage() != null && e.getMessage().contains("exited with 1: The model failed to converge.") || e.getMessage().contains("Open arrival rate of ") && e.getMessage().contains("is too high.")) {
            this.hasConverged = false;
            return new LQNNotConvergedResult(pcm);
        }
        throw e;
    }

    @Override
    protected String getSolverMessageString() {
        return "LQNS (Layered Queueing Network Solver)";
    }

    @Override
    protected ILQNResult retrieveResult(PCMInstance pcm, LqnModelType model, Criterion criterion) throws AnalysisFailedException {
        AbstractPerformanceAnalysisResult result;
        if (this.hasConverged) {
            result = new LQNSolverAnalysisResult(model, pcm, criterion, (Map<Criterion, EvaluationAspectWithContext>)this.criterionToAspect, (LQNQualityAttributeDeclaration)this.qualityAttribute);
        } else {
            result = new LQNNotConvergedResult(pcm);
            this.hasConverged = true;
        }
        return result;
    }

    public boolean hasObjectivePerUsageScenario() throws CoreException {
        return true;
    }
}

