/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.simucom;

import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.AbstractPie;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.PieEntity;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.AssemblyContextContext;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.ExternalCallActionWithSensors;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.SimuComAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.SimuComQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.adapter.StateSensorToTimeDeltaPieAdapter;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.statistics.PhiMixingBatchAlgorithm;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import de.uka.ipd.sdq.statistics.estimation.SampleMeanEstimator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math.stat.descriptive.rank.Max;
import org.apache.commons.math.stat.descriptive.rank.Median;
import org.apache.commons.math.stat.descriptive.rank.Min;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.opt4j.core.Criterion;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.repositorydecorator.AllocationServiceResult;
import org.palladiosimulator.analyzer.resultdecorator.repositorydecorator.RepositorydecoratorFactory;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ActiveResourceUtilisationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.PassiveResourceResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.transformations.ContextWrapper;

public class SimuComAnalysisSensorFrameworkResult
extends SimuComAnalysisResult {
    private final ExperimentRun run;
    private final Experiment experiment;
    public static final String EXPERIMENT_RUN_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS";

    public SimuComAnalysisSensorFrameworkResult(Entity entity, String experimentName, PCMInstance pcmInstance, Map<Criterion, EvaluationAspectWithContext> criterionToAspect, SimuComQualityAttributeDeclaration qualityAttributeInfo, ILaunchConfiguration config) throws AnalysisFailedException, CoreException {
        super(pcmInstance);
        this.experiment = SimuComAnalysisSensorFrameworkResult.findExperiment(experimentName, config);
        this.run = SimuComAnalysisSensorFrameworkResult.getLatestRun(this.experiment);
        this.pcmEntityIdentifier = entity.getEntityName();
        this.objectiveToAspects = criterionToAspect;
        this.qualityAttributeInfo = qualityAttributeInfo;
        this.results = this.retrieveResults(pcmInstance);
        this.maxUtilization = this.calculateMaxUtil("CPU");
        SensorAndMeasurements sam = this.getUsageScenarioMeasurements();
        this.meanValue = this.calculateUnivariateStatistic(sam, SimuComAnalysisResult.TimeseriesData.TIMESPAN, (UnivariateStatistic)new Mean());
        this.stdDeviation = this.calculateUnivariateStatistic(sam, SimuComAnalysisResult.TimeseriesData.TIMESPAN, (UnivariateStatistic)new StandardDeviation());
        this.medianValue = this.calculateUnivariateStatistic(sam, SimuComAnalysisResult.TimeseriesData.TIMESPAN, (UnivariateStatistic)new Median());
        this.throughput = this.calculateThroughput(sam);
        this.observations = sam.getMeasurements().size();
        this.confidenceInterval = this.determineConfidenceInterval(sam);
        logger.debug((Object)"Initialised SimuCom result");
    }

    private static Experiment findExperiment(String experimentName, ILaunchConfiguration config) throws CoreException {
        int selectedDataSourceID = config.getAttribute("datasourceID", -1);
        IDAOFactory factory = SensorFrameworkDataset.singleton().getDataSourceByID((long)selectedDataSourceID);
        Collection experiments = factory.createExperimentDAO().getExperiments();
        if (experiments.size() == 0) {
            SensorFrameworkDataset.singleton().reload();
            experiments = factory.createExperimentDAO().getExperiments();
        }
        for (Experiment experiment : experiments) {
            if (!experimentName.startsWith(experiment.getExperimentName())) continue;
            return experiment;
        }
        return null;
    }

    public static boolean isExperimentRunExisting(String experimentName, SimuComWorkflowConfiguration workflowConfig, int datasourceReloadCount, ILaunchConfiguration config) throws CoreException {
        if (datasourceReloadCount >= 100) {
            SensorFrameworkDataset.singleton().reload();
            datasourceReloadCount = 0;
        }
        ++datasourceReloadCount;
        Experiment experiment = SimuComAnalysisSensorFrameworkResult.findExperiment(experimentName, config);
        if (experiment == null) {
            return false;
        }
        ExperimentRun myRun = SimuComAnalysisSensorFrameworkResult.getLatestRun(experiment);
        return myRun != null;
    }

    private double calculateUnivariateStatistic(SensorAndMeasurements sam, SimuComAnalysisResult.TimeseriesData timespan, UnivariateStatistic stat) {
        double[] measurements = SimuComAnalysisSensorFrameworkResult.measurementsToDoubleArray(sam, timespan);
        return stat.evaluate(measurements);
    }

    private SensorAndMeasurements getUsageScenarioMeasurements() throws AnalysisFailedException {
        Sensor respTimeSensor = SimuComAnalysisSensorFrameworkResult.getSensorForUsageScenario(this.experiment, this.pcmEntityIdentifier);
        if (respTimeSensor != null) {
            return this.run.getMeasurementsOfSensor(respTimeSensor);
        }
        throw new AnalysisFailedException("Could not find sensor for usage scenario " + this.pcmEntityIdentifier);
    }

    private static ExperimentRun getLatestRun(Experiment currentExperiment) {
        Collection runs = currentExperiment.getExperimentRuns();
        Iterator iterator = runs.iterator();
        long dateLatest = 0L;
        ExperimentRun latest = null;
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                ExperimentRun experimentRun = (ExperimentRun)iterator.next();
                if (experimentRun.getMeasurements().size() == 0) continue;
                logger.debug((Object)("Looking at run " + experimentRun.getExperimentDateTime()));
                long runDate = SimuComAnalysisSensorFrameworkResult.extractTimestamp(experimentRun.getExperimentDateTime());
                if (dateLatest >= runDate) continue;
                latest = experimentRun;
                dateLatest = runDate;
            }
            if (latest != null) {
                logger.debug((Object)("Latest run: " + latest.getExperimentDateTime()));
            }
            return latest;
        }
        return null;
    }

    private static long extractTimestamp(String experimentDateTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(EXPERIMENT_RUN_DATE_FORMAT);
        try {
            return dateFormat.parse(experimentDateTime).getTime();
        }
        catch (ParseException e) {
            logger.error((Object)"Cannot parse sensorframework experiment run String");
            e.printStackTrace();
            return 0L;
        }
    }

    private double calculateThroughput(SensorAndMeasurements sam) throws AnalysisFailedException {
        int numberOfMeasurements = sam.getMeasurements().size();
        double duration = this.calculateUnivariateStatistic(sam, SimuComAnalysisResult.TimeseriesData.EVENTTIME, (UnivariateStatistic)new Max()) - this.calculateUnivariateStatistic(sam, SimuComAnalysisResult.TimeseriesData.EVENTTIME, (UnivariateStatistic)new Min());
        return (double)numberOfMeasurements / duration;
    }

    @Override
    protected void retrieveServiceResultsFinish(PCMInstance pcmInstance, ResultDecoratorRepository repo, HashMap<String, ExternalCallAction> idToExternalCallMap, Map<String, AssemblyContextContext> idToAssemblyContextMap, List<String> completionComponentIdsToIgnore) {
        Collection sensorList = this.experiment.getSensors();
        LinkedList<ExternalCallActionWithSensors> externalCallsInContextWithSensorsList = new LinkedList<ExternalCallActionWithSensors>();
        for (Sensor sensor : sensorList) {
            String sensorName = sensor.getSensorName();
            if (!sensorName.contains("CallID")) continue;
            if (sensorName.lastIndexOf(" ") < sensorName.length() - 2 && sensorName.lastIndexOf(" ") > -1 && sensorName.length() > 2) {
                String externalCallID = sensorName.substring(sensorName.lastIndexOf(" ") + 1, sensorName.length() - 1);
                ExternalCallAction myCall = idToExternalCallMap.get(externalCallID);
                if (myCall != null) {
                    String assemblyContextID = sensorName.substring(sensorName.indexOf("AssemblyCtx") + 13, sensorName.indexOf("CallID") - 2);
                    AssemblyContextContext myAssemblyContext = idToAssemblyContextMap.get(assemblyContextID);
                    if (myAssemblyContext != null) {
                        ExternalCallActionWithSensors externalCallInContextWithSensors = new ExternalCallActionWithSensors(myCall, myAssemblyContext);
                        int index = externalCallsInContextWithSensorsList.indexOf(externalCallInContextWithSensors);
                        if (index > 0) {
                            externalCallInContextWithSensors = (ExternalCallActionWithSensors)externalCallsInContextWithSensorsList.get(index);
                        } else {
                            externalCallsInContextWithSensorsList.add(externalCallInContextWithSensors);
                        }
                        externalCallInContextWithSensors.addSensor(sensor);
                        continue;
                    }
                } else {
                    String componentID = sensorName.substring(sensorName.indexOf("Component: ") + 11, sensorName.indexOf("AssemblyCtx") - 2);
                    if (completionComponentIdsToIgnore.contains(componentID)) {
                        logger.info((Object)("Ignoring completion component sensor " + sensorName + " when reading in SimuCom results."));
                        continue;
                    }
                }
            }
            logger.warn((Object)("Cannot retrieve external call id from sensor. If this is a completion component, this is ok. Otherwise, sensor name labels must have changed. Contact developers if this sensors is needed. Sensor: " + sensorName));
        }
        for (ExternalCallActionWithSensors externalCallActionWithSensors : externalCallsInContextWithSensorsList) {
            List<Sensor> mySensors = externalCallActionWithSensors.getSensors();
            if (mySensors.size() <= 0) continue;
            AllocationServiceResult myServiceResult = RepositorydecoratorFactory.eINSTANCE.createAllocationServiceResult();
            ContextWrapper contextWrapper = new ContextWrapper(pcmInstance);
            ArrayList<AssemblyContext> assemblyContextHierarchy = new ArrayList<AssemblyContext>(4);
            AssemblyContextContext currentContext = externalCallActionWithSensors.getAssemblyContext();
            while (currentContext != null) {
                assemblyContextHierarchy.add(currentContext.getAssemblyContext());
                currentContext = currentContext.getParentAssemblyContext();
            }
            Collections.reverse(assemblyContextHierarchy);
            contextWrapper.setAssCtxList(assemblyContextHierarchy);
            ServiceEffectSpecification seff = contextWrapper.getNextSEFF(externalCallActionWithSensors.getExternalCall());
            myServiceResult.setServiceEffectSpecification_ServiceResult(seff);
            double weightedAndCumulatedMeanResponseTime = 0.0;
            int totalNumberOfMeasurements = 0;
            for (Sensor sensor : mySensors) {
                SensorAndMeasurements results = this.run.getMeasurementsOfSensor(sensor);
                Collection measurements = results.getMeasurements();
                weightedAndCumulatedMeanResponseTime += this.calculateUnivariateStatistic(results, SimuComAnalysisResult.TimeseriesData.TIMESPAN, (UnivariateStatistic)new Mean()) * (double)(totalNumberOfMeasurements += measurements.size());
            }
            double meanResponseTime = weightedAndCumulatedMeanResponseTime / (double)totalNumberOfMeasurements;
            myServiceResult.setMeanResponseTime(meanResponseTime);
            repo.getServiceResult_ResultDecoratorRepository().add((Object)myServiceResult);
        }
    }

    @Override
    protected Map<String, PassiveResourceResult> retrievePassiveResourceUtilFinish(Map<String, PassiveResourceResult> idsToPassiveResourceResult) {
        Collection sensorList = this.experiment.getSensors();
        for (Sensor sensor : sensorList) {
            String sensorName = sensor.getSensorName();
            if (!sensorName.contains("Passive Resource")) continue;
            String passiveResourceAndAssemblyContextID = sensorName.substring(sensorName.lastIndexOf(" ") + 1);
            PassiveResourceResult passiveResourceResult = idsToPassiveResourceResult.get(passiveResourceAndAssemblyContextID);
            if (passiveResourceResult != null) {
                SensorAndMeasurements results = this.run.getMeasurementsOfSensor(sensor);
                if (sensorName.contains("Hold time")) {
                    passiveResourceResult.setAverageHoldingTime(this.calculateUnivariateStatistic(results, SimuComAnalysisResult.TimeseriesData.TIMESPAN, (UnivariateStatistic)new Mean()));
                    continue;
                }
                if (sensorName.contains("Wait time")) {
                    passiveResourceResult.setAverageWaitTime(this.calculateUnivariateStatistic(results, SimuComAnalysisResult.TimeseriesData.TIMESPAN, (UnivariateStatistic)new Mean()));
                    continue;
                }
                if (!sensorName.contains("Util")) continue;
                int capacity = Integer.parseInt(passiveResourceResult.getPassiveResource_PassiveResourceResult().getCapacity_PassiveResource().getSpecification());
                this.retrieveUtilisationFromSensor(sensor, (UtilisationResult)passiveResourceResult, capacity);
                continue;
            }
            logger.warn((Object)("Unknown passive resource id " + passiveResourceAndAssemblyContextID + ", ignoring this sensor."));
        }
        return idsToPassiveResourceResult;
    }

    private void retrieveUtilisationFromSensor(Sensor sensor, UtilisationResult result, int capacity) {
        SensorAndMeasurements sam = this.run.getMeasurementsOfSensor(sensor);
        double busyFraction = 0.0;
        double totalTime = 0.0;
        double weightedSumOfJobs = 0.0;
        if (sam.getMeasurements().size() > 0) {
            StateSensorToTimeDeltaPieAdapter dataAdapter = new StateSensorToTimeDeltaPieAdapter(sam);
            AbstractPie pie = (AbstractPie)dataAdapter.getAdaptedObject();
            Collection pieParts = pie.getEntities(Integer.MAX_VALUE);
            double totalIdleTime = 0.0;
            double totalWeights = 0.0;
            int maxNumberOfJobs = 0;
            for (PieEntity pieEntity : pieParts) {
                totalTime += pieEntity.getValue();
                totalWeights += pieEntity.getValue();
                if (pieEntity.getLabel().contains("Idle")) {
                    totalIdleTime = pieEntity.getValue();
                    continue;
                }
                String[] busyLabel = pieEntity.getLabel().split(" ");
                if (busyLabel.length > 1) {
                    try {
                        String numberOfJobsString = busyLabel[1];
                        int noOfJobs = Integer.parseInt(numberOfJobsString);
                        totalWeights += pieEntity.getValue();
                        weightedSumOfJobs += (double)noOfJobs * pieEntity.getValue();
                        if (noOfJobs <= maxNumberOfJobs) continue;
                        maxNumberOfJobs = noOfJobs;
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Cannot read in queue lengths, labels of the pie chart may have changed.");
                    }
                    continue;
                }
                logger.warn((Object)"Cannot read in queue lengths, labels of the pie chart may have changed.");
            }
            busyFraction = 1.0 - totalIdleTime / totalTime;
            result.setAverageQueueLength(weightedSumOfJobs / totalWeights);
            result.setMaxQueueLength(maxNumberOfJobs);
        }
        if (capacity == 1) {
            result.setResourceUtilisation(busyFraction);
        } else if (totalTime > 0.0) {
            double util = weightedSumOfJobs / (totalTime * (double)capacity);
            result.setResourceUtilisation(util);
        }
    }

    private ConfidenceInterval determineConfidenceInterval(SensorAndMeasurements sam) throws AnalysisFailedException {
        ConfidenceInterval ci = null;
        Sensor sensor = sam.getSensor();
        if (sensor instanceof TimeSpanSensor) {
            PhiMixingBatchAlgorithm statisticChecker = new PhiMixingBatchAlgorithm();
            for (Measurement m : sam.getMeasurements()) {
                TimeSpanMeasurement t = (TimeSpanMeasurement)m;
                statisticChecker.offerSample(t.getTimeSpan());
            }
            if (statisticChecker.hasValidBatches()) {
                ci = new SampleMeanEstimator().estimateConfidence(statisticChecker.getBatchMeans(), this.alpha);
            }
            if (ci == null) {
                ci = new ConfidenceInterval(Double.NaN, 0.0, Double.POSITIVE_INFINITY, this.alpha);
            }
            return ci;
        }
        logger.error((Object)"Sensor of usage scenario is not a time span sensor, cannot calculate statistics.");
        return null;
    }

    private static Sensor getSensorForUsageScenario(Experiment exp, String usageScenarioName) {
        Collection sensors = exp.getSensors();
        for (Sensor sensor : sensors) {
            if (!sensor.getSensorName().contains(usageScenarioName)) continue;
            logger.debug((Object)("Found sensor for usage scenario " + usageScenarioName));
            return sensor;
        }
        logger.error((Object)("No sensor found for usage scenario " + usageScenarioName));
        return null;
    }

    private static Sensor getSensorForResource(Experiment exp, Entity rc, ResourceType res, String sensorTypeString) {
        Collection sensors = exp.getSensors();
        for (Sensor sensor : sensors) {
            if (!sensor.getSensorName().contains(res.getEntityName()) && (!sensor.getSensorName().contains("Linking Resource") || !res.getEntityName().contains("LAN")) || !sensor.getSensorName().contains(sensorTypeString) || !sensor.getSensorName().contains(rc.getEntityName())) continue;
            logger.debug((Object)("Found sensor of " + sensorTypeString + " for the resource " + rc.getEntityName() + ": " + res.getEntityName()));
            return sensor;
        }
        logger.error((Object)("No sensor of " + sensorTypeString + " found for resource " + rc.getEntityName() + ": " + res.getEntityName()));
        return null;
    }

    private static double[] measurementsToDoubleArray(SensorAndMeasurements measurements, SimuComAnalysisResult.TimeseriesData dataSelection) {
        double[] measurementsArray = new double[measurements.getMeasurements().size()];
        if (measurements.getMeasurements().size() == Integer.MAX_VALUE) {
            logger.error((Object)"Too many measurements. Results might be inaccurate.");
        }
        int position = 0;
        for (Measurement time : measurements.getMeasurements()) {
            TimeSpanMeasurement tsm = (TimeSpanMeasurement)time;
            double d = measurementsArray[position++] = dataSelection == SimuComAnalysisResult.TimeseriesData.EVENTTIME ? tsm.getEventTime() : tsm.getTimeSpan();
        }
        return measurementsArray;
    }

    @Override
    protected void getUtilisationOfResource(ActiveResourceUtilisationResult resultToFill, Entity container, ResourceType resourceType) throws AnalysisFailedException {
        Sensor utilSensor = SimuComAnalysisSensorFrameworkResult.getSensorForResource(this.experiment, container, resourceType, "State of Active Resource");
        Sensor demandedSensor = SimuComAnalysisSensorFrameworkResult.getSensorForResource(this.experiment, container, resourceType, "Demand");
        if (utilSensor != null) {
            try {
                this.retrieveUtilisationFromSensor(utilSensor, (UtilisationResult)resultToFill, 1);
                resultToFill.setAverageWaitTime(Double.NaN);
                SensorAndMeasurements sam = this.run.getMeasurementsOfSensor(demandedSensor);
                resultToFill.setDemandedTime(this.calculateUnivariateStatistic(sam, SimuComAnalysisResult.TimeseriesData.TIMESPAN, (UnivariateStatistic)new Mean()));
            }
            catch (RuntimeException e) {
                resultToFill.setResourceUtilisation(Double.NaN);
                logger.error((Object)"A runtime exception occured while accessing the sendorframework. I'll try to ignore it and continue.");
                e.printStackTrace();
            }
        } else {
            resultToFill.setResourceUtilisation(Double.NaN);
            throw new AnalysisFailedException("Could not find sensor for resource " + container.getEntityName() + ": " + resourceType.getEntityName());
        }
    }
}

