/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.util;

import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.AspectRequirement;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Constraint;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Criterion;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.DeterministicEvaluationAspect;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.EnumLiteral;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.EnumOperator;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.EnumRangeValueType;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.EvaluationAspect;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Frequency;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.GenericQMLContract;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Goal;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Mean;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.NumericLiteral;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Objective;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Percentile;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.PointEstimator;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.QMLContractPackage;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.RangeValue;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.RefinedQMLContract;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Restriction;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.SetLiteral;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.SimpleQMLContract;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.StochasticEvaluationAspect;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Value;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.ValueLiteral;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Variance;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class QMLContractValidator
extends EObjectValidator {
    public static final QMLContractValidator INSTANCE = new QMLContractValidator();
    public static final String DIAGNOSTIC_SOURCE = "de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract";
    public static final int SIMPLE_QML_CONTRACT__ALL_DIMENSIO_NS_MUST_BE_FROM_SAME_CONTRACTTYPE = 1;
    public static final int CRITERION__ONLY_CONSTRAINTS_HAVE_RESTRICTIONS = 2;
    public static final int CRITERION__FREQUENCY_ONLY_POSSIBLE_IF_DIMENSION_IS_ORDERED = 3;
    public static final int CRITERION__POINTESTIMATOR_ONLY_FOR_NUMERIC_DIMENSIONS = 4;
    public static final int CRITERION__ONLY_OBJECTIVES_HAVE_GOALS = 5;
    public static final int EVALUATION_ASPECT__FREQUENCY_LIMIT_MUST_BE_NUMERIC = 6;
    public static final int EVALUATION_ASPECT__FREQUENCY_LIMIT_MUST_BE_BETWEEN_0AND_100 = 7;
    public static final int PERCENTILE__PERCENTILE_BETWEEN_0AND_100 = 8;
    public static final int FREQUENCY__RANGE_OF_FREQUENCY_MUST_HAVE_UPPERLIMIT_OR_LOWERLIMIT = 9;
    public static final int REFINED_QML_CONTRACT__CONTRACT_CANNOT_REFINE_ITSELF = 10;
    public static final int CONSTRAINT__ALL_ASPECTS_OF_CONSTRAINTS_HAVE_RESTRICTIONS = 11;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 11;
    protected static final int DIAGNOSTIC_CODE_COUNT = 11;

    protected EPackage getEPackage() {
        return QMLContractPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateSimpleQMLContract((SimpleQMLContract)value, diagnostics, context);
            }
            case 1: {
                return this.validateCriterion((Criterion)value, diagnostics, context);
            }
            case 2: {
                return this.validateEvaluationAspect((EvaluationAspect)value, diagnostics, context);
            }
            case 3: {
                return this.validateAspectRequirement((AspectRequirement)value, diagnostics, context);
            }
            case 4: {
                return this.validateValueLiteral((ValueLiteral)value, diagnostics, context);
            }
            case 5: {
                return this.validatePercentile((Percentile)value, diagnostics, context);
            }
            case 6: {
                return this.validatePointEstimator((PointEstimator)value, diagnostics, context);
            }
            case 7: {
                return this.validateStochasticEvaluationAspect((StochasticEvaluationAspect)value, diagnostics, context);
            }
            case 8: {
                return this.validateFrequency((Frequency)value, diagnostics, context);
            }
            case 9: {
                return this.validateRangeValue((RangeValue)value, diagnostics, context);
            }
            case 10: {
                return this.validateMean((Mean)value, diagnostics, context);
            }
            case 11: {
                return this.validateVariance((Variance)value, diagnostics, context);
            }
            case 12: {
                return this.validateNumericLiteral((NumericLiteral)value, diagnostics, context);
            }
            case 13: {
                return this.validateEnumLiteral((EnumLiteral)value, diagnostics, context);
            }
            case 14: {
                return this.validateSetLiteral((SetLiteral)value, diagnostics, context);
            }
            case 15: {
                return this.validateRefinedQMLContract((RefinedQMLContract)value, diagnostics, context);
            }
            case 16: {
                return this.validateValue((Value)value, diagnostics, context);
            }
            case 17: {
                return this.validateDeterministicEvaluationAspect((DeterministicEvaluationAspect)value, diagnostics, context);
            }
            case 18: {
                return this.validateObjective((Objective)value, diagnostics, context);
            }
            case 19: {
                return this.validateConstraint((Constraint)value, diagnostics, context);
            }
            case 20: {
                return this.validateRestriction((Restriction)value, diagnostics, context);
            }
            case 21: {
                return this.validateGoal((Goal)value, diagnostics, context);
            }
            case 22: {
                return this.validateGenericQMLContract((GenericQMLContract)value, diagnostics, context);
            }
            case 23: {
                return this.validateEnumOperator((EnumOperator)((Object)value), diagnostics, context);
            }
            case 24: {
                return this.validateEnumRangeValueType((EnumRangeValueType)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateSimpleQMLContract(SimpleQMLContract simpleQMLContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(simpleQMLContract, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(simpleQMLContract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(simpleQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(simpleQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(simpleQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(simpleQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(simpleQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(simpleQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(simpleQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSimpleQMLContract_all_DIMENSIONs_must_be_from_same_CONTRACTTYPE(simpleQMLContract, diagnostics, context);
        }
        return result;
    }

    public boolean validateSimpleQMLContract_all_DIMENSIONs_must_be_from_same_CONTRACTTYPE(SimpleQMLContract simpleQMLContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return simpleQMLContract.all_DIMENSIONs_must_be_from_same_CONTRACTTYPE(diagnostics, context);
    }

    public boolean validateCriterion(Criterion criterion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(criterion, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(criterion, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_Only_CONSTRAINTS_have_RESTRICTIONS(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_FREQUENCY_only_possible_if_DIMENSION_is_ordered(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_POINTESTIMATOR_only_for_numeric_dimensions(criterion, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_Only_OBJECTIVES_have_GOALS(criterion, diagnostics, context);
        }
        return result;
    }

    public boolean validateCriterion_Only_CONSTRAINTS_have_RESTRICTIONS(Criterion criterion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return criterion.Only_CONSTRAINTS_have_RESTRICTIONS(diagnostics, context);
    }

    public boolean validateCriterion_FREQUENCY_only_possible_if_DIMENSION_is_ordered(Criterion criterion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return criterion.FREQUENCY_only_possible_if_DIMENSION_is_ordered(diagnostics, context);
    }

    public boolean validateCriterion_POINTESTIMATOR_only_for_numeric_dimensions(Criterion criterion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return criterion.POINTESTIMATOR_only_for_numeric_dimensions(diagnostics, context);
    }

    public boolean validateCriterion_Only_OBJECTIVES_have_GOALS(Criterion criterion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return criterion.Only_OBJECTIVES_have_GOALS(diagnostics, context);
    }

    public boolean validateEvaluationAspect(EvaluationAspect evaluationAspect, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(evaluationAspect, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(evaluationAspect, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(evaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(evaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(evaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(evaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(evaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(evaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(evaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(evaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(evaluationAspect, diagnostics, context);
        }
        return result;
    }

    public boolean validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(EvaluationAspect evaluationAspect, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return evaluationAspect.FREQUENCY_LIMIT_must_be_NUMERIC(diagnostics, context);
    }

    public boolean validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(EvaluationAspect evaluationAspect, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return evaluationAspect.FREQUENCY_LIMIT_must_be_between_0_and_100(diagnostics, context);
    }

    public boolean validateAspectRequirement(AspectRequirement aspectRequirement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(aspectRequirement, diagnostics, context);
    }

    public boolean validateValueLiteral(ValueLiteral valueLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(valueLiteral, diagnostics, context);
    }

    public boolean validatePercentile(Percentile percentile, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(percentile, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(percentile, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(percentile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(percentile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(percentile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(percentile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(percentile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(percentile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(percentile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(percentile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(percentile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePercentile_PERCENTILE_between_0_and_100(percentile, diagnostics, context);
        }
        return result;
    }

    public boolean validatePercentile_PERCENTILE_between_0_and_100(Percentile percentile, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return percentile.PERCENTILE_between_0_and_100(diagnostics, context);
    }

    public boolean validatePointEstimator(PointEstimator pointEstimator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(pointEstimator, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(pointEstimator, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(pointEstimator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(pointEstimator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(pointEstimator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(pointEstimator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(pointEstimator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(pointEstimator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(pointEstimator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(pointEstimator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(pointEstimator, diagnostics, context);
        }
        return result;
    }

    public boolean validateStochasticEvaluationAspect(StochasticEvaluationAspect stochasticEvaluationAspect, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(stochasticEvaluationAspect, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(stochasticEvaluationAspect, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(stochasticEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(stochasticEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(stochasticEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(stochasticEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(stochasticEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(stochasticEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(stochasticEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(stochasticEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(stochasticEvaluationAspect, diagnostics, context);
        }
        return result;
    }

    public boolean validateFrequency(Frequency frequency, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(frequency, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(frequency, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(frequency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(frequency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(frequency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(frequency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(frequency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(frequency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(frequency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(frequency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(frequency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFrequency_range_of_FREQUENCY_must_have_UPPERLIMIT_or_LOWERLIMIT(frequency, diagnostics, context);
        }
        return result;
    }

    public boolean validateFrequency_range_of_FREQUENCY_must_have_UPPERLIMIT_or_LOWERLIMIT(Frequency frequency, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return frequency.range_of_FREQUENCY_must_have_UPPERLIMIT_or_LOWERLIMIT(diagnostics, context);
    }

    public boolean validateRangeValue(RangeValue rangeValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(rangeValue, diagnostics, context);
    }

    public boolean validateMean(Mean mean, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(mean, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(mean, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(mean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(mean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(mean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(mean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(mean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(mean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(mean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(mean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(mean, diagnostics, context);
        }
        return result;
    }

    public boolean validateVariance(Variance variance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(variance, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(variance, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(variance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(variance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(variance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(variance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(variance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(variance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(variance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(variance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(variance, diagnostics, context);
        }
        return result;
    }

    public boolean validateNumericLiteral(NumericLiteral numericLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(numericLiteral, diagnostics, context);
    }

    public boolean validateEnumLiteral(EnumLiteral enumLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(enumLiteral, diagnostics, context);
    }

    public boolean validateSetLiteral(SetLiteral setLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(setLiteral, diagnostics, context);
    }

    public boolean validateRefinedQMLContract(RefinedQMLContract refinedQMLContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(refinedQMLContract, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(refinedQMLContract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(refinedQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(refinedQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(refinedQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(refinedQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(refinedQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(refinedQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(refinedQMLContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRefinedQMLContract_contract_cannot_refine_itself(refinedQMLContract, diagnostics, context);
        }
        return result;
    }

    public boolean validateRefinedQMLContract_contract_cannot_refine_itself(RefinedQMLContract refinedQMLContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return refinedQMLContract.contract_cannot_refine_itself(diagnostics, context);
    }

    public boolean validateValue(Value value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(value, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(value, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(value, diagnostics, context);
        }
        return result;
    }

    public boolean validateDeterministicEvaluationAspect(DeterministicEvaluationAspect deterministicEvaluationAspect, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(deterministicEvaluationAspect, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(deterministicEvaluationAspect, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(deterministicEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(deterministicEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(deterministicEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(deterministicEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(deterministicEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(deterministicEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(deterministicEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_NUMERIC(deterministicEvaluationAspect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEvaluationAspect_FREQUENCY_LIMIT_must_be_between_0_and_100(deterministicEvaluationAspect, diagnostics, context);
        }
        return result;
    }

    public boolean validateObjective(Objective objective, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(objective, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(objective, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_Only_CONSTRAINTS_have_RESTRICTIONS(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_FREQUENCY_only_possible_if_DIMENSION_is_ordered(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_POINTESTIMATOR_only_for_numeric_dimensions(objective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_Only_OBJECTIVES_have_GOALS(objective, diagnostics, context);
        }
        return result;
    }

    public boolean validateConstraint(Constraint constraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(constraint, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(constraint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_Only_CONSTRAINTS_have_RESTRICTIONS(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_FREQUENCY_only_possible_if_DIMENSION_is_ordered(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_POINTESTIMATOR_only_for_numeric_dimensions(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCriterion_Only_OBJECTIVES_have_GOALS(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConstraint_All_ASPECTS_of_CONSTRAINTS_have_RESTRICTIONS(constraint, diagnostics, context);
        }
        return result;
    }

    public boolean validateConstraint_All_ASPECTS_of_CONSTRAINTS_have_RESTRICTIONS(Constraint constraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return constraint.All_ASPECTS_of_CONSTRAINTS_have_RESTRICTIONS(diagnostics, context);
    }

    public boolean validateRestriction(Restriction restriction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(restriction, diagnostics, context);
    }

    public boolean validateGoal(Goal goal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(goal, diagnostics, context);
    }

    public boolean validateGenericQMLContract(GenericQMLContract genericQMLContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genericQMLContract, diagnostics, context);
    }

    public boolean validateEnumOperator(EnumOperator enumOperator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateEnumRangeValueType(EnumRangeValueType enumRangeValueType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

