/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class ConfigurationHelper {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
    private static ConfigurationHelper helper = new ConfigurationHelper();
    private List<ILaunchConfiguration> rememberedLaunchConfigs = new ArrayList<ILaunchConfiguration>();

    public ILaunchConfiguration updateConfig(ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = configuration.copy(String.valueOf(configuration.getName()) + "-c");
        this.copyAndMarkAttribute("allocationFile", configuration, workingCopy);
        this.copyAndMarkAttribute("systemFile", configuration, workingCopy);
        this.copyAndMarkAttribute("usageFile", configuration, workingCopy);
        workingCopy.setAttribute("experimentRun", String.valueOf(configuration.getName()) + "-c");
        workingCopy.setAttribute("shouldThrowException", false);
        ILaunchConfiguration newLaunchConfig = workingCopy.doSave();
        this.rememberedLaunchConfigs.add(newLaunchConfig);
        return newLaunchConfig;
    }

    public void copyAndMarkAttribute(String id, ILaunchConfiguration original, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        String suffix = "-c";
        String fileName = original.getAttribute(id, "");
        String newFileName = this.appendToFilename(suffix, fileName);
        workingCopy.setAttribute(id, newFileName);
    }

    private String appendToFilename(String fileNameSuffix, String fileName) {
        int indexOfLastDot = fileName.lastIndexOf(".");
        if (indexOfLastDot < 1) {
            return String.valueOf(fileName) + fileNameSuffix;
        }
        return String.valueOf(fileName.substring(0, indexOfLastDot)) + fileNameSuffix + fileName.substring(indexOfLastDot);
    }

    public void cleanUp() {
        for (ILaunchConfiguration config : this.rememberedLaunchConfigs) {
            try {
                config.delete();
            }
            catch (CoreException e) {
                logger.warn((Object)"Could not clean up the launch configs, thus some will stay in your run dialog.");
                e.printStackTrace();
            }
        }
    }

    public static ConfigurationHelper getInstance() {
        return helper;
    }
}

