/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.ITactic;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEDecoder;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEObjectives;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EntryLevelSystemCallCriterion;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.UsageScenarioBasedCriterion;
import de.uka.ipd.sdq.dsexplore.qml.pcm.reader.PCMDeclarationsReader;
import de.uka.ipd.sdq.pcm.designdecision.Candidates;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.Constraint;
import org.opt4j.core.Criterion;
import org.opt4j.core.Individual;
import org.opt4j.core.IntegerValue;
import org.opt4j.core.Objective;
import org.opt4j.core.Value;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.LinkingResourceResults;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.solver.models.PCMInstance;

public class ResultsWriter {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.ResultsWriter");
    private static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    private String myfilename;
    FileWriter fileWriter;
    private List<Criterion> criteriaToSave;
    private List<Criterion> criteriaWithConfidence;

    public ResultsWriter(String filename) {
        this.myfilename = String.valueOf(filename) + "_" + ResultsWriter.getTimeDateString() + ".csv";
        try {
            this.fileWriter = new FileWriter(this.myfilename);
        }
        catch (IOException e) {
            logger.error((Object)("Cannot write to file " + this.myfilename + " to store individuals. I will print them to the logger instead. Cause: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void writeDSEIndividualsToFile(Collection<DSEIndividual> individuals, String filename, int iteration, boolean asEMF, boolean asCVS, List<Exception> exceptionList) {
        if (individuals.size() > 0) {
            if (asCVS) {
                StringBuilder results = ResultsWriter.addResultsToCSVString(individuals, exceptionList);
                ResultsWriter.writeToNewFile(filename, results, iteration, exceptionList, ".csv");
            }
            if (asEMF) {
                Candidates candidates = EMFHelper.createEMFCandidates(individuals);
                EMFHelper.saveToXMIFile((EObject)candidates, ResultsWriter.getFilenameForIteration(filename, iteration, ".designdecision"));
            }
        }
    }

    public static void writeIndividualsToFile(Collection<Individual> individuals, String filename, int iteration, List<Exception> exceptionList, boolean asEMF, boolean asCSV) {
        ArrayList<DSEIndividual> dseIndList = new ArrayList<DSEIndividual>(individuals.size());
        for (Individual ind : individuals) {
            if (!(ind instanceof DSEIndividual)) continue;
            dseIndList.add((DSEIndividual)ind);
        }
        ResultsWriter.writeDSEIndividualsToFile(dseIndList, filename, iteration, asEMF, asCSV, exceptionList);
    }

    public static void writeStringToFile(String filename, String content, int iteration, List<Exception> exceptionList, String fileEnding) {
        ResultsWriter.writeToNewFile(filename, new StringBuilder(content), iteration, exceptionList, fileEnding);
    }

    public static void printOutIndividuals(Collection<DSEIndividual> individuals, String collectionName) {
        if (individuals.iterator().hasNext()) {
            DSEIndividual firstIndividual = individuals.iterator().next();
            List<Criterion> criteriaToSave = ResultsWriter.determineCriterionsToSave(firstIndividual);
            List<Criterion> criteriaWithConfidence = ResultsWriter.determineCriteriaWithConfidenceInterval(firstIndividual);
            logger.warn((Object)("------------ RESULTS " + collectionName + " ----------------------"));
            logger.warn((Object)("Printing results (number is " + individuals.size() + ")."));
            ArrayList<Exception> exceptionList = new ArrayList<Exception>();
            int counter = 0;
            StringBuilder output = new StringBuilder(10000);
            logger.warn((Object)("------------ PRETTY CSV RESULTS " + collectionName + " ----------------------"));
            output.append("\n");
            output = ResultsWriter.prettyPrintHeadlineCSV(individuals, output, criteriaToSave);
            for (DSEIndividual ind2 : individuals) {
                try {
                    output = ResultsWriter.prettyPrintResultLineCSV(output, ind2, criteriaToSave, criteriaWithConfidence);
                }
                catch (Exception e) {
                    exceptionList.add(new Exception("Encountered corrupted result number " + counter + ", skipped it", e));
                }
                ++counter;
            }
            logger.warn((Object)output);
            if (exceptionList.size() > 0) {
                logger.warn((Object)"Encountered exceptions while printing results");
                for (Exception exception : exceptionList) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static String formatDouble(Double gene) {
        return Double.toString(gene);
    }

    public void writeIndividual(DSEIndividual i) {
        ArrayList<DSEIndividual> individualList = new ArrayList<DSEIndividual>(1);
        individualList.add(i);
        StringBuilder result = new StringBuilder(100);
        if (this.criteriaToSave == null) {
            this.criteriaToSave = ResultsWriter.determineCriterionsToSave(i);
            result = ResultsWriter.prettyPrintHeadlineCSV(individualList, result, this.criteriaToSave);
        }
        if (this.criteriaWithConfidence == null) {
            this.criteriaWithConfidence = ResultsWriter.determineCriteriaWithConfidenceInterval(i);
        }
        result = ResultsWriter.prettyPrintResultLineCSV(result, i, this.criteriaToSave, this.criteriaWithConfidence);
        this.write(result);
    }

    public String getFilename() {
        return this.myfilename;
    }

    public void writeTacticCandidateInfo(ITactic heuristic, Collection<TacticsResultCandidate> candidatesFromCurrentHeuristic) {
        for (TacticsResultCandidate tacticsResultCandidate : candidatesFromCurrentHeuristic) {
            StringBuilder builder = new StringBuilder(30);
            builder.append(String.valueOf(heuristic.getClass().getSimpleName()) + ";" + tacticsResultCandidate.getNumericID() + ";" + tacticsResultCandidate.getParent().getNumericID() + ";" + tacticsResultCandidate.getID() + ";" + tacticsResultCandidate.getParent().getID() + ";");
            builder = ResultsWriter.printUtilResultLine(tacticsResultCandidate.getParent(), builder);
            this.writeToLogFile(String.valueOf(builder.toString()) + "\n");
        }
    }

    public void writeTacticManagerChoice(TacticsResultCandidate c) {
        this.writeToLogFile(String.valueOf(c.getHeuristic().getClass().getSimpleName()) + ";" + c.getNumericID() + ";" + c.getParent().getNumericID() + ";" + c.getID() + ";" + c.getParent().getID() + ";candidate returned\n");
    }

    public void writeToLogFile(String entry) {
        try {
            StringBuilder out = new StringBuilder(50);
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
            out.append(String.valueOf(sdf.format(cal.getTime())) + ";" + entry);
            this.write(out);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public void flush() {
        try {
            this.fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.flush();
                this.fileWriter.close();
                this.fileWriter = null;
            }
            catch (IOException e) {
                logger.error((Object)("Cannot close the file handle " + this.myfilename + ". Your results might be lost. Cause: " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static StringBuilder addResultsToCSVString(Collection<DSEIndividual> individuals, List<Exception> exceptionList) {
        StringBuilder output = new StringBuilder(10000);
        DSEIndividual firstIndividual = individuals.iterator().next();
        List<Criterion> criteriaToSave = ResultsWriter.determineCriterionsToSave(firstIndividual);
        List<Criterion> criteriaWithConfidence = ResultsWriter.determineCriteriaWithConfidenceInterval(firstIndividual);
        output = ResultsWriter.prettyPrintHeadlineCSV(individuals, output, criteriaToSave);
        int counter = 0;
        for (DSEIndividual ind2 : individuals) {
            try {
                output = ResultsWriter.prettyPrintResultLineCSV(output, ind2, criteriaToSave, criteriaWithConfidence);
            }
            catch (Exception e) {
                exceptionList.add(new Exception("Encountered corrupted result number " + counter + ", skipped it", e));
            }
            ++counter;
        }
        return output;
    }

    private static List<Criterion> determineCriteriaWithConfidenceInterval(DSEIndividual firstIndividual) {
        DSEObjectives objs = firstIndividual.getObjectives();
        ArrayList<Criterion> criteriaWithConfidence = new ArrayList<Criterion>();
        if (objs != null && objs.size() > 0) {
            ArrayList<String> coveredDimensions = new ArrayList<String>();
            for (Objective objective : objs.getKeys()) {
                if (objs.getConfidenceIntervalForObjective((Criterion)objective) == null) continue;
                criteriaWithConfidence.add((Criterion)objective);
                coveredDimensions.add(ResultsWriter.getDimensionName((Criterion)objective));
            }
            for (Constraint constraint : objs.getConstraints().getKeys()) {
                if (coveredDimensions.contains(ResultsWriter.getDimensionName((Criterion)constraint)) || objs.getConfidenceIntervalForObjective((Criterion)constraint) == null) continue;
                criteriaWithConfidence.add((Criterion)constraint);
            }
        }
        return criteriaWithConfidence;
    }

    private static void writeToNewFile(String filename, StringBuilder results, int iteration, List<Exception> exceptionList, String fileEnding) {
        filename = ResultsWriter.getFilenameForIteration(filename, iteration, fileEnding);
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename)));
            w.write(results.toString());
            w.flush();
            w.close();
        }
        catch (FileNotFoundException e) {
            exceptionList.add(e);
            e.printStackTrace();
        }
        catch (IOException e) {
            exceptionList.add(e);
            e.printStackTrace();
        }
    }

    private static String getFilenameForIteration(String basicFilename, int iteration, String fileEnding) {
        return String.valueOf(basicFilename) + iteration + "_" + ResultsWriter.getTimeDateString() + fileEnding;
    }

    private static StringBuilder prettyPrintResultLineCSV(StringBuilder output, DSEIndividual ind, List<Criterion> criterionsToSave, List<Criterion> criteriaWithConfidence) {
        DesignDecisionGenotype genes;
        DSEObjectives objs = ind.getObjectives();
        for (Criterion o : criterionsToSave) {
            if (objs != null) {
                output.append(String.valueOf(ResultsWriter.formatValue(objs.getValueForCriterion(o))) + ";");
                continue;
            }
            output.append(String.valueOf(ResultsWriter.formatDouble(Double.NaN)) + ";");
        }
        if (ind.getPhenotype() instanceof PCMPhenotype) {
            for (Criterion o : criteriaWithConfidence) {
                ConfidenceInterval c = objs.getConfidenceIntervalForObjective(o);
                if (c != null) {
                    output.append(String.valueOf(c.getLowerBound()) + ";" + c.getUpperBound() + ";" + c.getLevel() + ";");
                    continue;
                }
                output.append("NaN;NaN;NaN;");
            }
        }
        if ((genes = ind.getGenotype()).size() == 0) {
            logger.error((Object)"Encountered empty genotype, filling it with blanks");
            int problemsize = Opt4JStarter.getProblem().getDesignDecisions().size();
            int i = 0;
            while (i < problemsize) {
                output.append(";");
                ++i;
            }
        } else {
            output.append(DSEDecoder.getGenotypeString(genes));
        }
        output = ResultsWriter.printUtilResultLine(ind, output);
        output.append(String.valueOf(((PCMPhenotype)ind.getPhenotype()).getNumericID()) + ";");
        output.append("\n");
        return output;
    }

    private static StringBuilder printUtilResultLine(DSEIndividual ind, StringBuilder output) {
        DSEObjectives obs = ind.getObjectives();
        if (obs instanceof DSEObjectives) {
            DSEObjectives dseObj = obs;
            Iterator iterator = dseObj.iterator();
            while (iterator.hasNext()) {
                Map.Entry o = (Map.Entry)iterator.next();
                if (!dseObj.hasResultDecoratorFor((Criterion)o.getKey())) continue;
                ResultDecoratorRepository results = dseObj.getResultDecoratorFor((Criterion)o.getKey());
                EList utilisations = results.getUtilisationResults_ResultDecoratorRepository();
                PCMInstance pcm = Opt4JStarter.getProblem().getInitialInstance();
                EList containers = pcm.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
                EList links = pcm.getResourceEnvironment().getLinkingResources__ResourceEnvironment();
                if (utilisations != null) {
                    for (ResourceContainer resourceContainer : containers) {
                        for (ProcessingResourceSpecification processingResourceSpecification : resourceContainer.getActiveResourceSpecifications_ResourceContainer()) {
                            for (UtilisationResult utilisationResult : utilisations) {
                                ProcessingResourceSpecificationResult procResResult;
                                if (!(utilisationResult instanceof ProcessingResourceSpecificationResult) || !EMFHelper.checkIdentity((EObject)((ResourceContainer)(procResResult = (ProcessingResourceSpecificationResult)utilisationResult).getProcessingResourceSpecification_ProcessingResourceSpecificationResult().eContainer()), (EObject)resourceContainer) || !EMFHelper.checkIdentity((EObject)procResResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getActiveResourceType_ActiveResourceSpecification(), (EObject)processingResourceSpecification.getActiveResourceType_ActiveResourceSpecification())) continue;
                                output.append(procResResult.getResourceUtilisation());
                                break;
                            }
                            output.append(";");
                        }
                    }
                    for (LinkingResource linkingResource : links) {
                        for (UtilisationResult utilisationResult : utilisations) {
                            LinkingResourceResults linkResult;
                            if (!(utilisationResult instanceof LinkingResourceResults) || !EMFHelper.checkIdentity((EObject)(linkResult = (LinkingResourceResults)utilisationResult).getLinkingResource_LinkingResourceResults(), (EObject)linkingResource)) continue;
                            output.append(linkResult.getResourceUtilisation());
                            break;
                        }
                        output.append(";");
                    }
                    continue;
                }
                int i = 0;
                while (i < containers.size() + links.size()) {
                    output.append(";");
                    ++i;
                }
            }
        }
        return output;
    }

    private static StringBuilder prettyPrintHeadlineCSV(Collection<DSEIndividual> individuals, StringBuilder output, List<Criterion> criterionsToSave) {
        if (individuals.size() > 0) {
            DSEIndividual i = individuals.iterator().next();
            output = ResultsWriter.printObjectives(criterionsToSave, output);
            output = ResultsWriter.determineAndPrintConfidenceIntervalHeadline(output, i.getObjectives(), criterionsToSave);
            output.append(Opt4JStarter.getProblem().toString());
            output = ResultsWriter.printUtilisationHeadline(i, output);
            output.append("Candidate ID;");
            output.append("\n");
        }
        return output;
    }

    private static StringBuilder printUtilisationHeadline(DSEIndividual i, StringBuilder output) {
        DSEObjectives obs = i.getObjectives();
        if (obs instanceof DSEObjectives) {
            DSEObjectives dseObj = obs;
            Iterator iterator = dseObj.iterator();
            while (iterator.hasNext()) {
                Map.Entry o = (Map.Entry)iterator.next();
                if (!dseObj.hasResultDecoratorFor((Criterion)o.getKey())) continue;
                PCMInstance pcm = Opt4JStarter.getProblem().getInitialInstance();
                EList containers = pcm.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
                for (ResourceContainer resourceContainer : containers) {
                    EList procResource = resourceContainer.getActiveResourceSpecifications_ResourceContainer();
                    for (ProcessingResourceSpecification processingResourceSpecification : procResource) {
                        ProcessingResourceType procType = processingResourceSpecification.getActiveResourceType_ActiveResourceSpecification();
                        output.append("Util of " + resourceContainer.getEntityName() + " " + procType.getEntityName() + ";");
                    }
                }
                EList links = pcm.getResourceEnvironment().getLinkingResources__ResourceEnvironment();
                for (LinkingResource linkingResource : links) {
                    output.append("Util of " + linkingResource.getEntityName() + " " + linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification().getEntityName() + ";");
                }
            }
        }
        return output;
    }

    private static StringBuilder determineAndPrintConfidenceIntervalHeadline(StringBuilder output, DSEObjectives objs, List<Criterion> criterionsToSave) {
        for (Criterion criterion : criterionsToSave) {
            ConfidenceInterval c = objs.getConfidenceIntervalForObjective(criterion);
            if (c == null) continue;
            output.append("lower bound confidence(" + ResultsWriter.getDimensionName(criterion) + ");" + "upper bound confidence" + "(" + ResultsWriter.getDimensionName(criterion) + ");" + "alpha" + "(" + ResultsWriter.getDimensionName(criterion) + ");");
        }
        return output;
    }

    private static List<Criterion> determineCriterionsToSave(DSEIndividual i) {
        DSEObjectives objs = i.getObjectives();
        ArrayList<Criterion> criterionsToSave = new ArrayList<Criterion>();
        if (objs != null && objs.size() != 0) {
            criterionsToSave.addAll(objs.getKeys());
            Collection constraints = objs.getConstraints().getKeys();
            for (Constraint constraint : constraints) {
                boolean hasToBeAdded = true;
                for (Criterion coveredCriterion : criterionsToSave) {
                    if (!ResultsWriter.getDimensionName((Criterion)constraint).equals(ResultsWriter.getDimensionName(coveredCriterion))) continue;
                    hasToBeAdded = false;
                    break;
                }
                if (!hasToBeAdded) continue;
                criterionsToSave.add((Criterion)constraint);
            }
        }
        return criterionsToSave;
    }

    private static String formatValue(Value<?> value) {
        if (value instanceof IntegerValue) {
            IntegerValue intValue = (IntegerValue)value;
            return String.valueOf(intValue);
        }
        double d = value.getDouble();
        return ResultsWriter.formatDouble(d);
    }

    private static StringBuilder printObjectives(List<Criterion> criterionsToSave, StringBuilder output) {
        for (Criterion entry : criterionsToSave) {
            output.append(String.valueOf(ResultsWriter.getDimensionName(entry)) + ";");
        }
        return output;
    }

    private static String getTimeDateString() {
        Date date = new Date();
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        String stringDate = simpleFormat.format(date);
        stringDate = stringDate.replaceAll(":", "-").replaceAll(" ", "_");
        return stringDate;
    }

    private void write(StringBuilder result) {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.write(result.toString());
                this.fileWriter.flush();
            }
            catch (IOException e) {
                logger.error((Object)("Cannot write to file " + this.myfilename + " Logging the result at level INFO now. Cause: " + e.getMessage()));
                logger.info((Object)result.toString());
            }
        } else {
            logger.info((Object)result.toString());
        }
    }

    public static String getDimensionName(Criterion criterion) {
        EvaluationAspectWithContext qmlCriterion = PCMDeclarationsReader.retranslateCriterionToEvaluationAspect((Criterion)criterion);
        String name = qmlCriterion.getDimension().getEntityName();
        if (criterion instanceof UsageScenarioBasedCriterion) {
            name = String.valueOf(name) + ":" + ((UsageScenarioBasedCriterion)criterion).getUsageScenario().getEntityName();
        } else if (criterion instanceof EntryLevelSystemCallCriterion) {
            name = String.valueOf(name) + ":" + ((EntryLevelSystemCallCriterion)criterion).getEntryLevelSystemCall().getEntityName();
        }
        return name;
    }
}

