/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.operator;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.exception.ChoiceOutOfBoundsException;
import de.uka.ipd.sdq.dsexplore.exception.InvalidChoiceForDegreeException;
import de.uka.ipd.sdq.dsexplore.gdof.GenomeToCandidateModelTransformation;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousRangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteRangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.OrderedIntegerDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Genotype;
import org.opt4j.genotype.DoubleGenotype;
import org.opt4j.genotype.IntegerGenotype;
import org.opt4j.operator.mutate.Mutate;
import org.opt4j.operator.mutate.MutateDouble;
import org.opt4j.operator.mutate.MutateInteger;
import org.opt4j.operator.mutate.MutationRate;

public class MutateDesignDecisionGenotype
implements Mutate<DesignDecisionGenotype> {
    private MutateInteger mutateInteger;
    private MutateDouble mutateDouble;
    private MutationRate mutationRate;
    private Rand random;

    @Inject
    public MutateDesignDecisionGenotype(Rand random, MutateInteger mutateInteger, MutateDouble mutateDouble, MutationRate rate) {
        this.mutateDouble = mutateDouble;
        this.mutateInteger = mutateInteger;
        this.mutationRate = rate;
        this.random = random;
    }

    public void mutate(DesignDecisionGenotype genotype, double mutationRate) {
        Iterator<Choice> iterator = genotype.iterator();
        while (iterator.hasNext()) {
            Choice choice = iterator.next();
            if (!(this.random.nextDouble() < mutationRate)) continue;
            if (choice instanceof DiscreteRangeChoice) {
                this.mutateDiscrete((DiscreteRangeChoice)choice);
                continue;
            }
            if (choice instanceof ClassChoice) {
                this.mutateEnum((ClassChoice)choice);
                continue;
            }
            if (choice instanceof ContinousRangeChoice) {
                this.mutateContinous((ContinousRangeChoice)choice);
                continue;
            }
            if (choice.getDegreeOfFreedomInstance().getDof() != null) {
                Collection<Object> possibleValues = GenomeToCandidateModelTransformation.valueRuleForCollection(choice.getDegreeOfFreedomInstance().getDof().getPrimaryChangeable(), choice.getDegreeOfFreedomInstance().getPrimaryChanged(), GenomeToCandidateModelTransformation.getPCMRootElements(Opt4JStarter.getProblem().getInitialInstance()));
                this.mutateDiscrete(choice, possibleValues);
                continue;
            }
            throw new UnsupportedOperationException("Choice type " + choice + " not supported.");
        }
    }

    private void mutateDiscrete(Choice choice, Collection<Object> possibleValues) {
        ArrayList<Object> list = possibleValues instanceof List ? (ArrayList<Object>)possibleValues : new ArrayList<Object>(possibleValues);
        int index = -1;
        int i = 0;
        for (Object e : list) {
            if (choice.getValue().equals(e)) {
                index = i;
                break;
            }
            ++i;
        }
        int n = this.randomlySelectNewIndex(list, index);
        choice.setValue(list.get(n));
    }

    private int randomlySelectNewIndex(List<?> domain, int oldIndex) {
        int newIndex = this.mutateInteger(oldIndex, 0, domain.size() - 1);
        if (newIndex < 0 || newIndex >= domain.size()) {
            throw new RuntimeException("Error when mutating integer index value: Value is out of bounds!");
        }
        return newIndex;
    }

    private void mutateContinous(ContinousRangeChoice choice) {
        DegreeOfFreedomInstance degree = choice.getDegreeOfFreedomInstance();
        if (!(degree instanceof ContinuousRangeDegree)) {
            throw new InvalidChoiceForDegreeException((Choice)choice);
        }
        ContinuousRangeDegree contDegree = (ContinuousRangeDegree)degree;
        DoubleGenotype doubleList = new DoubleGenotype(contDegree.getFrom(), contDegree.getTo());
        doubleList.add((Object)choice.getChosenValue());
        this.mutateDouble.mutate(doubleList, this.mutationRate.get());
        double newValue = (Double)doubleList.get(0);
        choice.setChosenValue(newValue);
    }

    private void mutateEnum(ClassChoice choice) {
        DegreeOfFreedomInstance degree = choice.getDegreeOfFreedomInstance();
        if (degree instanceof ClassDegree) {
            ClassDegree enumDegree = (ClassDegree)degree;
            int oldIndex = enumDegree.getClassDesignOptions().indexOf((Object)choice.getChosenValue());
            if (oldIndex == -1) {
                throw new ChoiceOutOfBoundsException(choice, "Error when mutating individual, old choice was invalid");
            }
            int newIndex = this.randomlySelectNewIndex((List<?>)enumDegree.getClassDesignOptions(), oldIndex);
            choice.setChosenValue((EObject)enumDegree.getClassDesignOptions().get(newIndex));
        }
    }

    private void mutateDiscrete(DiscreteRangeChoice choice) {
        DegreeOfFreedomInstance degree = choice.getDegreeOfFreedomInstance();
        if (degree instanceof DiscreteRangeDegree) {
            DiscreteRangeDegree discDegree = (DiscreteRangeDegree)degree;
            int newValue = this.mutateInteger(choice.getChosenValue(), discDegree.getFrom(), discDegree.getTo());
            choice.setChosenValue(newValue);
        } else if (degree instanceof OrderedIntegerDegree) {
            OrderedIntegerDegree orderedIntegerDegree = (OrderedIntegerDegree)degree;
            int currentIndex = orderedIntegerDegree.getListOfIntegers().indexOf((Object)new Integer(choice.getChosenValue()));
            int randomIndex = this.mutateInteger(currentIndex, 0, orderedIntegerDegree.getListOfIntegers().size() - 1);
            choice.setChosenValue(((Integer)orderedIntegerDegree.getListOfIntegers().get(randomIndex)).intValue());
        } else {
            throw new InvalidChoiceForDegreeException((Choice)choice);
        }
    }

    private int mutateInteger(int oldValue, int lowerBound, int upperBound) {
        IntegerGenotype integerGenotype = new IntegerGenotype(lowerBound, upperBound);
        integerGenotype.add((Object)oldValue);
        this.mutateInteger.mutate((Genotype)integerGenotype, this.mutationRate.get());
        int newValue = (Integer)integerGenotype.get(0);
        return newValue;
    }
}

