/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.QMLBoundDependentTacticOperatorsManager;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticOperatorsManager;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import java.util.ArrayList;
import java.util.Collection;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.operator.copy.Copy;
import org.opt4j.operator.crossover.Crossover;
import org.opt4j.operator.mutate.Mutate;
import org.opt4j.operator.mutate.MutationRate;
import org.opt4j.optimizer.ea.Coupler;
import org.opt4j.optimizer.ea.CrossoverRate;
import org.opt4j.optimizer.ea.MatingCrossoverMutate;
import org.opt4j.optimizer.ea.Pair;

public class MatingWithHeuristics
extends MatingCrossoverMutate {
    private TacticOperatorsManager heuristicManager;

    public TacticOperatorsManager getHeuristicManager() {
        return this.heuristicManager;
    }

    @Inject
    public MatingWithHeuristics(Crossover<Genotype> crossover, Mutate<Genotype> mutate, Copy<Genotype> copy, Coupler coupler, CrossoverRate crossoverRate, MutationRate mutationRate, Rand random, IndividualFactory individualFactory, QMLBoundDependentTacticOperatorsManager qmlTacticManager) {
        super(crossover, mutate, copy, coupler, crossoverRate, mutationRate, random, individualFactory);
        if (Opt4JStarter.getDSEWorkflowConfig().isConsiderQMLBoundsWhenApplyingHeuristics()) {
            this.heuristicManager = qmlTacticManager;
        } else if (Opt4JStarter.getDSEWorkflowConfig().isUseHeuristics()) {
            this.heuristicManager = new TacticOperatorsManager(copy, (DSEIndividualFactory)individualFactory);
        }
    }

    public Collection<Individual> getOffspring(int size, Collection<Individual> parents) {
        ArrayList<Individual> offspring = new ArrayList<Individual>();
        Collection couples = this.coupler.getCouples((int)Math.ceil((double)size / 2.0), new ArrayList<Individual>(parents));
        for (Pair couple : couples) {
            boolean crossover = this.random.nextDouble() <= this.crossoverRate.get();
            Individual parent1 = (Individual)couple.getFirst();
            Individual parent2 = (Individual)couple.getSecond();
            Pair<Individual> i = this.mate(parent1, parent2, crossover);
            Individual i1 = (Individual)i.getFirst();
            Individual i2 = (Individual)i.getSecond();
            offspring.add(i1);
            if (offspring.size() >= size) continue;
            offspring.add(i2);
        }
        return offspring;
    }

    protected Pair<Individual> mate(Individual parent1, Individual parent2, boolean doCrossover) {
        Genotype o2;
        Genotype o1;
        Genotype p1 = parent1.getGenotype();
        Genotype p2 = parent2.getGenotype();
        DSEIndividual i1 = null;
        DSEIndividual i2 = null;
        boolean useHeuristics = Opt4JStarter.getDSEWorkflowConfig().isUseHeuristics();
        double tacticsProbability = Opt4JStarter.getDSEWorkflowConfig().getTacticsProbability();
        if (useHeuristics && Math.random() < tacticsProbability) {
            i1 = this.heuristicManager.getCandidate((DSEIndividual)parent1);
            i2 = this.heuristicManager.getCandidate((DSEIndividual)parent2);
        }
        if (i1 == null && i2 == null && doCrossover) {
            Pair offspring = this.crossover.crossover(p1, p2);
            o1 = (Genotype)offspring.getFirst();
            o2 = (Genotype)offspring.getSecond();
            this.mutate.mutate(o1, this.mutationRate.get());
            this.mutate.mutate(o2, this.mutationRate.get());
            i1 = this.individualFactory.create(o1);
            i2 = this.individualFactory.create(o2);
        }
        if (i1 == null) {
            o1 = this.copy.copy(p1);
            this.mutate.mutate(o1, this.mutationRate.get());
            i1 = this.individualFactory.create(o1);
        }
        if (i2 == null) {
            o2 = this.copy.copy(p2);
            this.mutate.mutate(o2, this.mutationRate.get());
            i2 = this.individualFactory.create(o2);
        }
        Pair individuals = new Pair((Object)i1, i2);
        return individuals;
    }
}

