/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators;

import de.uka.ipd.sdq.dsexplore.helper.ResultsWriter;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.ITactic;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticOperatorsFactory;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.UtilisationResultCacheAndHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.opt4j.core.Genotype;
import org.opt4j.operator.copy.Copy;

public class TacticOperatorsManager {
    protected Collection<ITactic> heuristics = new ArrayList<ITactic>();
    protected ResultsWriter writer;
    protected Random generator = new Random();

    public TacticOperatorsManager(Copy<Genotype> copy, DSEIndividualFactory individualFactory) {
        DSEWorkflowConfiguration configuration = Opt4JStarter.getDSEWorkflowConfig();
        this.heuristics = TacticOperatorsFactory.getActivatedInstances(copy, individualFactory, configuration);
        this.writer = new ResultsWriter(String.valueOf(Opt4JStarter.getDSEWorkflowConfig().getResultFolder()) + "heuristicsInfo");
        this.writer.writeToLogFile("Tactic;Candidate numeric id;Parent numeric id;Candidate genome (several cols);Parent genome (several cols);Utilization value and whether returned\n");
    }

    public List<TacticsResultCandidate> getAllCandidates(DSEIndividual individual) {
        UtilisationResultCacheAndHelper resultsCache = new UtilisationResultCacheAndHelper();
        ArrayList<TacticsResultCandidate> result = new ArrayList<TacticsResultCandidate>();
        for (ITactic heuristic : this.heuristics) {
            List<TacticsResultCandidate> candidatesFromCurrentHeuristic = heuristic.getHeuristicCandidates(individual, resultsCache);
            if (candidatesFromCurrentHeuristic.size() <= 0) continue;
            this.writer.writeTacticCandidateInfo(heuristic, candidatesFromCurrentHeuristic);
            result.addAll(candidatesFromCurrentHeuristic);
        }
        return result;
    }

    public DSEIndividual getCandidate(DSEIndividual individual) {
        List<TacticsResultCandidate> candidates = this.getAllCandidates(individual);
        double sumOfAllWeights = 0.0;
        for (TacticsResultCandidate c : candidates) {
            sumOfAllWeights += c.getFinalWeight();
        }
        double threshold = this.generator.nextDouble() * sumOfAllWeights;
        double currentLevel = 0.0;
        for (TacticsResultCandidate c : candidates) {
            if (!((currentLevel += c.getFinalWeight()) >= threshold)) continue;
            this.writer.writeTacticManagerChoice(c);
            return c;
        }
        if (candidates.size() > 0) {
            throw new RuntimeException("Random selection failed.");
        }
        return null;
    }

    public Collection<ITactic> getHeuristics() {
        return this.heuristics;
    }
}

