/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.start;

import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.exception.ExceptionHelper;
import de.uka.ipd.sdq.dsexplore.helper.GenotypeReader;
import de.uka.ipd.sdq.dsexplore.helper.ResultsWriter;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.archive.PopulationTracker;
import de.uka.ipd.sdq.dsexplore.opt4j.archive.PopulationTrackerModule;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.operator.BinaryBayesOperator;
import de.uka.ipd.sdq.dsexplore.opt4j.operator.UniformDesignDecisionGenotypeCrossover;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.MatingBayes;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.MatingWithHeuristics;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSECreator;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEDecoder;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEEvaluator;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEEvolutionaryAlgorithmModule;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEModule;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEMutateModule;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEProblem;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.GivenInstanceModule;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.RuleBasedSearchModule;
import de.uka.ipd.sdq.dsexplore.opt4j.start.DSEListener;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.UsageScenarioBasedObjective;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.tcfmoop.config.GivenParetoFrontIsReachedConfig;
import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.InsignificantSetQualityImprovementConfig;
import de.uka.ipd.sdq.tcfmoop.config.MinimalQualityCriteriaValueConfig;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;
import de.uka.ipd.sdq.tcfmoop.tcmanager.TerminationCriteriaManager;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.opt4j.config.Task;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.Objective;
import org.opt4j.core.Value;
import org.opt4j.core.domination.ConstraintDominationModule;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.operator.crossover.Crossover;
import org.opt4j.optimizer.ea.Mating;
import org.opt4j.optimizer.ea.ScalingNsga2Module;
import org.opt4j.optimizer.rs.RandomSearchModule;
import org.opt4j.start.Opt4J;
import org.opt4j.start.Opt4JTask;
import org.palladiosimulator.solver.models.PCMInstance;

public class Opt4JStarter {
    private static DSEProblem problem = null;
    private static DSECreator creator = null;
    private static Opt4JTask task = null;
    private static DSEWorkflowConfiguration myDSEConfig = null;
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter");
    private static List<ResultsWriter> writers = null;

    public static void init(List<IAnalysis> evaluators, DSEWorkflowConfiguration dseConfig, PCMInstance pcmInstance, IProgressMonitor monitor, MDSDBlackboard blackboard) throws CoreException {
        myDSEConfig = dseConfig;
        ArrayList<Module> modules = new ArrayList<Module>();
        DSEModule dseModule = new DSEModule();
        modules.add((Module)dseModule);
        Opt4JStarter.addOptimisationModules(dseConfig.getMaxIterations(), dseConfig, modules);
        Opt4JStarter.addPopulationModule(modules);
        ConstraintDominationModule m = new ConstraintDominationModule();
        m.setStrategyForFeasibleSolutions(ConstraintDominationModule.Strategy.GoalAttainmentDomination);
        modules.add((Module)m);
        ScalingNsga2Module nsgaModule = new ScalingNsga2Module();
        nsgaModule.setTournament(3);
        modules.add((Module)nsgaModule);
        Opt4JStarter.openTask(modules);
        writers = new LinkedList<ResultsWriter>();
        problem = new DSEProblem(dseConfig, pcmInstance);
        if (dseConfig.isNewProblem()) {
            problem.saveProblem();
        }
        GenotypeReader.setTask(task);
        DSEEvaluator ev = (DSEEvaluator)task.getInstance(DSEEvaluator.class);
        ev.init(evaluators, monitor, blackboard, dseConfig.isStopOnInitialFailure());
        if (myDSEConfig.getUseTerminationCriteria()) {
            TerminationCriteriaManager tcm = (TerminationCriteriaManager)task.getInstance(TerminationCriteriaManager.class);
            Opt4JStarter.resolveObjectivesForTCM();
            tcm.initialize(myDSEConfig.getTCConfigurations());
            if (myDSEConfig.getActivateComposedTerminationCriteria()) {
                tcm.activateComposedCriterion();
                tcm.setComposedCriterionExpression(myDSEConfig.getComposedCriteriaExpression());
            }
            if (myDSEConfig.getRunInComparisionMode()) {
                tcm.activateTCComparisionMode();
            }
        }
    }

    public static void openTask(Collection<Module> modules) {
        task = new Opt4JTask(false);
        task.init(modules);
        task.open();
    }

    public static void runOpt4JWithPopulation(DSEWorkflowConfiguration dseConfig, IProgressMonitor monitor, List<DesignDecisionGenotype> genotypes, List<DesignDecisionGenotype> allCandidates, List<DesignDecisionGenotype> archiveCandidates) throws CoreException {
        if (problem == null) {
            throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", 0, "Opt4JStarter has not been properly initialised. Contact developers.", null));
        }
        if (genotypes != null && genotypes.size() > 0) {
            problem.setInitialPopulation(genotypes);
        }
        DSEListener listener = new DSEListener(monitor, dseConfig);
        Opt4JStarter.runTask(listener, dseConfig, allCandidates, archiveCandidates);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runTask(DSEListener listener, DSEWorkflowConfiguration dseConfig, List<DesignDecisionGenotype> allCandidates, List<DesignDecisionGenotype> archiveCandidates) throws CoreException {
        block17: {
            List<Exception> exceptions;
            try {
                try {
                    creator = (DSECreator)task.getInstance(DSECreator.class);
                    Optimizer opt = (Optimizer)task.getInstance(Optimizer.class);
                    opt.addOptimizerIterationListener((OptimizerIterationListener)listener);
                    DSEIndividualFactory indivBuilder = Opt4JStarter.getIndividualFactory();
                    PopulationTracker populationTracker = Opt4JStarter.getAllIndividuals();
                    Archive archive = Opt4JStarter.getArchiveIndividuals();
                    IndividualCompleter completer = (IndividualCompleter)task.getInstance(IndividualCompleter.class);
                    if (allCandidates != null && allCandidates.size() > 0 && indivBuilder instanceof DSEIndividualFactory) {
                        logger.debug((Object)"Reading in predefined all candidates.");
                        DSEIndividualFactory dseBuilder = indivBuilder;
                        Iterator<DesignDecisionGenotype> iterator = allCandidates.iterator();
                        while (true) {
                            DSEIndividual individual;
                            DesignDecisionGenotype designDecisionGenotype2;
                            if (!iterator.hasNext()) {
                                logger.debug((Object)"Finished reading in predefined all candidates.");
                                logger.debug((Object)"Reading in archive candidates to add them to Archive");
                                try {
                                    for (DesignDecisionGenotype designDecisionGenotype2 : archiveCandidates) {
                                        individual = dseBuilder.create((Genotype)designDecisionGenotype2);
                                        completer.complete(new Individual[]{individual});
                                        archive.update((Individual)individual);
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", 0, "Cannot archive candidates to archive " + archive.getClass().getSimpleName() + ". Maybe too many? Reason: " + e.getMessage(), (Throwable)e));
                                }
                            }
                            designDecisionGenotype2 = iterator.next();
                            individual = dseBuilder.create((Genotype)designDecisionGenotype2);
                            completer.complete(new Individual[]{individual});
                            populationTracker.addIndividualsManually(individual);
                        }
                        logger.debug((Object)"Finished reading in archive candidates");
                    }
                    task.execute();
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", 0, e.getMessage(), (Throwable)e));
                }
            }
            finally {
                DSEEvaluator evaluator = (DSEEvaluator)task.getInstance(DSEEvaluator.class);
                exceptions = evaluator.getExceptionList();
                try {
                    Optimizer opt = (Optimizer)task.getInstance(Optimizer.class);
                    int exception = opt.getIteration();
                }
                catch (Exception e) {
                    logger.error((Object)"Optimisation failed, I could not save the last results.");
                    e.printStackTrace();
                }
                String config = dseConfig.getOriginalConfiguration().getMemento();
                ResultsWriter.writeStringToFile("config", config, listener.getIteration(), exceptions, ".txt");
                if (exceptions.size() <= 0) break block17;
                logger.warn((Object)"Errors occured during evaluation.");
            }
            for (Exception exception : exceptions) {
                exception.printStackTrace();
            }
        }
    }

    public static DSEIndividualFactory getIndividualFactory() throws CoreException {
        if (task != null) {
            IndividualFactory indivBuilder = (IndividualFactory)task.getInstance(IndividualFactory.class);
            if (!(indivBuilder instanceof DSEIndividualFactory)) {
                ExceptionHelper.createNewInitialisationException("Internal Error: IndividualFactory is not a DSEIndividualFactory, Opt4JStarter has not properly been initialised.");
            }
            return (DSEIndividualFactory)indivBuilder;
        }
        throw ExceptionHelper.createNewInitialisationException("Internal Error: Cannot access IndividualFactory, Opt4JStarter has not properly been initialised.");
    }

    private static void addPopulationModule(Collection<Module> modules) {
        PopulationTrackerModule p = new PopulationTrackerModule();
        modules.add((Module)p);
    }

    private static void addOptimisationModules(int maxIterations, DSEWorkflowConfiguration config, Collection<Module> modules) throws CoreException {
        int individualsPerGeneration = config.getIndividualsPerGeneration();
        double crossoverRate = config.getCrossoverRate();
        if (config.getMaxIterations() == 0 && config.hasPredefinedInstances()) {
            GivenInstanceModule givenInstanceModule = new GivenInstanceModule();
            modules.add((Module)givenInstanceModule);
        } else if (config.isRuleBasedSearch()) {
            RuleBasedSearchModule rbModule = new RuleBasedSearchModule();
            rbModule.setGenerations(maxIterations);
            rbModule.setFullSearch(config.isFullRuleBasedSearch());
            modules.add((Module)rbModule);
        } else if (config.isRandomSearch()) {
            RandomSearchModule rsm = new RandomSearchModule(){

                public void config() {
                    super.config();
                    this.bind(IndividualFactory.class).to(DSEIndividualFactory.class);
                }
            };
            rsm.setBatchsize(config.getIndividualsPerGeneration());
            rsm.setIterations(maxIterations);
            modules.add((Module)rsm);
        } else if (config.isEvolutionarySearch()) {
            DSEEvolutionaryAlgorithmModule ea = null;
            ea = config.isBayes() ? new DSEEvolutionaryAlgorithmModule(){

                @Override
                public void config() {
                    super.config();
                    this.bind(Mating.class).to(MatingBayes.class).in(SINGLETON);
                    this.bind((TypeLiteral)new TypeLiteral<Crossover<Genotype>>(){}).to(BinaryBayesOperator.class);
                }
            } : new DSEEvolutionaryAlgorithmModule(){

                @Override
                public void config() {
                    super.config();
                    this.bind(Mating.class).to(MatingWithHeuristics.class).in(SINGLETON);
                    this.bind((TypeLiteral)new TypeLiteral<Crossover<Genotype>>(){}).to(UniformDesignDecisionGenotypeCrossover.class);
                }
            };
            ea.setGenerations(maxIterations);
            ea.setAlpha(individualsPerGeneration);
            ea.setLambda((int)Math.floor((double)individualsPerGeneration / 2.0 + 0.5));
            ea.setCrossoverRate(crossoverRate);
            DSEMutateModule mutation = new DSEMutateModule();
            mutation.setMutationIntensity(3.0);
            modules.add((Module)ea);
        } else {
            throw new CoreException((IStatus)new Status(4, Opt4JStarter.class.getName(), "Unknown selected search method, please update Opt4JStarter implementation."));
        }
    }

    public static void closeTask() {
        if (task != null) {
            task.close();
        }
    }

    @Deprecated
    public static void startOpt4JWithGUI() {
        try {
            Opt4J.main((String[])new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void terminate() {
        if (task != null && !task.getState().equals((Object)Task.State.DONE)) {
            Control control = (Control)task.getInstance(Control.class);
            control.doTerminate();
            logger.warn((Object)"Terminating run");
        } else {
            logger.warn((Object)"Cannot terminate as no task is executing");
        }
    }

    public static Archive getArchiveIndividuals() {
        return (Archive)task.getInstance(Archive.class);
    }

    public static List<DSEIndividual> getPopulationIndividuals() {
        Population p = (Population)task.getInstance(Population.class);
        ArrayList<DSEIndividual> individuals = new ArrayList<DSEIndividual>(p.size());
        for (Individual individual : p) {
            if (individual instanceof DSEIndividual) {
                individuals.add((DSEIndividual)individual);
                continue;
            }
            logger.error((Object)("There was an illegal individual that is not instance of DSEIndividual. Ignoring it. " + individual.toString()));
        }
        return individuals;
    }

    public static PopulationTracker getAllIndividuals() {
        return (PopulationTracker)task.getInstance(PopulationTracker.class);
    }

    public static void tearDown() {
        if (writers != null) {
            for (ResultsWriter writer : writers) {
                writer.close();
            }
        }
        writers = null;
        problem = null;
        creator = null;
        task = null;
    }

    public static void registerWriter(ResultsWriter writer) {
        writers.add(writer);
    }

    public static Choice createRandomGene(int index, DesignDecisionGenotype genotype) {
        if (creator != null) {
            return creator.createRandomChoice(genotype.get(index).getDegreeOfFreedomInstance());
        }
        logger.error((Object)"Could not create random value as DSECreator is not available.");
        throw new RuntimeException("Could not create random value as DSECreator is not available.");
    }

    public static DSEProblem getProblem() {
        return problem;
    }

    public static DSEEvaluator getDSEEvaluator() throws CoreException {
        Evaluator e = (Evaluator)task.getInstance(Evaluator.class);
        if (e != null && e instanceof DSEEvaluator) {
            return (DSEEvaluator)e;
        }
        throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", "Wrong initialisation of Evaluator: class DSEEvaluator expected, but found " + e == null ? "null" : e.getClass().getName()));
    }

    public static DSEDecoder getDSEDecoder() throws CoreException {
        DSEDecoder e = (DSEDecoder)task.getInstance(DSEDecoder.class);
        if (e != null) {
            return e;
        }
        throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", "Wrong initialisation of Decoder: class DSEDecoder expected, but found null"));
    }

    public static DSEWorkflowConfiguration getDSEWorkflowConfig() {
        return myDSEConfig;
    }

    public static DSECreator getDSECreator() throws CoreException {
        DSECreator e = (DSECreator)task.getInstance(DSECreator.class);
        if (e != null) {
            return e;
        }
        throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", "Wrong initialisation of Decoder: class DSEDecoder expected, but found null"));
    }

    private static void resolveObjectivesForTCM() throws CoreException {
        block15: for (IConfiguration conf : myDSEConfig.getTCConfigurations()) {
            switch (conf.getTerminationCriterionName()) {
                case MINIMAL_QUALITY_CIRTERIA_VALUE: {
                    Map unresolvedObjectiveMap = ((MinimalQualityCriteriaValueConfig)conf).getUnresolvedObjectiveMinimalValue();
                    if (unresolvedObjectiveMap == null || unresolvedObjectiveMap.isEmpty()) continue block15;
                    Collection<Objective> objectives = Opt4JStarter.getDSEEvaluator().getObjectives();
                    Set unresolvedObjectives = unresolvedObjectiveMap.keySet();
                    HashMap<Objective, Value> configuredObjectives = new HashMap<Objective, Value>();
                    block16: for (String unresolveObjective : unresolvedObjectives) {
                        for (Objective o : objectives) {
                            if (o instanceof UsageScenarioBasedObjective) {
                                if (!unresolveObjective.contains(((UsageScenarioBasedObjective)o).getUsageScenario().getId())) continue;
                                configuredObjectives.put(o, (Value)unresolvedObjectiveMap.get(unresolveObjective));
                                continue block16;
                            }
                            if (!o.getName().contains(unresolveObjective) && !unresolveObjective.contains(o.getName())) continue;
                            configuredObjectives.put(o, (Value)unresolvedObjectiveMap.get(unresolveObjective));
                            continue block16;
                        }
                    }
                    unresolvedObjectiveMap.clear();
                    try {
                        ((MinimalQualityCriteriaValueConfig)conf).setObjectiveMinimalValues(configuredObjectives);
                    }
                    catch (InvalidConfigException e) {
                        e.printStackTrace();
                    }
                    continue block15;
                }
                case INSIGNIFICANT_SET_QUALITY_IMPROVEMENT: {
                    List unresolvedValueDifferences = ((InsignificantSetQualityImprovementConfig)conf).getUnresolvedValueDifferences();
                    if (unresolvedValueDifferences == null || unresolvedValueDifferences.isEmpty()) continue block15;
                    Collection<Objective> objectives = Opt4JStarter.getDSEEvaluator().getObjectives();
                    LinkedList<InsignificantSetQualityImprovementConfig.ValueDifference> valueDifferences = new LinkedList<InsignificantSetQualityImprovementConfig.ValueDifference>();
                    block18: for (InsignificantSetQualityImprovementConfig.UnresolvedValueDifference uvd : unresolvedValueDifferences) {
                        for (Objective o : objectives) {
                            if (o instanceof UsageScenarioBasedObjective) {
                                if (!uvd.objective.contains(((UsageScenarioBasedObjective)o).getUsageScenario().getId())) continue;
                                try {
                                    InsignificantSetQualityImprovementConfig insignificantSetQualityImprovementConfig = (InsignificantSetQualityImprovementConfig)conf;
                                    insignificantSetQualityImprovementConfig.getClass();
                                    valueDifferences.add(new InsignificantSetQualityImprovementConfig.ValueDifference(insignificantSetQualityImprovementConfig, o, uvd.averageImprovement, uvd.maxMinImprovement));
                                }
                                catch (InvalidConfigException e) {
                                    e.printStackTrace();
                                }
                                continue block18;
                            }
                            if (!o.getName().contains(uvd.objective) && !uvd.objective.contains(o.getName())) continue;
                            try {
                                InsignificantSetQualityImprovementConfig insignificantSetQualityImprovementConfig = (InsignificantSetQualityImprovementConfig)conf;
                                insignificantSetQualityImprovementConfig.getClass();
                                valueDifferences.add(new InsignificantSetQualityImprovementConfig.ValueDifference(insignificantSetQualityImprovementConfig, o, uvd.averageImprovement, uvd.maxMinImprovement));
                            }
                            catch (InvalidConfigException e) {
                                e.printStackTrace();
                            }
                            continue block18;
                        }
                    }
                    unresolvedValueDifferences.clear();
                    try {
                        ((InsignificantSetQualityImprovementConfig)conf).setValueDifferences(valueDifferences);
                    }
                    catch (InvalidConfigException e) {
                        e.printStackTrace();
                    }
                    continue block15;
                }
                case GIVEN_PARETO_FRONT_IS_REACHED: {
                    String filePath = ((GivenParetoFrontIsReachedConfig)conf).getParetoFrontFile();
                    if (filePath != null && !filePath.isEmpty()) {
                        try {
                            ((GivenParetoFrontIsReachedConfig)conf).setParetoFront(GenotypeReader.getObjectives(filePath));
                        }
                        catch (InvalidConfigException e) {
                            e.printStackTrace();
                        }
                    }
                    ((GivenParetoFrontIsReachedConfig)conf).setParetoFrontFile("");
                }
            }
        }
    }
}

