/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.featuremodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AttributeTypes implements Enumerator
{
    INT(0, "INT", "INT"),
    STRING(1, "STRING", "STRING"),
    REAL(2, "REAL", "REAL");

    public static final int INT_VALUE = 0;
    public static final int STRING_VALUE = 1;
    public static final int REAL_VALUE = 2;
    private static final AttributeTypes[] VALUES_ARRAY;
    public static final List<AttributeTypes> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttributeTypes[]{INT, STRING, REAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttributeTypes get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeTypes result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeTypes getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeTypes result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeTypes get(int value) {
        switch (value) {
            case 0: {
                return INT;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return REAL;
            }
        }
        return null;
    }

    private AttributeTypes(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

