package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

@SuppressWarnings("all")
public class BuildXpt {
  @Inject
  private M2TFileSystemAccess fsa;
  
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;
  
  @Inject
  @Extension
  private PCMext _pCMext;
  
  public void buildScripts(final UsageModel um) {
    this.buildProperties(um);
    this.fileList(um);
    this.clientXML(um);
    this.applicationXML(um);
  }
  
  private void buildProperties(final UsageModel um) {
    final String fileName = "build.properties";
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# Name of the application to build");
    _builder.newLine();
    _builder.append("projectname=pcm-generated-default-name");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Source Directory");
    _builder.newLine();
    _builder.append("src=src");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Class Directory");
    _builder.newLine();
    _builder.append("build=bin");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Directory in which the jar contents are collected");
    _builder.newLine();
    _builder.append("dist-dir=dist");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Path to a folder containing all additionally needed libs");
    _builder.newLine();
    _builder.append("lib-dir=libs");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Path to the SUN Appserver Bin Directory");
    _builder.newLine();
    _builder.append("sun-appserver-dir=C:/sun/sdk/bin");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Name of the Directory in which to place the final jars/ears");
    _builder.newLine();
    _builder.append("output=output");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }
  
  private void fileList(final UsageModel um) {
    final String fileName = "generated-filesets.xml";
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<project name=\"generated-filesets\">");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<fileset id=\"client-classes\" dir=\"${dist-dir}\">");
    _builder.newLine();
    {
      EList<UsageScenario> _usageScenario_UsageModel = um.getUsageScenario_UsageModel();
      for(final UsageScenario us : _usageScenario_UsageModel) {
        _builder.append("\t\t");
        _builder.append("<include name=\"");
        String _basePackageName = this._javaNamesExt.basePackageName(us);
        String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_basePackageName);
        _builder.append(_fqnToDirectoryPath, "\t\t");
        _builder.append("/**/*.class\" />");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("<include name=\"*.class\" />");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<include name=\"META-INF/application-client.xml\" />");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("</fileset>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<fileset id=\"ejb-classes\" dir=\"${dist-dir}\">");
    _builder.newLine();
    _builder.append("\t\t");
    EList<UsageScenario> _usageScenario_UsageModel_1 = um.getUsageScenario_UsageModel();
    final Function1<UsageScenario, EList<AbstractUserAction>> _function = new Function1<UsageScenario, EList<AbstractUserAction>>() {
      public EList<AbstractUserAction> apply(final UsageScenario it) {
        ScenarioBehaviour _scenarioBehaviour_UsageScenario = it.getScenarioBehaviour_UsageScenario();
        return _scenarioBehaviour_UsageScenario.getActions_ScenarioBehaviour();
      }
    };
    List<EList<AbstractUserAction>> _map = ListExtensions.<UsageScenario, EList<AbstractUserAction>>map(_usageScenario_UsageModel_1, _function);
    Iterable<AbstractUserAction> _flatten = Iterables.<AbstractUserAction>concat(_map);
    Iterable<EntryLevelSystemCall> _filter = Iterables.<EntryLevelSystemCall>filter(_flatten, EntryLevelSystemCall.class);
    final Function1<EntryLevelSystemCall, InterfaceProvidingEntity> _function_1 = new Function1<EntryLevelSystemCall, InterfaceProvidingEntity>() {
      public InterfaceProvidingEntity apply(final EntryLevelSystemCall it) {
        OperationProvidedRole _providedRole_EntryLevelSystemCall = it.getProvidedRole_EntryLevelSystemCall();
        return _providedRole_EntryLevelSystemCall.getProvidingEntity_ProvidedRole();
      }
    };
    Iterable<InterfaceProvidingEntity> _map_1 = IterableExtensions.<EntryLevelSystemCall, InterfaceProvidingEntity>map(_filter, _function_1);
    Iterable<org.palladiosimulator.pcm.system.System> _filter_1 = Iterables.<org.palladiosimulator.pcm.system.System>filter(_map_1, org.palladiosimulator.pcm.system.System.class);
    final Set<org.palladiosimulator.pcm.system.System> systems = IterableExtensions.<org.palladiosimulator.pcm.system.System>toSet(_filter_1);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    {
      for(final org.palladiosimulator.pcm.system.System system : systems) {
        String _includeClasses = this.includeClasses(system);
        _builder.append(_includeClasses, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("<include name=\"META-INF/ejb-jar.xml\" />");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("</fileset>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("</project>\t");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }
  
  private void applicationXML(final UsageModel um) {
    final String fileName = "META-INF/application.xml";
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    _builder.newLine();
    _builder.append("<application version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd\">");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<display-name>@@projectname@@</display-name>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<module>");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<java>@@projectname@@-client.jar</java>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("</module>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<module>");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<ejb>@@projectname@@-ejb.jar</ejb>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("</module>");
    _builder.newLine();
    _builder.append("</application>");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }
  
  private void clientXML(final UsageModel um) {
    final String fileName = "META-INF/application-client.xml";
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    _builder.newLine();
    _builder.append("<application-client version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd\">");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<display-name>@@projectname@@-Client</display-name>");
    _builder.newLine();
    _builder.append("    ");
    EList<UsageScenario> _usageScenario_UsageModel = um.getUsageScenario_UsageModel();
    final Function1<UsageScenario, EList<AbstractUserAction>> _function = new Function1<UsageScenario, EList<AbstractUserAction>>() {
      public EList<AbstractUserAction> apply(final UsageScenario it) {
        ScenarioBehaviour _scenarioBehaviour_UsageScenario = it.getScenarioBehaviour_UsageScenario();
        return _scenarioBehaviour_UsageScenario.getActions_ScenarioBehaviour();
      }
    };
    List<EList<AbstractUserAction>> _map = ListExtensions.<UsageScenario, EList<AbstractUserAction>>map(_usageScenario_UsageModel, _function);
    Iterable<AbstractUserAction> _flatten = Iterables.<AbstractUserAction>concat(_map);
    Iterable<EntryLevelSystemCall> _filter = Iterables.<EntryLevelSystemCall>filter(_flatten, EntryLevelSystemCall.class);
    final Function1<EntryLevelSystemCall, OperationProvidedRole> _function_1 = new Function1<EntryLevelSystemCall, OperationProvidedRole>() {
      public OperationProvidedRole apply(final EntryLevelSystemCall it) {
        return it.getProvidedRole_EntryLevelSystemCall();
      }
    };
    Iterable<OperationProvidedRole> _map_1 = IterableExtensions.<EntryLevelSystemCall, OperationProvidedRole>map(_filter, _function_1);
    final Set<OperationProvidedRole> systemCalls = IterableExtensions.<OperationProvidedRole>toSet(_map_1);
    _builder.newLineIfNotEmpty();
    _builder.append("   ");
    {
      for(final OperationProvidedRole systemCall : systemCalls) {
        CharSequence _ejbClientRef = this.ejbClientRef(systemCall);
        _builder.append(_ejbClientRef, "   ");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append(".providedRole_EntryLevelSystemCall.toSet()»");
    _builder.newLine();
    _builder.append("</application-client>");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }
  
  protected String _includeClasses(final Repository repository) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<include name=\"");
    String _javaName = this._javaNamesExt.javaName(repository);
    String _lowerCase = _javaName.toLowerCase();
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_lowerCase);
    _builder.append(_fqnToDirectoryPath, "");
    _builder.append("\"/**/*.class\" />");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  protected String _includeClasses(final org.palladiosimulator.pcm.system.System system) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<include name=\"");
    String _javaName = this._javaNamesExt.javaName(system);
    String _lowerCase = _javaName.toLowerCase();
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_lowerCase);
    _builder.append(_fqnToDirectoryPath, "");
    _builder.append("\"/**/*.class\" />");
    _builder.newLineIfNotEmpty();
    {
      Set<Entity> _collectRepositories = this._pCMext.collectRepositories(system);
      for(final Entity repository : _collectRepositories) {
        String _includeClasses = this.includeClasses(repository);
        _builder.append(_includeClasses, "");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  protected CharSequence _ejbClientRef(final OperationProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<ejb-ref>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<ejb-ref-name>ejb/");
    OperationInterface _providedInterface__OperationProvidedRole = role.getProvidedInterface__OperationProvidedRole();
    String _javaName = this._javaNamesExt.javaName(_providedInterface__OperationProvidedRole);
    _builder.append(_javaName, "\t");
    _builder.append("</ejb-ref-name>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<ejb-ref-type>Session</ejb-ref-type> ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<remote>");
    OperationInterface _providedInterface__OperationProvidedRole_1 = role.getProvidedInterface__OperationProvidedRole();
    String _fqn = this._javaNamesExt.fqn(_providedInterface__OperationProvidedRole_1);
    _builder.append(_fqn, "\t");
    _builder.append("</remote>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    InterfaceProvidingEntity _providingEntity_ProvidedRole = role.getProvidingEntity_ProvidedRole();
    EList<Connector> _connectors__ComposedStructure = ((org.palladiosimulator.pcm.system.System) _providingEntity_ProvidedRole).getConnectors__ComposedStructure();
    Iterable<ProvidedDelegationConnector> _filter = Iterables.<ProvidedDelegationConnector>filter(_connectors__ComposedStructure, 
      ProvidedDelegationConnector.class);
    final Function1<ProvidedDelegationConnector, Boolean> _function = new Function1<ProvidedDelegationConnector, Boolean>() {
      public Boolean apply(final ProvidedDelegationConnector it) {
        OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = it.getOuterProvidedRole_ProvidedDelegationConnector();
        return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, role));
      }
    };
    Iterable<ProvidedDelegationConnector> _filter_1 = IterableExtensions.<ProvidedDelegationConnector>filter(_filter, _function);
    final ProvidedDelegationConnector delegationConnector = IterableExtensions.<ProvidedDelegationConnector>head(_filter_1);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    final AssemblyContext componentContext = delegationConnector.getAssemblyContext_ProvidedDelegationConnector();
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<ejb-link>");
    RepositoryComponent _encapsulatedComponent__AssemblyContext = componentContext.getEncapsulatedComponent__AssemblyContext();
    String _javaName_1 = this._javaNamesExt.javaName(_encapsulatedComponent__AssemblyContext);
    _builder.append(_javaName_1, "\t");
    _builder.append("_");
    OperationInterface _providedInterface__OperationProvidedRole_2 = role.getProvidedInterface__OperationProvidedRole();
    String _javaName_2 = this._javaNamesExt.javaName(_providedInterface__OperationProvidedRole_2);
    _builder.append(_javaName_2, "\t");
    _builder.append("_");
    String _id = componentContext.getId();
    _builder.append(_id, "\t");
    _builder.append("</ejb-link> ");
    _builder.newLineIfNotEmpty();
    _builder.append("</ejb-ref>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _ejbClientRef(final InfrastructureProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<ejb-ref>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<ejb-ref-name>ejb/");
    InfrastructureInterface _providedInterface__InfrastructureProvidedRole = role.getProvidedInterface__InfrastructureProvidedRole();
    String _javaName = this._javaNamesExt.javaName(_providedInterface__InfrastructureProvidedRole);
    _builder.append(_javaName, "\t");
    _builder.append("</ejb-ref-name>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t   ");
    _builder.append("<ejb-ref-type>Session</ejb-ref-type> ");
    _builder.newLine();
    _builder.append("\t   ");
    _builder.append("<remote>");
    InfrastructureInterface _providedInterface__InfrastructureProvidedRole_1 = role.getProvidedInterface__InfrastructureProvidedRole();
    String _fqn = this._javaNamesExt.fqn(_providedInterface__InfrastructureProvidedRole_1);
    _builder.append(_fqn, "\t   ");
    _builder.append("</remote>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t   ");
    InterfaceProvidingEntity _providingEntity_ProvidedRole = role.getProvidingEntity_ProvidedRole();
    EList<Connector> _connectors__ComposedStructure = ((org.palladiosimulator.pcm.system.System) _providingEntity_ProvidedRole).getConnectors__ComposedStructure();
    Iterable<ProvidedDelegationConnector> _filter = Iterables.<ProvidedDelegationConnector>filter(_connectors__ComposedStructure, ProvidedDelegationConnector.class);
    final Function1<ProvidedDelegationConnector, Boolean> _function = new Function1<ProvidedDelegationConnector, Boolean>() {
      public Boolean apply(final ProvidedDelegationConnector it) {
        OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = it.getOuterProvidedRole_ProvidedDelegationConnector();
        return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, role));
      }
    };
    Iterable<ProvidedDelegationConnector> _filter_1 = IterableExtensions.<ProvidedDelegationConnector>filter(_filter, _function);
    final ProvidedDelegationConnector delegationConnector = IterableExtensions.<ProvidedDelegationConnector>head(_filter_1);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    final AssemblyContext componentContext = delegationConnector.getAssemblyContext_ProvidedDelegationConnector();
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<ejb-link>");
    RepositoryComponent _encapsulatedComponent__AssemblyContext = componentContext.getEncapsulatedComponent__AssemblyContext();
    String _javaName_1 = this._javaNamesExt.javaName(_encapsulatedComponent__AssemblyContext);
    _builder.append(_javaName_1, "\t");
    _builder.append("_");
    InfrastructureInterface _providedInterface__InfrastructureProvidedRole_2 = role.getProvidedInterface__InfrastructureProvidedRole();
    String _javaName_2 = this._javaNamesExt.javaName(_providedInterface__InfrastructureProvidedRole_2);
    _builder.append(_javaName_2, "\t");
    _builder.append("_");
    String _id = componentContext.getId();
    _builder.append(_id, "\t");
    _builder.append("</ejb-link> ");
    _builder.newLineIfNotEmpty();
    _builder.append("</ejb-ref>");
    _builder.newLine();
    return _builder;
  }
  
  public String includeClasses(final CDOObject system) {
    if (system instanceof org.palladiosimulator.pcm.system.System) {
      return _includeClasses((org.palladiosimulator.pcm.system.System)system);
    } else if (system instanceof Repository) {
      return _includeClasses((Repository)system);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(system).toString());
    }
  }
  
  public CharSequence ejbClientRef(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _ejbClientRef((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _ejbClientRef((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }
}
