package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaCoreXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;

@SuppressWarnings("all")
public abstract class CallsXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;
  
  @Inject
  @Extension
  private JavaCoreXpt _javaCoreXpt;
  
  public CharSequence call(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages, final List<VariableUsage> outParameterUsages) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _preCallTM = this.preCallTM(signature, call, prefix, parameterUsages);
    _builder.append(_preCallTM, "");
    _builder.newLineIfNotEmpty();
    _builder.append(prefix, "");
    String _javaSignature = this._javaNamesExt.javaSignature(signature);
    _builder.append(_javaSignature, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("(");
    CharSequence _parameterUsageListTM = this._javaCoreXpt.parameterUsageListTM(signature);
    _builder.append(_parameterUsageListTM, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _postCallTM = this.postCallTM(signature, call, prefix, outParameterUsages);
    _builder.append(_postCallTM, "");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence call(final InfrastructureCall infraCall, final Entity call) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("{ //CALL SCOPE: this scope is needed if the same service is called multiple times in one SEFF. Otherwise there is a duplicate local variable definition.");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("long numberOfCalls = ctx.evaluate(\"");
    PCMRandomVariable _numberOfCalls__InfrastructureCall = infraCall.getNumberOfCalls__InfrastructureCall();
    String _specification = _numberOfCalls__InfrastructureCall.getSpecification();
    String _specificationString = this._javaNamesExt.specificationString(_specification);
    _builder.append(_specificationString, "   ");
    _builder.append("\",Double.class).longValue();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (long callNumber = 0; callNumber < numberOfCalls; callNumber++) {");
    _builder.newLine();
    _builder.append("\t");
    InfrastructureRequiredRole _requiredRole__InfrastructureCall = infraCall.getRequiredRole__InfrastructureCall();
    String _javaName = this._javaNamesExt.javaName(_requiredRole__InfrastructureCall);
    String _plus = ("myContext.getRole" + _javaName);
    final String prefix = (_plus + "().");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    InfrastructureSignature _signature__InfrastructureCall = infraCall.getSignature__InfrastructureCall();
    EList<VariableUsage> _inputVariableUsages__CallAction = infraCall.getInputVariableUsages__CallAction();
    CharSequence _preCallTM = this.preCallTM(_signature__InfrastructureCall, call, prefix, _inputVariableUsages__CallAction);
    _builder.append(_preCallTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t  \t");
    _builder.append(prefix, "\t  \t");
    InfrastructureSignature _signature__InfrastructureCall_1 = infraCall.getSignature__InfrastructureCall();
    String _javaSignature = this._javaNamesExt.javaSignature(_signature__InfrastructureCall_1);
    _builder.append(_javaSignature, "\t  \t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t  \t\t");
    _builder.append("(");
    InfrastructureSignature _signature__InfrastructureCall_2 = infraCall.getSignature__InfrastructureCall();
    CharSequence _parameterUsageListTM = this._javaCoreXpt.parameterUsageListTM(_signature__InfrastructureCall_2);
    _builder.append(_parameterUsageListTM, "\t  \t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    InfrastructureSignature _signature__InfrastructureCall_3 = infraCall.getSignature__InfrastructureCall();
    CharSequence _postCallTM = this.postCallTM(_signature__InfrastructureCall_3, call, prefix);
    _builder.append(_postCallTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("} // END CALL SCOPE");
    _builder.newLine();
    return _builder;
  }
  
  public abstract CharSequence preCallTM(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages);
  
  public abstract CharSequence preCallTM(final InfrastructureSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages);
  
  public abstract CharSequence postCallTM(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> outParameterUsages);
  
  public abstract CharSequence postCallTM(final InfrastructureSignature signature, final Entity call, final String prefix);
}
