package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaCoreXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;

@SuppressWarnings("all")
public abstract class DummiesXpt {
  @Inject
  private M2TFileSystemAccess fsa;
  
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;
  
  @Inject
  @Extension
  private JavaCoreXpt _javaCoreXpt;
  
  protected void _dummyComponent(final OperationRequiredRole orr, final org.palladiosimulator.pcm.system.System s) {
    String _implementationPackage = this._javaNamesExt.implementationPackage(s);
    String _plus = (_implementationPackage + ".");
    String _fqnDummyComponent = this._javaNamesExt.fqnDummyComponent(orr);
    String _plus_1 = (_plus + _fqnDummyComponent);
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_plus_1);
    final String fileName = (_fqnToDirectoryPath + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _implementationPackage_1 = this._javaNamesExt.implementationPackage(s);
    _builder.append(_implementationPackage_1, "");
    _builder.append(".");
    String _fqnDummyComponentPackage = this._javaNamesExt.fqnDummyComponentPackage(orr);
    _builder.append(_fqnDummyComponentPackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("public class ");
    String _dummyComponentName = this._javaNamesExt.dummyComponentName(orr);
    _builder.append(_dummyComponentName, "");
    _builder.newLineIfNotEmpty();
    _builder.append("implements ");
    OperationInterface _requiredInterface__OperationRequiredRole = orr.getRequiredInterface__OperationRequiredRole();
    String _fqn = this._javaNamesExt.fqn(_requiredInterface__OperationRequiredRole);
    _builder.append(_fqn, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static org.apache.log4j.Logger logger = ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.apache.log4j.Logger.getLogger(");
    String _dummyComponentName_1 = this._javaNamesExt.dummyComponentName(orr);
    _builder.append(_dummyComponentName_1, "\t\t");
    _builder.append(".class.getName());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    OperationInterface _requiredInterface__OperationRequiredRole_1 = orr.getRequiredInterface__OperationRequiredRole();
    CharSequence _dummyComponentPortHelperMethodTM = this.dummyComponentPortHelperMethodTM(_requiredInterface__OperationRequiredRole_1);
    _builder.append(_dummyComponentPortHelperMethodTM, "\t");
    _builder.newLineIfNotEmpty();
    {
      OperationInterface _requiredInterface__OperationRequiredRole_2 = orr.getRequiredInterface__OperationRequiredRole();
      EList<OperationSignature> _signatures__OperationInterface = _requiredInterface__OperationRequiredRole_2.getSignatures__OperationInterface();
      for(final OperationSignature signature : _signatures__OperationInterface) {
        _builder.append("\t");
        CharSequence _dummyMethod = this.dummyMethod(signature, s, orr);
        _builder.append(_dummyMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }
  
  protected void _dummyComponent(final InfrastructureRequiredRole irr, final org.palladiosimulator.pcm.system.System s) {
    String _implementationPackage = this._javaNamesExt.implementationPackage(s);
    String _plus = (_implementationPackage + ".");
    String _fqnDummyComponent = this._javaNamesExt.fqnDummyComponent(irr);
    String _plus_1 = (_plus + _fqnDummyComponent);
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_plus_1);
    final String fileName = (_fqnToDirectoryPath + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _implementationPackage_1 = this._javaNamesExt.implementationPackage(s);
    _builder.append(_implementationPackage_1, "");
    _builder.append(".");
    String _fqnDummyComponentPackage = this._javaNamesExt.fqnDummyComponentPackage(irr);
    _builder.append(_fqnDummyComponentPackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    String _dummyComponentName = this._javaNamesExt.dummyComponentName(irr);
    _builder.append(_dummyComponentName, "");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("implements ");
    InfrastructureInterface _requiredInterface__InfrastructureRequiredRole = irr.getRequiredInterface__InfrastructureRequiredRole();
    String _fqn = this._javaNamesExt.fqn(_requiredInterface__InfrastructureRequiredRole);
    _builder.append(_fqn, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static org.apache.log4j.Logger logger = ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.apache.log4j.Logger.getLogger(");
    String _dummyComponentName_1 = this._javaNamesExt.dummyComponentName(irr);
    _builder.append(_dummyComponentName_1, "\t\t");
    _builder.append(".class.getName());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    InfrastructureInterface _requiredInterface__InfrastructureRequiredRole_1 = irr.getRequiredInterface__InfrastructureRequiredRole();
    CharSequence _dummyComponentPortHelperMethodTM = this.dummyComponentPortHelperMethodTM(_requiredInterface__InfrastructureRequiredRole_1);
    _builder.append(_dummyComponentPortHelperMethodTM, "\t");
    _builder.newLineIfNotEmpty();
    {
      InfrastructureInterface _requiredInterface__InfrastructureRequiredRole_2 = irr.getRequiredInterface__InfrastructureRequiredRole();
      EList<InfrastructureSignature> _infrastructureSignatures__InfrastructureInterface = _requiredInterface__InfrastructureRequiredRole_2.getInfrastructureSignatures__InfrastructureInterface();
      for(final InfrastructureSignature signature : _infrastructureSignatures__InfrastructureInterface) {
        _builder.append("\t");
        CharSequence _dummyMethod = this.dummyMethod(signature, s, irr);
        _builder.append(_dummyMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }
  
  protected CharSequence _dummyMethod(final OperationSignature os, final org.palladiosimulator.pcm.system.System s, final OperationRequiredRole r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _operationSignature = this._javaCoreXpt.operationSignature(os);
    _builder.append(_operationSignature, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _dummyMethodBodyTM = this.dummyMethodBodyTM(os, s, r);
    _builder.append(_dummyMethodBodyTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _dummyMethod(final InfrastructureSignature is, final org.palladiosimulator.pcm.system.System s, final InfrastructureRequiredRole r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _infrastructureSignature = this._javaCoreXpt.infrastructureSignature(is);
    _builder.append(_infrastructureSignature, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _dummyMethodBodyTM = this.dummyMethodBodyTM(is, s, r);
    _builder.append(_dummyMethodBodyTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public abstract CharSequence dummyMethodBodyTM(final OperationSignature os, final org.palladiosimulator.pcm.system.System s, final OperationRequiredRole r);
  
  public abstract CharSequence dummyMethodBodyTM(final InfrastructureSignature os, final org.palladiosimulator.pcm.system.System s, final InfrastructureRequiredRole r);
  
  public abstract CharSequence dummyComponentPortHelperMethodTM(final OperationInterface oi);
  
  public abstract CharSequence dummyComponentPortHelperMethodTM(final InfrastructureInterface oi);
  
  public void dummyComponent(final RequiredRole irr, final org.palladiosimulator.pcm.system.System s) {
    if (irr instanceof InfrastructureRequiredRole) {
      _dummyComponent((InfrastructureRequiredRole)irr, s);
      return;
    } else if (irr instanceof OperationRequiredRole) {
      _dummyComponent((OperationRequiredRole)irr, s);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(irr, s).toString());
    }
  }
  
  public CharSequence dummyMethod(final Signature is, final org.palladiosimulator.pcm.system.System s, final RequiredRole r) {
    if (is instanceof InfrastructureSignature
         && r instanceof InfrastructureRequiredRole) {
      return _dummyMethod((InfrastructureSignature)is, s, (InfrastructureRequiredRole)r);
    } else if (is instanceof OperationSignature
         && r instanceof OperationRequiredRole) {
      return _dummyMethod((OperationSignature)is, s, (OperationRequiredRole)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(is, s, r).toString());
    }
  }
}
