package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.uka.ipd.sdq.pcm.transformations.Helper;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyEventConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.DelegationConnector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingRequiringEntity;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.SynchronisationPoint;
import org.palladiosimulator.pcm.subsystem.SubSystem;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

@SuppressWarnings("all")
public class PCMext {
  public StartAction findStart(final List<AbstractAction> actions) {
    Iterable<StartAction> _filter = Iterables.<StartAction>filter(actions, StartAction.class);
    return IterableExtensions.<StartAction>head(_filter);
  }
  
  public Iterable<Connector> connectors(final ComposedStructure s) {
    EList<Connector> _connectors__ComposedStructure = s.getConnectors__ComposedStructure();
    final Function1<Connector, Boolean> _function = new Function1<Connector, Boolean>() {
      public Boolean apply(final Connector connector) {
        return Boolean.valueOf((!(connector instanceof DelegationConnector)));
      }
    };
    return IterableExtensions.<Connector>filter(_connectors__ComposedStructure, _function);
  }
  
  protected boolean _test(final Connector conn, final AssemblyContext ctx, final RequiredRole r) {
    return false;
  }
  
  protected boolean _test(final AssemblyConnector c, final AssemblyContext ctx, final RequiredRole r) {
    boolean _and = false;
    OperationRequiredRole _requiredRole_AssemblyConnector = c.getRequiredRole_AssemblyConnector();
    String _id = _requiredRole_AssemblyConnector.getId();
    String _id_1 = r.getId();
    boolean _equals = _id.equals(_id_1);
    if (!_equals) {
      _and = false;
    } else {
      AssemblyContext _requiringAssemblyContext_AssemblyConnector = c.getRequiringAssemblyContext_AssemblyConnector();
      String _id_2 = _requiringAssemblyContext_AssemblyConnector.getId();
      String _id_3 = ctx.getId();
      boolean _equals_1 = _id_2.equals(_id_3);
      _and = _equals_1;
    }
    return _and;
  }
  
  protected boolean _test(final AssemblyInfrastructureConnector c, final AssemblyContext ctx, final InfrastructureRequiredRole r) {
    boolean _and = false;
    InfrastructureRequiredRole _requiredRole__AssemblyInfrastructureConnector = c.getRequiredRole__AssemblyInfrastructureConnector();
    String _id = _requiredRole__AssemblyInfrastructureConnector.getId();
    String _id_1 = r.getId();
    boolean _equals = _id.equals(_id_1);
    if (!_equals) {
      _and = false;
    } else {
      AssemblyContext _requiringAssemblyContext__AssemblyInfrastructureConnector = c.getRequiringAssemblyContext__AssemblyInfrastructureConnector();
      String _id_2 = _requiringAssemblyContext__AssemblyInfrastructureConnector.getId();
      String _id_3 = ctx.getId();
      boolean _equals_1 = _id_2.equals(_id_3);
      _and = _equals_1;
    }
    return _and;
  }
  
  protected boolean _test(final AssemblyEventConnector c, final AssemblyContext ctx, final SinkRole r) {
    boolean _and = false;
    SinkRole _sinkRole__AssemblyEventConnector = c.getSinkRole__AssemblyEventConnector();
    String _id = _sinkRole__AssemblyEventConnector.getId();
    String _id_1 = r.getId();
    boolean _equals = _id.equals(_id_1);
    if (!_equals) {
      _and = false;
    } else {
      AssemblyContext _sourceAssemblyContext__AssemblyEventConnector = c.getSourceAssemblyContext__AssemblyEventConnector();
      String _id_2 = _sourceAssemblyContext__AssemblyEventConnector.getId();
      String _id_3 = ctx.getId();
      boolean _equals_1 = _id_2.equals(_id_3);
      _and = _equals_1;
    }
    return _and;
  }
  
  public boolean hasConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    Iterable<Connector> _connectors = this.connectors(s);
    final Function1<Connector, Boolean> _function = new Function1<Connector, Boolean>() {
      public Boolean apply(final Connector con) {
        return Boolean.valueOf(PCMext.this.test(con, ctx, r));
      }
    };
    Iterable<Connector> _filter = IterableExtensions.<Connector>filter(_connectors, _function);
    int _size = IterableExtensions.size(_filter);
    return (_size == 1);
  }
  
  public Connector getConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    Iterable<Connector> _connectors = this.connectors(s);
    final Function1<Connector, Boolean> _function = new Function1<Connector, Boolean>() {
      public Boolean apply(final Connector con) {
        return Boolean.valueOf(PCMext.this.test(con, ctx, r));
      }
    };
    Iterable<Connector> _filter = IterableExtensions.<Connector>filter(_connectors, _function);
    return IterableExtensions.<Connector>head(_filter);
  }
  
  public boolean hasProvidedDelegationConnector(final ComposedStructure s, final ProvidedRole p) {
    EList<Connector> _connectors__ComposedStructure = s.getConnectors__ComposedStructure();
    Iterable<ProvidedDelegationConnector> _filter = Iterables.<ProvidedDelegationConnector>filter(_connectors__ComposedStructure, ProvidedDelegationConnector.class);
    final Function1<ProvidedDelegationConnector, Boolean> _function = new Function1<ProvidedDelegationConnector, Boolean>() {
      public Boolean apply(final ProvidedDelegationConnector dc) {
        OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = dc.getOuterProvidedRole_ProvidedDelegationConnector();
        return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, p));
      }
    };
    Iterable<ProvidedDelegationConnector> _filter_1 = IterableExtensions.<ProvidedDelegationConnector>filter(_filter, _function);
    int _size = IterableExtensions.size(_filter_1);
    return (_size == 1);
  }
  
  public ProvidedDelegationConnector getProvidedDelegationConnector(final ComposedStructure s, final ProvidedRole p) {
    EList<Connector> _connectors__ComposedStructure = s.getConnectors__ComposedStructure();
    Iterable<ProvidedDelegationConnector> _filter = Iterables.<ProvidedDelegationConnector>filter(_connectors__ComposedStructure, ProvidedDelegationConnector.class);
    final Function1<ProvidedDelegationConnector, Boolean> _function = new Function1<ProvidedDelegationConnector, Boolean>() {
      public Boolean apply(final ProvidedDelegationConnector dc) {
        OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = dc.getOuterProvidedRole_ProvidedDelegationConnector();
        return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, p));
      }
    };
    Iterable<ProvidedDelegationConnector> _filter_1 = IterableExtensions.<ProvidedDelegationConnector>filter(_filter, _function);
    return IterableExtensions.<ProvidedDelegationConnector>head(_filter_1);
  }
  
  public boolean hasRequiredDelegationConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    EList<Connector> _connectors__ComposedStructure = s.getConnectors__ComposedStructure();
    Iterable<RequiredDelegationConnector> _filter = Iterables.<RequiredDelegationConnector>filter(_connectors__ComposedStructure, RequiredDelegationConnector.class);
    final Function1<RequiredDelegationConnector, Boolean> _function = new Function1<RequiredDelegationConnector, Boolean>() {
      public Boolean apply(final RequiredDelegationConnector dc) {
        OperationRequiredRole _innerRequiredRole_RequiredDelegationConnector = dc.getInnerRequiredRole_RequiredDelegationConnector();
        return Boolean.valueOf(Objects.equal(_innerRequiredRole_RequiredDelegationConnector, r));
      }
    };
    Iterable<RequiredDelegationConnector> _filter_1 = IterableExtensions.<RequiredDelegationConnector>filter(_filter, _function);
    int _size = IterableExtensions.size(_filter_1);
    return (_size == 1);
  }
  
  public RequiredDelegationConnector getRequiredDelegationConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    EList<Connector> _connectors__ComposedStructure = s.getConnectors__ComposedStructure();
    Iterable<RequiredDelegationConnector> _filter = Iterables.<RequiredDelegationConnector>filter(_connectors__ComposedStructure, RequiredDelegationConnector.class);
    final Function1<RequiredDelegationConnector, Boolean> _function = new Function1<RequiredDelegationConnector, Boolean>() {
      public Boolean apply(final RequiredDelegationConnector dc) {
        OperationRequiredRole _innerRequiredRole_RequiredDelegationConnector = dc.getInnerRequiredRole_RequiredDelegationConnector();
        return Boolean.valueOf(Objects.equal(_innerRequiredRole_RequiredDelegationConnector, r));
      }
    };
    Iterable<RequiredDelegationConnector> _filter_1 = IterableExtensions.<RequiredDelegationConnector>filter(_filter, _function);
    return IterableExtensions.<RequiredDelegationConnector>head(_filter_1);
  }
  
  public boolean hasProvidedInfrastructureDelegationConnector(final ComposedStructure s, final InfrastructureProvidedRole p) {
    EList<Connector> _connectors__ComposedStructure = s.getConnectors__ComposedStructure();
    Iterable<ProvidedDelegationConnector> _filter = Iterables.<ProvidedDelegationConnector>filter(_connectors__ComposedStructure, ProvidedDelegationConnector.class);
    final Function1<ProvidedDelegationConnector, Boolean> _function = new Function1<ProvidedDelegationConnector, Boolean>() {
      public Boolean apply(final ProvidedDelegationConnector dc) {
        OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = dc.getOuterProvidedRole_ProvidedDelegationConnector();
        return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, p));
      }
    };
    Iterable<ProvidedDelegationConnector> _filter_1 = IterableExtensions.<ProvidedDelegationConnector>filter(_filter, _function);
    int _size = IterableExtensions.size(_filter_1);
    return (_size == 1);
  }
  
  public ProvidedDelegationConnector getProvidedInfrastructureDelegationConnector(final ComposedStructure s, final InfrastructureProvidedRole p) {
    EList<Connector> _connectors__ComposedStructure = s.getConnectors__ComposedStructure();
    Iterable<ProvidedDelegationConnector> _filter = Iterables.<ProvidedDelegationConnector>filter(_connectors__ComposedStructure, ProvidedDelegationConnector.class);
    final Function1<ProvidedDelegationConnector, Boolean> _function = new Function1<ProvidedDelegationConnector, Boolean>() {
      public Boolean apply(final ProvidedDelegationConnector dc) {
        OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = dc.getOuterProvidedRole_ProvidedDelegationConnector();
        return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, p));
      }
    };
    Iterable<ProvidedDelegationConnector> _filter_1 = IterableExtensions.<ProvidedDelegationConnector>filter(_filter, _function);
    return IterableExtensions.<ProvidedDelegationConnector>head(_filter_1);
  }
  
  public boolean hasRequiredInfrastructureDelegationConnector(final ComposedStructure s, final InfrastructureRequiredRole r) {
    EList<Connector> _connectors__ComposedStructure = s.getConnectors__ComposedStructure();
    Iterable<RequiredDelegationConnector> _filter = Iterables.<RequiredDelegationConnector>filter(_connectors__ComposedStructure, RequiredDelegationConnector.class);
    final Function1<RequiredDelegationConnector, Boolean> _function = new Function1<RequiredDelegationConnector, Boolean>() {
      public Boolean apply(final RequiredDelegationConnector dc) {
        OperationRequiredRole _innerRequiredRole_RequiredDelegationConnector = dc.getInnerRequiredRole_RequiredDelegationConnector();
        return Boolean.valueOf(Objects.equal(_innerRequiredRole_RequiredDelegationConnector, r));
      }
    };
    Iterable<RequiredDelegationConnector> _filter_1 = IterableExtensions.<RequiredDelegationConnector>filter(_filter, _function);
    int _size = IterableExtensions.size(_filter_1);
    return (_size == 1);
  }
  
  public RequiredDelegationConnector getRequiredInfrastructureDelegationConnector(final ComposedStructure s, final InfrastructureRequiredRole r) {
    EList<Connector> _connectors__ComposedStructure = s.getConnectors__ComposedStructure();
    Iterable<RequiredDelegationConnector> _filter = Iterables.<RequiredDelegationConnector>filter(_connectors__ComposedStructure, RequiredDelegationConnector.class);
    final Function1<RequiredDelegationConnector, Boolean> _function = new Function1<RequiredDelegationConnector, Boolean>() {
      public Boolean apply(final RequiredDelegationConnector dc) {
        OperationRequiredRole _innerRequiredRole_RequiredDelegationConnector = dc.getInnerRequiredRole_RequiredDelegationConnector();
        return Boolean.valueOf(Objects.equal(_innerRequiredRole_RequiredDelegationConnector, r));
      }
    };
    Iterable<RequiredDelegationConnector> _filter_1 = IterableExtensions.<RequiredDelegationConnector>filter(_filter, _function);
    return IterableExtensions.<RequiredDelegationConnector>head(_filter_1);
  }
  
  public List<EntryLevelSystemCall> querySystemCallsInLoops(final ScenarioBehaviour scenBe) {
    EList<AbstractUserAction> _actions_ScenarioBehaviour = scenBe.getActions_ScenarioBehaviour();
    Iterable<Loop> _filter = Iterables.<Loop>filter(_actions_ScenarioBehaviour, Loop.class);
    final Function1<Loop, List<EntryLevelSystemCall>> _function = new Function1<Loop, List<EntryLevelSystemCall>>() {
      public List<EntryLevelSystemCall> apply(final Loop l) {
        ScenarioBehaviour _bodyBehaviour_Loop = l.getBodyBehaviour_Loop();
        return PCMext.this.querySystemCalls(_bodyBehaviour_Loop);
      }
    };
    Iterable<List<EntryLevelSystemCall>> _map = IterableExtensions.<Loop, List<EntryLevelSystemCall>>map(_filter, _function);
    Iterable<EntryLevelSystemCall> _flatten = Iterables.<EntryLevelSystemCall>concat(_map);
    return IterableExtensions.<EntryLevelSystemCall>toList(_flatten);
  }
  
  public List<EntryLevelSystemCall> querySystemCallsInBranches(final ScenarioBehaviour scenBe) {
    EList<AbstractUserAction> _actions_ScenarioBehaviour = scenBe.getActions_ScenarioBehaviour();
    Iterable<Branch> _filter = Iterables.<Branch>filter(_actions_ScenarioBehaviour, Branch.class);
    final Function1<Branch, EList<BranchTransition>> _function = new Function1<Branch, EList<BranchTransition>>() {
      public EList<BranchTransition> apply(final Branch it) {
        return it.getBranchTransitions_Branch();
      }
    };
    Iterable<EList<BranchTransition>> _map = IterableExtensions.<Branch, EList<BranchTransition>>map(_filter, _function);
    Iterable<BranchTransition> _flatten = Iterables.<BranchTransition>concat(_map);
    final Function1<BranchTransition, List<EntryLevelSystemCall>> _function_1 = new Function1<BranchTransition, List<EntryLevelSystemCall>>() {
      public List<EntryLevelSystemCall> apply(final BranchTransition it) {
        ScenarioBehaviour _branchedBehaviour_BranchTransition = it.getBranchedBehaviour_BranchTransition();
        return PCMext.this.querySystemCalls(_branchedBehaviour_BranchTransition);
      }
    };
    Iterable<List<EntryLevelSystemCall>> _map_1 = IterableExtensions.<BranchTransition, List<EntryLevelSystemCall>>map(_flatten, _function_1);
    Iterable<EntryLevelSystemCall> _flatten_1 = Iterables.<EntryLevelSystemCall>concat(_map_1);
    return IterableExtensions.<EntryLevelSystemCall>toList(_flatten_1);
  }
  
  protected List<EntryLevelSystemCall> _querySystemCalls(final ScenarioBehaviour scenBe) {
    ArrayList<EntryLevelSystemCall> _xblockexpression = null;
    {
      final ArrayList<EntryLevelSystemCall> result = new ArrayList<EntryLevelSystemCall>();
      EList<AbstractUserAction> _actions_ScenarioBehaviour = scenBe.getActions_ScenarioBehaviour();
      Iterable<EntryLevelSystemCall> _filter = Iterables.<EntryLevelSystemCall>filter(_actions_ScenarioBehaviour, EntryLevelSystemCall.class);
      Iterables.<EntryLevelSystemCall>addAll(result, _filter);
      List<EntryLevelSystemCall> _querySystemCallsInLoops = this.querySystemCallsInLoops(scenBe);
      result.addAll(_querySystemCallsInLoops);
      List<EntryLevelSystemCall> _querySystemCallsInBranches = this.querySystemCallsInBranches(scenBe);
      result.addAll(_querySystemCallsInBranches);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
  
  public Set<org.palladiosimulator.pcm.system.System> getSystemsFromCalls(final Collection<EntryLevelSystemCall> calls) {
    final Function1<EntryLevelSystemCall, org.palladiosimulator.pcm.system.System> _function = new Function1<EntryLevelSystemCall, org.palladiosimulator.pcm.system.System>() {
      public org.palladiosimulator.pcm.system.System apply(final EntryLevelSystemCall c) {
        OperationProvidedRole _providedRole_EntryLevelSystemCall = c.getProvidedRole_EntryLevelSystemCall();
        InterfaceProvidingEntity _providingEntity_ProvidedRole = _providedRole_EntryLevelSystemCall.getProvidingEntity_ProvidedRole();
        return ((org.palladiosimulator.pcm.system.System) _providingEntity_ProvidedRole);
      }
    };
    Iterable<org.palladiosimulator.pcm.system.System> _map = IterableExtensions.<EntryLevelSystemCall, org.palladiosimulator.pcm.system.System>map(calls, _function);
    return IterableExtensions.<org.palladiosimulator.pcm.system.System>toSet(_map);
  }
  
  protected List<EntryLevelSystemCall> _querySystemCalls(final UsageScenario us) {
    ScenarioBehaviour _scenarioBehaviour_UsageScenario = us.getScenarioBehaviour_UsageScenario();
    return this.querySystemCalls(_scenarioBehaviour_UsageScenario);
  }
  
  protected String _getID(final VariableReference vr) {
    return vr.getReferenceName();
  }
  
  protected String _getID(final AbstractNamedReference nsr) {
    return "this is never called";
  }
  
  protected String _getID(final NamespaceReference nsr) {
    String _referenceName = nsr.getReferenceName();
    String _plus = (_referenceName + ".");
    AbstractNamedReference _innerReference_NamespaceReference = nsr.getInnerReference_NamespaceReference();
    String _iD = this.getID(_innerReference_NamespaceReference);
    return (_plus + _iD);
  }
  
  public String parameterUsageLHS(final VariableUsage vu) {
    AbstractNamedReference _namedReference__VariableUsage = vu.getNamedReference__VariableUsage();
    return this.getID(_namedReference__VariableUsage);
  }
  
  protected boolean _isInnerReference(final VariableReference vr) {
    String _referenceName = vr.getReferenceName();
    return Objects.equal(_referenceName, "INNER");
  }
  
  protected boolean _isInnerReference(final AbstractNamedReference nsr) {
    return false;
  }
  
  protected boolean _isInnerReference(final NamespaceReference nsr) {
    boolean _or = false;
    String _referenceName = nsr.getReferenceName();
    boolean _equals = Objects.equal(_referenceName, "INNER");
    if (_equals) {
      _or = true;
    } else {
      AbstractNamedReference _innerReference_NamespaceReference = nsr.getInnerReference_NamespaceReference();
      boolean _isInnerReference = this.isInnerReference(_innerReference_NamespaceReference);
      boolean _equals_1 = (_isInnerReference == true);
      _or = _equals_1;
    }
    return _or;
  }
  
  protected Set<Entity> _collectRepositories(final org.palladiosimulator.pcm.system.System s) {
    HashSet<Entity> _xblockexpression = null;
    {
      final HashSet<Entity> result = new HashSet<Entity>();
      EList<AssemblyContext> _assemblyContexts__ComposedStructure = s.getAssemblyContexts__ComposedStructure();
      final Function1<AssemblyContext, Set<Entity>> _function = new Function1<AssemblyContext, Set<Entity>>() {
        public Set<Entity> apply(final AssemblyContext it) {
          RepositoryComponent _encapsulatedComponent__AssemblyContext = it.getEncapsulatedComponent__AssemblyContext();
          return PCMext.this.collectRepositories(_encapsulatedComponent__AssemblyContext);
        }
      };
      List<Set<Entity>> _map = ListExtensions.<AssemblyContext, Set<Entity>>map(_assemblyContexts__ComposedStructure, _function);
      Iterable<Entity> _flatten = Iterables.<Entity>concat(_map);
      Iterables.<Entity>addAll(result, _flatten);
      EList<ProvidedRole> _providedRoles_InterfaceProvidingEntity = s.getProvidedRoles_InterfaceProvidingEntity();
      Iterable<OperationProvidedRole> _filter = Iterables.<OperationProvidedRole>filter(_providedRoles_InterfaceProvidingEntity, OperationProvidedRole.class);
      final Function1<OperationProvidedRole, Set<Entity>> _function_1 = new Function1<OperationProvidedRole, Set<Entity>>() {
        public Set<Entity> apply(final OperationProvidedRole it) {
          return PCMext.this.collectRepositories(it);
        }
      };
      Iterable<Set<Entity>> _map_1 = IterableExtensions.<OperationProvidedRole, Set<Entity>>map(_filter, _function_1);
      Iterable<Entity> _flatten_1 = Iterables.<Entity>concat(_map_1);
      Iterables.<Entity>addAll(result, _flatten_1);
      EList<RequiredRole> _requiredRoles_InterfaceRequiringEntity = s.getRequiredRoles_InterfaceRequiringEntity();
      Iterable<OperationRequiredRole> _filter_1 = Iterables.<OperationRequiredRole>filter(_requiredRoles_InterfaceRequiringEntity, OperationRequiredRole.class);
      final Function1<OperationRequiredRole, Set<Entity>> _function_2 = new Function1<OperationRequiredRole, Set<Entity>>() {
        public Set<Entity> apply(final OperationRequiredRole it) {
          return PCMext.this.collectRepositories(it);
        }
      };
      Iterable<Set<Entity>> _map_2 = IterableExtensions.<OperationRequiredRole, Set<Entity>>map(_filter_1, _function_2);
      Iterable<Entity> _flatten_2 = Iterables.<Entity>concat(_map_2);
      Iterables.<Entity>addAll(result, _flatten_2);
      EList<RequiredRole> _requiredRoles_InterfaceRequiringEntity_1 = s.getRequiredRoles_InterfaceRequiringEntity();
      Iterable<InfrastructureRequiredRole> _filter_2 = Iterables.<InfrastructureRequiredRole>filter(_requiredRoles_InterfaceRequiringEntity_1, InfrastructureRequiredRole.class);
      final Function1<InfrastructureRequiredRole, Set<Entity>> _function_3 = new Function1<InfrastructureRequiredRole, Set<Entity>>() {
        public Set<Entity> apply(final InfrastructureRequiredRole it) {
          return PCMext.this.collectRepositories(it);
        }
      };
      Iterable<Set<Entity>> _map_3 = IterableExtensions.<InfrastructureRequiredRole, Set<Entity>>map(_filter_2, _function_3);
      Iterable<Entity> _flatten_3 = Iterables.<Entity>concat(_map_3);
      Iterables.<Entity>addAll(result, _flatten_3);
      EList<ProvidedRole> _providedRoles_InterfaceProvidingEntity_1 = s.getProvidedRoles_InterfaceProvidingEntity();
      Iterable<InfrastructureProvidedRole> _filter_3 = Iterables.<InfrastructureProvidedRole>filter(_providedRoles_InterfaceProvidingEntity_1, InfrastructureProvidedRole.class);
      final Function1<InfrastructureProvidedRole, Set<Entity>> _function_4 = new Function1<InfrastructureProvidedRole, Set<Entity>>() {
        public Set<Entity> apply(final InfrastructureProvidedRole it) {
          return PCMext.this.collectRepositories(it);
        }
      };
      Iterable<Set<Entity>> _map_4 = IterableExtensions.<InfrastructureProvidedRole, Set<Entity>>map(_filter_3, _function_4);
      Iterable<Entity> _flatten_4 = Iterables.<Entity>concat(_map_4);
      Iterables.<Entity>addAll(result, _flatten_4);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
  
  protected Set<Entity> _collectRepositories(final OperationProvidedRole pr) {
    OperationInterface _providedInterface__OperationProvidedRole = pr.getProvidedInterface__OperationProvidedRole();
    Repository _repository__Interface = _providedInterface__OperationProvidedRole.getRepository__Interface();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__Interface));
  }
  
  protected Set<Entity> _collectRepositories(final InfrastructureProvidedRole pr) {
    InfrastructureInterface _providedInterface__InfrastructureProvidedRole = pr.getProvidedInterface__InfrastructureProvidedRole();
    Repository _repository__Interface = _providedInterface__InfrastructureProvidedRole.getRepository__Interface();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__Interface));
  }
  
  protected Set<Entity> _collectRepositories(final OperationRequiredRole rr) {
    OperationInterface _requiredInterface__OperationRequiredRole = rr.getRequiredInterface__OperationRequiredRole();
    Repository _repository__Interface = _requiredInterface__OperationRequiredRole.getRepository__Interface();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__Interface));
  }
  
  protected Set<Entity> _collectRepositories(final InfrastructureRequiredRole rr) {
    InfrastructureInterface _requiredInterface__InfrastructureRequiredRole = rr.getRequiredInterface__InfrastructureRequiredRole();
    Repository _repository__Interface = _requiredInterface__InfrastructureRequiredRole.getRepository__Interface();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__Interface));
  }
  
  protected Set<Entity> _collectRepositories(final RepositoryComponent pct) {
    Repository _repository__RepositoryComponent = pct.getRepository__RepositoryComponent();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__RepositoryComponent));
  }
  
  protected Set<Entity> _collectRepositories(final CompositeComponent cc) {
    HashSet<Entity> _xblockexpression = null;
    {
      Repository _repository__RepositoryComponent = cc.getRepository__RepositoryComponent();
      final HashSet<Entity> result = CollectionLiterals.<Entity>newHashSet(((Entity) _repository__RepositoryComponent));
      EList<AssemblyContext> _assemblyContexts__ComposedStructure = cc.getAssemblyContexts__ComposedStructure();
      final Function1<AssemblyContext, Set<Entity>> _function = new Function1<AssemblyContext, Set<Entity>>() {
        public Set<Entity> apply(final AssemblyContext it) {
          RepositoryComponent _encapsulatedComponent__AssemblyContext = it.getEncapsulatedComponent__AssemblyContext();
          return PCMext.this.collectRepositories(_encapsulatedComponent__AssemblyContext);
        }
      };
      List<Set<Entity>> _map = ListExtensions.<AssemblyContext, Set<Entity>>map(_assemblyContexts__ComposedStructure, _function);
      Iterable<Entity> _flatten = Iterables.<Entity>concat(_map);
      Iterables.<Entity>addAll(result, _flatten);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
  
  protected Set<Entity> _collectRepositories(final InterfaceProvidingRequiringEntity pct) {
    return null;
  }
  
  public boolean hasSEFF(final Signature service, final RepositoryComponent c) {
    boolean _xifexpression = false;
    if ((c instanceof BasicComponent)) {
      EList<ServiceEffectSpecification> _serviceEffectSpecifications__BasicComponent = ((BasicComponent) c).getServiceEffectSpecifications__BasicComponent();
      final Function1<ServiceEffectSpecification, Boolean> _function = new Function1<ServiceEffectSpecification, Boolean>() {
        public Boolean apply(final ServiceEffectSpecification it) {
          Signature _describedService__SEFF = it.getDescribedService__SEFF();
          return Boolean.valueOf(Objects.equal(_describedService__SEFF, service));
        }
      };
      Iterable<ServiceEffectSpecification> _filter = IterableExtensions.<ServiceEffectSpecification>filter(_serviceEffectSpecifications__BasicComponent, _function);
      int _size = IterableExtensions.size(_filter);
      _xifexpression = (_size > 0);
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }
  
  public ServiceEffectSpecification getSEFF(final Signature service, final RepositoryComponent c) {
    EList<ServiceEffectSpecification> _serviceEffectSpecifications__BasicComponent = ((BasicComponent) c).getServiceEffectSpecifications__BasicComponent();
    final Function1<ServiceEffectSpecification, Boolean> _function = new Function1<ServiceEffectSpecification, Boolean>() {
      public Boolean apply(final ServiceEffectSpecification e) {
        Signature _describedService__SEFF = e.getDescribedService__SEFF();
        return Boolean.valueOf(Objects.equal(_describedService__SEFF, service));
      }
    };
    Iterable<ServiceEffectSpecification> _filter = IterableExtensions.<ServiceEffectSpecification>filter(_serviceEffectSpecifications__BasicComponent, _function);
    return IterableExtensions.<ServiceEffectSpecification>head(_filter);
  }
  
  public Set<Completion> getAllCompletions(final ComposedStructure s) {
    Set<Completion> _xblockexpression = null;
    {
      final Set<Completion> result = new HashSet<Completion>();
      EList<AssemblyContext> _assemblyContexts__ComposedStructure = s.getAssemblyContexts__ComposedStructure();
      final Function1<AssemblyContext, RepositoryComponent> _function = new Function1<AssemblyContext, RepositoryComponent>() {
        public RepositoryComponent apply(final AssemblyContext it) {
          return it.getEncapsulatedComponent__AssemblyContext();
        }
      };
      List<RepositoryComponent> _map = ListExtensions.<AssemblyContext, RepositoryComponent>map(_assemblyContexts__ComposedStructure, _function);
      Iterable<Completion> _filter = Iterables.<Completion>filter(_map, Completion.class);
      Iterables.<Completion>addAll(result, _filter);
      EList<AssemblyContext> _assemblyContexts__ComposedStructure_1 = s.getAssemblyContexts__ComposedStructure();
      final Function1<AssemblyContext, RepositoryComponent> _function_1 = new Function1<AssemblyContext, RepositoryComponent>() {
        public RepositoryComponent apply(final AssemblyContext it) {
          return it.getEncapsulatedComponent__AssemblyContext();
        }
      };
      List<RepositoryComponent> _map_1 = ListExtensions.<AssemblyContext, RepositoryComponent>map(_assemblyContexts__ComposedStructure_1, _function_1);
      Iterable<ComposedStructure> _filter_1 = Iterables.<ComposedStructure>filter(_map_1, 
        ComposedStructure.class);
      final Function1<ComposedStructure, Boolean> _function_2 = new Function1<ComposedStructure, Boolean>() {
        public Boolean apply(final ComposedStructure comp) {
          boolean _and = false;
          boolean _notEquals = (!Objects.equal(comp, null));
          if (!_notEquals) {
            _and = false;
          } else {
            _and = (!(comp instanceof Completion));
          }
          return Boolean.valueOf(_and);
        }
      };
      Iterable<ComposedStructure> _filter_2 = IterableExtensions.<ComposedStructure>filter(_filter_1, _function_2);
      final Function1<ComposedStructure, Set<Completion>> _function_3 = new Function1<ComposedStructure, Set<Completion>>() {
        public Set<Completion> apply(final ComposedStructure it) {
          return PCMext.this.getAllCompletions(it);
        }
      };
      Iterable<Set<Completion>> _map_2 = IterableExtensions.<ComposedStructure, Set<Completion>>map(_filter_2, _function_3);
      Iterable<Completion> _flatten = Iterables.<Completion>concat(_map_2);
      Iterables.<Completion>addAll(result, _flatten);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
  
  public AbstractAction findStopAction(final AbstractAction a) {
    AbstractAction _xifexpression = null;
    if ((a instanceof StopAction)) {
      _xifexpression = a;
    } else {
      AbstractAction _xifexpression_1 = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
        _xifexpression_1 = this.findStopAction(_successor_AbstractAction_1);
      } else {
        _xifexpression_1 = null;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
  
  public AbstractUserAction findStop(final AbstractUserAction a) {
    AbstractUserAction _xifexpression = null;
    if ((a instanceof Stop)) {
      _xifexpression = a;
    } else {
      AbstractUserAction _xifexpression_1 = null;
      AbstractUserAction _successor = a.getSuccessor();
      boolean _notEquals = (!Objects.equal(_successor, null));
      if (_notEquals) {
        AbstractUserAction _successor_1 = a.getSuccessor();
        _xifexpression_1 = this.findStop(_successor_1);
      } else {
        _xifexpression_1 = null;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
  
  public List<InterfaceProvidingEntity> getProvidingEntities(final List<ProvidedRole> pr) {
    return this.getProvidingEntitiesRecursive(pr, 0);
  }
  
  public List<InterfaceProvidingEntity> getProvidingEntitiesRecursive(final List<ProvidedRole> pr, final int i) {
    List<InterfaceProvidingEntity> _xifexpression = null;
    int _size = pr.size();
    boolean _lessThan = (i < _size);
    if (_lessThan) {
      List<InterfaceProvidingEntity> _xifexpression_1 = null;
      List<InterfaceProvidingEntity> _providingEntitiesRecursive = this.getProvidingEntitiesRecursive(pr, (i + 1));
      ProvidedRole _get = pr.get(i);
      InterfaceProvidingEntity _providingEntity_ProvidedRole = _get.getProvidingEntity_ProvidedRole();
      boolean _contains = _providingEntitiesRecursive.contains(_providingEntity_ProvidedRole);
      if (_contains) {
        _xifexpression_1 = this.getProvidingEntitiesRecursive(pr, (i + 1));
      } else {
        List<InterfaceProvidingEntity> _xblockexpression = null;
        {
          final List<InterfaceProvidingEntity> result = this.getProvidingEntitiesRecursive(pr, (i + 1));
          ProvidedRole _get_1 = pr.get(i);
          InterfaceProvidingEntity _providingEntity_ProvidedRole_1 = _get_1.getProvidingEntity_ProvidedRole();
          result.add(_providingEntity_ProvidedRole_1);
          _xblockexpression = result;
        }
        _xifexpression_1 = _xblockexpression;
      }
      _xifexpression = _xifexpression_1;
    } else {
      _xifexpression = CollectionLiterals.<InterfaceProvidingEntity>emptyList();
    }
    return _xifexpression;
  }
  
  public BasicComponent findContainerComponent(final EObject o) {
    BasicComponent _xifexpression = null;
    if ((o instanceof BasicComponent)) {
      _xifexpression = ((BasicComponent) o);
    } else {
      EObject _eContainer = o.eContainer();
      _xifexpression = this.findContainerComponent(_eContainer);
    }
    return _xifexpression;
  }
  
  public List<org.palladiosimulator.pcm.system.System> uniqueSystemList(final List<org.palladiosimulator.pcm.system.System> s) {
    List<org.palladiosimulator.pcm.system.System> _xifexpression = null;
    boolean _notEquals = (!Objects.equal(s, null));
    if (_notEquals) {
      ArrayList<org.palladiosimulator.pcm.system.System> _newArrayList = CollectionLiterals.<org.palladiosimulator.pcm.system.System>newArrayList();
      _xifexpression = this.recursiveList(s, _newArrayList, 0);
    }
    return _xifexpression;
  }
  
  private List<org.palladiosimulator.pcm.system.System> recursiveList(final List<org.palladiosimulator.pcm.system.System> s, final List<org.palladiosimulator.pcm.system.System> result, final int pos) {
    List<org.palladiosimulator.pcm.system.System> _xifexpression = null;
    int _size = s.size();
    boolean _lessThan = (pos < _size);
    if (_lessThan) {
      List<org.palladiosimulator.pcm.system.System> _xifexpression_1 = null;
      boolean _and = false;
      org.palladiosimulator.pcm.system.System _get = s.get(pos);
      boolean _notEquals = (!Objects.equal(_get, null));
      if (!_notEquals) {
        _and = false;
      } else {
        org.palladiosimulator.pcm.system.System _get_1 = s.get(pos);
        boolean _contains = result.contains(_get_1);
        _and = _contains;
      }
      if (_and) {
        _xifexpression_1 = this.recursiveList(s, result, (pos + 1));
      } else {
        List<org.palladiosimulator.pcm.system.System> _xblockexpression = null;
        {
          org.palladiosimulator.pcm.system.System _get_2 = s.get(pos);
          final org.palladiosimulator.pcm.system.System element = ((org.palladiosimulator.pcm.system.System) _get_2);
          boolean _notEquals_1 = (!Objects.equal(element, null));
          if (_notEquals_1) {
            result.add(element);
          }
          _xblockexpression = this.recursiveList(s, result, (pos + 1));
        }
        _xifexpression_1 = _xblockexpression;
      }
      _xifexpression = _xifexpression_1;
    } else {
      return result;
    }
    return _xifexpression;
  }
  
  public String getParentSubsystemsIdConcatenationFor(final org.palladiosimulator.pcm.system.System s, final ComposedStructure toMatch) {
    String _parentIdConcatenationFor = this.getParentIdConcatenationFor(s, toMatch);
    String[] _split = _parentIdConcatenationFor.split(" ");
    return IterableExtensions.<String>last(((Iterable<String>)Conversions.doWrapArray(_split)));
  }
  
  private String _getParentIdConcatenationFor(final RepositoryComponent s, final ComposedStructure toMatch) {
    return "";
  }
  
  private String _getParentIdConcatenationFor(final org.palladiosimulator.pcm.system.System s, final ComposedStructure toMatch) {
    return this.getSystemParentIdConcatenationFor(s, toMatch);
  }
  
  private String _getParentIdConcatenationFor(final SubSystem s, final ComposedStructure toMatch) {
    return this.getSystemParentIdConcatenationFor(s, toMatch);
  }
  
  private String getSystemParentIdConcatenationFor(final ComposedStructure s, final ComposedStructure toMatch) {
    EList<AssemblyContext> _assemblyContexts__ComposedStructure = s.getAssemblyContexts__ComposedStructure();
    final Function1<AssemblyContext, String> _function = new Function1<AssemblyContext, String>() {
      public String apply(final AssemblyContext ac) {
        RepositoryComponent _encapsulatedComponent__AssemblyContext = ac.getEncapsulatedComponent__AssemblyContext();
        String _matchID = PCMext.this.matchID(_encapsulatedComponent__AssemblyContext, toMatch);
        String _id = ac.getId();
        return (_matchID + _id);
      }
    };
    List<String> _map = ListExtensions.<AssemblyContext, String>map(_assemblyContexts__ComposedStructure, _function);
    final Function1<String, Boolean> _function_1 = new Function1<String, Boolean>() {
      public Boolean apply(final String s2) {
        String _id = toMatch.getId();
        return Boolean.valueOf(s2.contains(_id));
      }
    };
    return IterableExtensions.<String>findFirst(_map, _function_1);
  }
  
  private String matchID(final RepositoryComponent s, final ComposedStructure toMatch) {
    String _xifexpression = null;
    String _id = s.getId();
    String _id_1 = toMatch.getId();
    boolean _contains = _id.contains(_id_1);
    if (_contains) {
      String _id_2 = toMatch.getId();
      _xifexpression = (_id_2 + " ");
    } else {
      _xifexpression = this.getParentIdConcatenationFor(s, toMatch);
    }
    return _xifexpression;
  }
  
  protected List<ExternalCallAction> _queryExternalCallActions(final AbstractAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xifexpression = null;
    AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
    boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
    if (_notEquals) {
      AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
      _xifexpression = this.queryExternalCallActions(_successor_AbstractAction_1, result);
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }
  
  protected List<ExternalCallAction> _queryExternalCallActions(final ExternalCallAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xifexpression = null;
    AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
    boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
    if (_notEquals) {
      List<ExternalCallAction> _xblockexpression = null;
      {
        result.add(a);
        AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
        _xblockexpression = this.queryExternalCallActions(_successor_AbstractAction_1, result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }
  
  protected List<ExternalCallAction> _queryExternalCallActions(final BranchAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xblockexpression = null;
    {
      EList<AbstractBranchTransition> _branches_Branch = a.getBranches_Branch();
      this.queryExternalCallActions(_branches_Branch, result);
      List<ExternalCallAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
        _xifexpression = this.queryExternalCallActions(_successor_AbstractAction_1, result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected List<ExternalCallAction> _queryExternalCallActions(final List<AbstractBranchTransition> list, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xifexpression = null;
    int _size = list.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      List<ExternalCallAction> _xblockexpression = null;
      {
        AbstractBranchTransition _head = IterableExtensions.<AbstractBranchTransition>head(list);
        ResourceDemandingBehaviour _branchBehaviour_BranchTransition = _head.getBranchBehaviour_BranchTransition();
        EList<AbstractAction> _steps_Behaviour = _branchBehaviour_BranchTransition.getSteps_Behaviour();
        StartAction _findStart = this.findStart(_steps_Behaviour);
        this.queryExternalCallActions(_findStart, result);
        Iterable<AbstractBranchTransition> _tail = IterableExtensions.<AbstractBranchTransition>tail(list);
        List<AbstractBranchTransition> _list = IterableExtensions.<AbstractBranchTransition>toList(_tail);
        _xblockexpression = this.queryExternalCallActions(_list, result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }
  
  protected List<ExternalCallAction> _queryExternalCallActions(final AbstractLoopAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xblockexpression = null;
    {
      ResourceDemandingBehaviour _bodyBehaviour_Loop = a.getBodyBehaviour_Loop();
      EList<AbstractAction> _steps_Behaviour = _bodyBehaviour_Loop.getSteps_Behaviour();
      StartAction _findStart = this.findStart(_steps_Behaviour);
      this.queryExternalCallActions(_findStart, result);
      List<ExternalCallAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
        _xifexpression = this.queryExternalCallActions(_successor_AbstractAction_1, result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected List<ExternalCallAction> _queryExternalCallActions(final ForkAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xblockexpression = null;
    {
      EList<ForkedBehaviour> _asynchronousForkedBehaviours_ForkAction = a.getAsynchronousForkedBehaviours_ForkAction();
      this.queryExternalCallActionsForkedBehaviour(_asynchronousForkedBehaviours_ForkAction, result);
      SynchronisationPoint _synchronisingBehaviours_ForkAction = a.getSynchronisingBehaviours_ForkAction();
      boolean _notEquals = (!Objects.equal(_synchronisingBehaviours_ForkAction, null));
      if (_notEquals) {
        SynchronisationPoint _synchronisingBehaviours_ForkAction_1 = a.getSynchronisingBehaviours_ForkAction();
        this.queryExternalCallActions(_synchronisingBehaviours_ForkAction_1, result);
      }
      List<ExternalCallAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals_1 = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals_1) {
        AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
        _xifexpression = this.queryExternalCallActions(_successor_AbstractAction_1, result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected List<ExternalCallAction> _queryExternalCallActions(final SynchronisationPoint p, final List<ExternalCallAction> result) {
    EList<ForkedBehaviour> _synchronousForkedBehaviours_SynchronisationPoint = p.getSynchronousForkedBehaviours_SynchronisationPoint();
    return this.queryExternalCallActionsForkedBehaviour(_synchronousForkedBehaviours_SynchronisationPoint, result);
  }
  
  public List<ExternalCallAction> queryExternalCallActionsForkedBehaviour(final List<ForkedBehaviour> list, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xifexpression = null;
    int _size = list.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      List<ExternalCallAction> _xblockexpression = null;
      {
        ForkedBehaviour _head = IterableExtensions.<ForkedBehaviour>head(list);
        this.queryExternalCallActions(_head, result);
        Iterable<ForkedBehaviour> _tail = IterableExtensions.<ForkedBehaviour>tail(list);
        List<ForkedBehaviour> _list = IterableExtensions.<ForkedBehaviour>toList(_tail);
        _xblockexpression = this.queryExternalCallActionsForkedBehaviour(_list, result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }
  
  protected List<ExternalCallAction> _queryExternalCallActions(final ForkedBehaviour b, final List<ExternalCallAction> result) {
    EList<AbstractAction> _steps_Behaviour = b.getSteps_Behaviour();
    StartAction _findStart = this.findStart(_steps_Behaviour);
    return this.queryExternalCallActions(_findStart, result);
  }
  
  protected List<InternalAction> _queryInternalActions(final AbstractAction a, final List<InternalAction> result) {
    List<InternalAction> _xifexpression = null;
    AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
    boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
    if (_notEquals) {
      AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
      _xifexpression = this.queryInternalActions(_successor_AbstractAction_1, result);
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }
  
  protected List<InternalAction> _queryInternalActions(final InternalAction a, final List<InternalAction> result) {
    List<InternalAction> _xifexpression = null;
    AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
    boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
    if (_notEquals) {
      List<InternalAction> _xblockexpression = null;
      {
        final ArrayList<InternalAction> newResult = CollectionLiterals.<InternalAction>newArrayList(a);
        newResult.addAll(result);
        AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
        _xblockexpression = this.queryInternalActions(_successor_AbstractAction_1, newResult);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }
  
  protected List<InternalAction> _queryInternalActions(final BranchAction a, final List<InternalAction> result) {
    List<InternalAction> _xblockexpression = null;
    {
      EList<AbstractBranchTransition> _branches_Branch = a.getBranches_Branch();
      this.queryInternalActions(_branches_Branch, result);
      List<InternalAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
        _xifexpression = this.queryInternalActions(_successor_AbstractAction_1, result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected List<InternalAction> _queryInternalActions(final List<AbstractBranchTransition> list, final List<InternalAction> result) {
    List<InternalAction> _xifexpression = null;
    int _size = list.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      List<InternalAction> _xblockexpression = null;
      {
        AbstractBranchTransition _head = IterableExtensions.<AbstractBranchTransition>head(list);
        ResourceDemandingBehaviour _branchBehaviour_BranchTransition = _head.getBranchBehaviour_BranchTransition();
        EList<AbstractAction> _steps_Behaviour = _branchBehaviour_BranchTransition.getSteps_Behaviour();
        StartAction _findStart = this.findStart(_steps_Behaviour);
        this.queryInternalActions(_findStart, result);
        Iterable<AbstractBranchTransition> _tail = IterableExtensions.<AbstractBranchTransition>tail(list);
        List<AbstractBranchTransition> _list = IterableExtensions.<AbstractBranchTransition>toList(_tail);
        _xblockexpression = this.queryInternalActions(_list, result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }
  
  protected List<InternalAction> _queryInternalActions(final AbstractLoopAction a, final List<InternalAction> result) {
    List<InternalAction> _xblockexpression = null;
    {
      ResourceDemandingBehaviour _bodyBehaviour_Loop = a.getBodyBehaviour_Loop();
      EList<AbstractAction> _steps_Behaviour = _bodyBehaviour_Loop.getSteps_Behaviour();
      StartAction _findStart = this.findStart(_steps_Behaviour);
      this.queryInternalActions(_findStart, result);
      List<InternalAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
        _xifexpression = this.queryInternalActions(_successor_AbstractAction_1, result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected List<InternalAction> _queryInternalActions(final ForkAction a, final List<InternalAction> result) {
    List<InternalAction> _xblockexpression = null;
    {
      EList<ForkedBehaviour> _asynchronousForkedBehaviours_ForkAction = a.getAsynchronousForkedBehaviours_ForkAction();
      this.queryInternalActionsForkedBehaviour(_asynchronousForkedBehaviours_ForkAction, result);
      SynchronisationPoint _synchronisingBehaviours_ForkAction = a.getSynchronisingBehaviours_ForkAction();
      boolean _notEquals = (!Objects.equal(_synchronisingBehaviours_ForkAction, null));
      if (_notEquals) {
        SynchronisationPoint _synchronisingBehaviours_ForkAction_1 = a.getSynchronisingBehaviours_ForkAction();
        this.queryInternalActions(_synchronisingBehaviours_ForkAction_1, result);
      }
      List<InternalAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals_1 = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals_1) {
        AbstractAction _successor_AbstractAction_1 = a.getSuccessor_AbstractAction();
        _xifexpression = this.queryInternalActions(_successor_AbstractAction_1, result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected List<InternalAction> _queryInternalActions(final SynchronisationPoint p, final List<InternalAction> result) {
    EList<ForkedBehaviour> _synchronousForkedBehaviours_SynchronisationPoint = p.getSynchronousForkedBehaviours_SynchronisationPoint();
    return this.queryInternalActionsForkedBehaviour(_synchronousForkedBehaviours_SynchronisationPoint, result);
  }
  
  public List<InternalAction> queryInternalActionsForkedBehaviour(final List<ForkedBehaviour> list, final List<InternalAction> result) {
    List<InternalAction> _xifexpression = null;
    int _size = list.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      List<InternalAction> _xblockexpression = null;
      {
        ForkedBehaviour _head = IterableExtensions.<ForkedBehaviour>head(list);
        this.queryInternalActions(_head, result);
        Iterable<ForkedBehaviour> _tail = IterableExtensions.<ForkedBehaviour>tail(list);
        List<ForkedBehaviour> _list = IterableExtensions.<ForkedBehaviour>toList(_tail);
        _xblockexpression = this.queryInternalActionsForkedBehaviour(_list, result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }
  
  protected List<InternalAction> _queryInternalActions(final ForkedBehaviour b, final List<InternalAction> result) {
    EList<AbstractAction> _steps_Behaviour = b.getSteps_Behaviour();
    StartAction _findStart = this.findStart(_steps_Behaviour);
    return this.queryInternalActions(_findStart, result);
  }
  
  public ResourceDemandingSEFF getRdseff(final AbstractAction action) {
    return Helper.getRdseff(action);
  }
  
  public boolean test(final Connector c, final AssemblyContext ctx, final Role r) {
    if (c instanceof AssemblyEventConnector
         && r instanceof SinkRole) {
      return _test((AssemblyEventConnector)c, ctx, (SinkRole)r);
    } else if (c instanceof AssemblyInfrastructureConnector
         && r instanceof InfrastructureRequiredRole) {
      return _test((AssemblyInfrastructureConnector)c, ctx, (InfrastructureRequiredRole)r);
    } else if (c instanceof AssemblyConnector
         && r instanceof RequiredRole) {
      return _test((AssemblyConnector)c, ctx, (RequiredRole)r);
    } else if (c != null
         && r instanceof RequiredRole) {
      return _test(c, ctx, (RequiredRole)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(c, ctx, r).toString());
    }
  }
  
  public List<EntryLevelSystemCall> querySystemCalls(final Entity scenBe) {
    if (scenBe instanceof ScenarioBehaviour) {
      return _querySystemCalls((ScenarioBehaviour)scenBe);
    } else if (scenBe instanceof UsageScenario) {
      return _querySystemCalls((UsageScenario)scenBe);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(scenBe).toString());
    }
  }
  
  public String getID(final AbstractNamedReference nsr) {
    if (nsr instanceof NamespaceReference) {
      return _getID((NamespaceReference)nsr);
    } else if (nsr instanceof VariableReference) {
      return _getID((VariableReference)nsr);
    } else if (nsr != null) {
      return _getID(nsr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(nsr).toString());
    }
  }
  
  public boolean isInnerReference(final AbstractNamedReference nsr) {
    if (nsr instanceof NamespaceReference) {
      return _isInnerReference((NamespaceReference)nsr);
    } else if (nsr instanceof VariableReference) {
      return _isInnerReference((VariableReference)nsr);
    } else if (nsr != null) {
      return _isInnerReference(nsr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(nsr).toString());
    }
  }
  
  public Set<Entity> collectRepositories(final CDOObject cc) {
    if (cc instanceof CompositeComponent) {
      return _collectRepositories((CompositeComponent)cc);
    } else if (cc instanceof org.palladiosimulator.pcm.system.System) {
      return _collectRepositories((org.palladiosimulator.pcm.system.System)cc);
    } else if (cc instanceof RepositoryComponent) {
      return _collectRepositories((RepositoryComponent)cc);
    } else if (cc instanceof InterfaceProvidingRequiringEntity) {
      return _collectRepositories((InterfaceProvidingRequiringEntity)cc);
    } else if (cc instanceof InfrastructureProvidedRole) {
      return _collectRepositories((InfrastructureProvidedRole)cc);
    } else if (cc instanceof InfrastructureRequiredRole) {
      return _collectRepositories((InfrastructureRequiredRole)cc);
    } else if (cc instanceof OperationProvidedRole) {
      return _collectRepositories((OperationProvidedRole)cc);
    } else if (cc instanceof OperationRequiredRole) {
      return _collectRepositories((OperationRequiredRole)cc);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(cc).toString());
    }
  }
  
  private String getParentIdConcatenationFor(final InterfaceProvidingRequiringEntity s, final ComposedStructure toMatch) {
    if (s instanceof SubSystem) {
      return _getParentIdConcatenationFor((SubSystem)s, toMatch);
    } else if (s instanceof org.palladiosimulator.pcm.system.System) {
      return _getParentIdConcatenationFor((org.palladiosimulator.pcm.system.System)s, toMatch);
    } else if (s instanceof RepositoryComponent) {
      return _getParentIdConcatenationFor((RepositoryComponent)s, toMatch);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(s, toMatch).toString());
    }
  }
  
  public List<ExternalCallAction> queryExternalCallActions(final Object a, final List<ExternalCallAction> result) {
    if (a instanceof AbstractLoopAction) {
      return _queryExternalCallActions((AbstractLoopAction)a, result);
    } else if (a instanceof BranchAction) {
      return _queryExternalCallActions((BranchAction)a, result);
    } else if (a instanceof ExternalCallAction) {
      return _queryExternalCallActions((ExternalCallAction)a, result);
    } else if (a instanceof ForkAction) {
      return _queryExternalCallActions((ForkAction)a, result);
    } else if (a instanceof AbstractAction) {
      return _queryExternalCallActions((AbstractAction)a, result);
    } else if (a instanceof ForkedBehaviour) {
      return _queryExternalCallActions((ForkedBehaviour)a, result);
    } else if (a instanceof SynchronisationPoint) {
      return _queryExternalCallActions((SynchronisationPoint)a, result);
    } else if (a instanceof List) {
      return _queryExternalCallActions((List<AbstractBranchTransition>)a, result);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(a, result).toString());
    }
  }
  
  public List<InternalAction> queryInternalActions(final Object a, final List<InternalAction> result) {
    if (a instanceof AbstractLoopAction) {
      return _queryInternalActions((AbstractLoopAction)a, result);
    } else if (a instanceof BranchAction) {
      return _queryInternalActions((BranchAction)a, result);
    } else if (a instanceof ForkAction) {
      return _queryInternalActions((ForkAction)a, result);
    } else if (a instanceof InternalAction) {
      return _queryInternalActions((InternalAction)a, result);
    } else if (a instanceof AbstractAction) {
      return _queryInternalActions((AbstractAction)a, result);
    } else if (a instanceof ForkedBehaviour) {
      return _queryInternalActions((ForkedBehaviour)a, result);
    } else if (a instanceof SynchronisationPoint) {
      return _queryInternalActions((SynchronisationPoint)a, result);
    } else if (a instanceof List) {
      return _queryInternalActions((List<AbstractBranchTransition>)a, result);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(a, result).toString());
    }
  }
}
