package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.CallsXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaCoreXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.ResourcesXpt;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.analyzer.completions.DelegatingExternalCallAction;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.HardwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.NetworkInducedFailureType;
import org.palladiosimulator.pcm.reliability.ResourceTimeoutFailureType;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;
import org.palladiosimulator.pcm.seff.seff_reliability.FailureHandlingEntity;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryAction;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryActionBehaviour;

@SuppressWarnings("all")
public abstract class SEFFBodyXpt {
  @Inject
  @Extension
  private CallsXpt _callsXpt;
  
  @Inject
  @Extension
  private PCMext _pCMext;
  
  @Inject
  @Extension
  private ResourcesXpt _resourcesXpt;
  
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;
  
  @Inject
  @Extension
  private JavaCoreXpt _javaCoreXpt;
  
  protected String _action(final AbstractAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.newLine();
    return _builder.toString();
  }
  
  protected String _action(final StartAction action) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder.toString();
  }
  
  protected String _action(final StopAction action) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder.toString();
  }
  
  protected String _action(final CollectionIteratorAction action) {
    return null;
  }
  
  protected String _action(final LoopAction action) {
    return null;
  }
  
  protected CharSequence _action(final BranchAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    return _builder;
  }
  
  protected CharSequence _action(final AcquireAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    return _builder;
  }
  
  protected CharSequence _action(final ReleaseAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    return _builder;
  }
  
  protected CharSequence _action(final SetVariableAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    return _builder;
  }
  
  protected CharSequence _action(final ForkAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    return _builder;
  }
  
  protected CharSequence _action(final DelegatingExternalCallAction action) {
    return null;
  }
  
  protected CharSequence _action(final InternalAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/* InternalAction - START */");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// software failures:");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _failureInternalActionPreTM = this.failureInternalActionPreTM(action);
    _builder.append(_failureInternalActionPreTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// direct resource demands:");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _resourceDemands = this._resourcesXpt.resourceDemands(action);
    _builder.append(_resourceDemands, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// infrastructure calls:");
    _builder.newLine();
    {
      EList<InfrastructureCall> _infrastructureCall__Action = action.getInfrastructureCall__Action();
      for(final InfrastructureCall call : _infrastructureCall__Action) {
        _builder.append("\t");
        CharSequence _call = this._callsXpt.call(call, action);
        _builder.append(_call, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("/* InternalAction - END */");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _action(final ExternalCallAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/* ExternalCallAction - START */");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{ //this scope is needed if the same service is called multiple times in one SEFF. Otherwise there is a duplicate local variable definition.");
    _builder.newLine();
    _builder.append("\t\t");
    OperationSignature _calledService_ExternalService = action.getCalledService_ExternalService();
    OperationRequiredRole _role_ExternalService = action.getRole_ExternalService();
    String _javaName = this._javaNamesExt.javaName(_role_ExternalService);
    String _plus = ("myContext.getRole" + _javaName);
    String _plus_1 = (_plus + "().");
    EList<VariableUsage> _inputVariableUsages__CallAction = action.getInputVariableUsages__CallAction();
    EList<VariableUsage> _returnVariableUsage__CallReturnAction = action.getReturnVariableUsage__CallReturnAction();
    CharSequence _call = this._callsXpt.call(_calledService_ExternalService, action, _plus_1, _inputVariableUsages__CallAction, _returnVariableUsage__CallReturnAction);
    _builder.append(_call, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("/* ExternalCallAction - END */");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _action(final RecoveryAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{ /* RecoveryAction - START */");
    _builder.newLine();
    _builder.append("\t");
    RecoveryActionBehaviour _primaryBehaviour__RecoveryAction = action.getPrimaryBehaviour__RecoveryAction();
    String _recoveryActionAlternative = this.recoveryActionAlternative(_primaryBehaviour__RecoveryAction);
    _builder.append(_recoveryActionAlternative, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("} /* RecoveryAction - END */");
    _builder.newLine();
    return _builder;
  }
  
  public String recoveryActionAlternative(final RecoveryActionBehaviour behaviour) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/* RecoveryActionBehaviour - START */");
    _builder.newLine();
    String _id = behaviour.getId();
    final String id = this._javaNamesExt.javaVariableName(_id);
    _builder.newLineIfNotEmpty();
    CharSequence _initFailureHandling = this.initFailureHandling(behaviour, id);
    _builder.append(_initFailureHandling, "");
    _builder.newLineIfNotEmpty();
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t");
    EList<AbstractAction> _steps_Behaviour = behaviour.getSteps_Behaviour();
    StartAction _findStart = this._pCMext.findStart(_steps_Behaviour);
    String _actions = this._javaCoreXpt.actions(_findStart);
    _builder.append(_actions, "\t");
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("} catch(de.uka.ipd.sdq.simucomframework.exceptions.FailureException ex_");
    _builder.append(id, "");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Remember the type of the failure-on-demand occurrence:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("failureException_");
    _builder.append(id, "\t");
    _builder.append(" = ex_");
    _builder.append(id, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Remove all additional stack frames; they are invalid now:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for(int frameCount_");
    _builder.append(id, "\t");
    _builder.append(" = 0; frameCount_");
    _builder.append(id, "\t");
    _builder.append(" < ctx.getStack().size() - stackSize_");
    _builder.append(id, "\t");
    _builder.append("; ++frameCount_");
    _builder.append(id, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("ctx.getStack().removeStackFrame();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      EList<RecoveryActionBehaviour> _failureHandlingAlternatives__RecoveryActionBehaviour = behaviour.getFailureHandlingAlternatives__RecoveryActionBehaviour();
      for(final RecoveryActionBehaviour alternative : _failureHandlingAlternatives__RecoveryActionBehaviour) {
        _builder.append("\t");
        CharSequence _nextRecoveryActionAlternative = this.nextRecoveryActionAlternative(alternative, id);
        _builder.append(_nextRecoveryActionAlternative, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("} finally {}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// no more alternatives.");
    _builder.newLine();
    _builder.append("if(failureException_");
    _builder.append(id, "");
    _builder.append("!=null) { // failure occurred? ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("throw failureException_");
    _builder.append(id, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/* RecoveryActionBehaviour - END */");
    _builder.newLine();
    return _builder.toString();
  }
  
  public CharSequence checkIfExceptionIsHandled(final FailureHandlingEntity entity, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("(");
    _builder.newLine();
    {
      EList<FailureType> _failureTypes_FailureHandlingEntity = entity.getFailureTypes_FailureHandlingEntity();
      int _size = _failureTypes_FailureHandlingEntity.size();
      boolean _equals = (_size == 0);
      if (_equals) {
        _builder.append("false");
        _builder.newLine();
      } else {
        EList<FailureType> _failureTypes_FailureHandlingEntity_1 = entity.getFailureTypes_FailureHandlingEntity();
        final Function1<FailureType, CharSequence> _function = new Function1<FailureType, CharSequence>() {
          public CharSequence apply(final FailureType it) {
            return SEFFBodyXpt.this.checkFailureTypeMatch(it, id);
          }
        };
        List<CharSequence> _map = ListExtensions.<FailureType, CharSequence>map(_failureTypes_FailureHandlingEntity_1, _function);
        String _join = IterableExtensions.join(_map, "||");
        _builder.append(_join, "");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(")");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _checkFailureTypeMatch(final FailureType ft, final String id) {
    return null;
  }
  
  protected CharSequence _checkFailureTypeMatch(final SoftwareInducedFailureType ft, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((ft instanceof ResourceTimeoutFailureType)) {
        final ResourceTimeoutFailureType resourceFailureType = ((ResourceTimeoutFailureType) ft);
        _builder.newLineIfNotEmpty();
        _builder.append("(");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("(failureException_");
        _builder.append(id, "  ");
        _builder.append(".getFailureType() instanceof");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("org.palladiosimulator.reliability.MarkovResourceTimeoutFailureType)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("&&");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("(((org.palladiosimulator.reliability.MarkovResourceTimeoutFailureType)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("failureException_");
        _builder.append(id, "  ");
        _builder.append(".getFailureType()).getPassiveResourceId().equals(");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("\"");
        PassiveResource _passiveResource__ResourceTimeoutFailureType = resourceFailureType.getPassiveResource__ResourceTimeoutFailureType();
        String _id = _passiveResource__ResourceTimeoutFailureType.getId();
        _builder.append(_id, "  ");
        _builder.append("\"))");
        _builder.newLineIfNotEmpty();
        _builder.append(")");
        _builder.newLine();
      } else {
        _builder.append("(");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("(failureException_");
        _builder.append(id, "  ");
        _builder.append(".getFailureType() instanceof");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("org.palladiosimulator.reliability.MarkovSoftwareInducedFailureType)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("&&");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("(((org.palladiosimulator.reliability.MarkovSoftwareInducedFailureType)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("failureException_");
        _builder.append(id, "  ");
        _builder.append(".getFailureType()).getSoftwareFailureId().equals(\"");
        String _id_1 = ft.getId();
        _builder.append(_id_1, "  ");
        _builder.append("\"))");
        _builder.newLineIfNotEmpty();
        _builder.append(")");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  protected CharSequence _checkFailureTypeMatch(final HardwareInducedFailureType ft, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("(");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("(failureException_");
    _builder.append(id, "  ");
    _builder.append(".getFailureType() instanceof");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("org.palladiosimulator.reliability.MarkovHardwareInducedFailureType)");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("&&");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("(((org.palladiosimulator.reliability.MarkovHardwareInducedFailureType)");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("failureException_");
    _builder.append(id, "  ");
    _builder.append(".getFailureType()).getResourceTypeId().equals(");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("\"");
    ProcessingResourceType _processingResourceType__HardwareInducedFailureType = ft.getProcessingResourceType__HardwareInducedFailureType();
    String _id = _processingResourceType__HardwareInducedFailureType.getId();
    _builder.append(_id, "  ");
    _builder.append("\"))");
    _builder.newLineIfNotEmpty();
    _builder.append(")");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _checkFailureTypeMatch(final NetworkInducedFailureType ft, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("(");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("(failureException_");
    _builder.append(id, "  ");
    _builder.append(".getFailureType() instanceof");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("org.palladiosimulator.reliability.MarkovNetworkInducedFailureType)");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("&&");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("(((org.palladiosimulator.reliability.MarkovNetworkInducedFailureType)");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("failureException_");
    _builder.append(id, "  ");
    _builder.append(".getFailureType()).getCommLinkResourceTypeId().equals(");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("\"");
    CommunicationLinkResourceType _communicationLinkResourceType__NetworkInducedFailureType = ft.getCommunicationLinkResourceType__NetworkInducedFailureType();
    String _id = _communicationLinkResourceType__NetworkInducedFailureType.getId();
    _builder.append(_id, "  ");
    _builder.append("\"))");
    _builder.newLineIfNotEmpty();
    _builder.append(")");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence initFailureHandling(final Object obj, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.exceptions.FailureException failureException_");
    _builder.append(id, "");
    _builder.append("=null;");
    _builder.newLineIfNotEmpty();
    _builder.append("int stackSize_");
    _builder.append(id, "");
    _builder.append("=ctx.getStack().size();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence nextRecoveryActionAlternative(final RecoveryActionBehaviour behaviour, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Let the next alternative behaviour handle the failure, if");
    _builder.newLine();
    _builder.append("// (i)  the previous alternatives did not already handle it, and");
    _builder.newLine();
    _builder.append("// (ii) the handled failure types of the next alternative include");
    _builder.newLine();
    _builder.append("//      the occurred failure type:");
    _builder.newLine();
    _builder.append("if(failureException_");
    _builder.append(id, "");
    _builder.append(" != null)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(");
    CharSequence _checkIfExceptionIsHandled = this.checkIfExceptionIsHandled(behaviour, id);
    _builder.append(_checkIfExceptionIsHandled, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// Mark the original exception as handled (even if the");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// handling alternative fails itself, this will be a new");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// failure, and the original failure is counted as handled):");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ctx.getModel().getFailureStatistics().increaseFailureCounter(org.palladiosimulator.reliability.FailureStatistics.FailureType.HANDLED, failureException_");
    _builder.append(id, "\t\t");
    _builder.append(".getFailureType());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("failureException_");
    _builder.append(id, "\t\t");
    _builder.append(" = null;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    String _recoveryActionAlternative = this.recoveryActionAlternative(behaviour);
    _builder.append(_recoveryActionAlternative, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence catchFailureExceptions(final ExternalCallAction action, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(action, null));
      if (_notEquals) {
        _builder.append("catch(de.uka.ipd.sdq.simucomframework.exceptions.FailureException ex) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Remember the type of the failure-on-demand occurrence:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("failureException_");
        _builder.append(id, "\t");
        _builder.append(" = ex;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Remove all additional stack frames; they are invalid now:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for(int frameCount_");
        _builder.append(id, "\t");
        _builder.append(" = 0; frameCount_");
        _builder.append(id, "\t");
        _builder.append(" < ctx.getStack().size() - stackSize_");
        _builder.append(id, "\t");
        _builder.append("; ++frameCount_");
        _builder.append(id, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("ctx.getStack().removeStackFrame();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("finally {}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence failureInternalActionPreTM(final InternalAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence action(final AbstractAction action) {
    if (action instanceof DelegatingExternalCallAction) {
      return _action((DelegatingExternalCallAction)action);
    } else if (action instanceof CollectionIteratorAction) {
      return _action((CollectionIteratorAction)action);
    } else if (action instanceof LoopAction) {
      return _action((LoopAction)action);
    } else if (action instanceof AcquireAction) {
      return _action((AcquireAction)action);
    } else if (action instanceof BranchAction) {
      return _action((BranchAction)action);
    } else if (action instanceof ExternalCallAction) {
      return _action((ExternalCallAction)action);
    } else if (action instanceof ForkAction) {
      return _action((ForkAction)action);
    } else if (action instanceof InternalAction) {
      return _action((InternalAction)action);
    } else if (action instanceof ReleaseAction) {
      return _action((ReleaseAction)action);
    } else if (action instanceof SetVariableAction) {
      return _action((SetVariableAction)action);
    } else if (action instanceof StartAction) {
      return _action((StartAction)action);
    } else if (action instanceof StopAction) {
      return _action((StopAction)action);
    } else if (action instanceof RecoveryAction) {
      return _action((RecoveryAction)action);
    } else if (action != null) {
      return _action(action);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(action).toString());
    }
  }
  
  public CharSequence checkFailureTypeMatch(final FailureType ft, final String id) {
    if (ft instanceof HardwareInducedFailureType) {
      return _checkFailureTypeMatch((HardwareInducedFailureType)ft, id);
    } else if (ft instanceof NetworkInducedFailureType) {
      return _checkFailureTypeMatch((NetworkInducedFailureType)ft, id);
    } else if (ft instanceof SoftwareInducedFailureType) {
      return _checkFailureTypeMatch((SoftwareInducedFailureType)ft, id);
    } else if (ft != null) {
      return _checkFailureTypeMatch(ft, id);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ft, id).toString());
    }
  }
}
