package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;

@SuppressWarnings("all")
public class SensorsExt {
  @Inject
  @Extension
  private PCMext _pCMext;
  
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;
  
  public String externalCallActionDescription(final OperationSignature os, final Object call) {
    OperationInterface _interface__OperationSignature = os.getInterface__OperationSignature();
    String _entityName = _interface__OperationSignature.getEntityName();
    String _plus = ("Call " + _entityName);
    String _plus_1 = (_plus + ".");
    String _javaSignature = this._javaNamesExt.javaSignature(os);
    String _plus_2 = (_plus_1 + _javaSignature);
    String _plus_3 = (_plus_2 + " <Component: ");
    BasicComponent _findContainerComponent = this._pCMext.findContainerComponent(((EObject) call));
    String _entityName_1 = _findContainerComponent.getEntityName();
    String _plus_4 = (_plus_3 + _entityName_1);
    String _plus_5 = (_plus_4 + 
      ", AssemblyCtx: \"+this.assemblyContext.getId()+\", CallID: ");
    String _id = ((ExternalCallAction) call).getId();
    String _plus_6 = (_plus_5 + _id);
    return (_plus_6 + ">");
  }
  
  public String internalActionDescription(final InfrastructureSignature os, final Object call) {
    InfrastructureInterface _infrastructureInterface__InfrastructureSignature = os.getInfrastructureInterface__InfrastructureSignature();
    String _entityName = _infrastructureInterface__InfrastructureSignature.getEntityName();
    String _plus = ("Call " + _entityName);
    String _plus_1 = (_plus + ".");
    String _javaSignature = this._javaNamesExt.javaSignature(os);
    String _plus_2 = (_plus_1 + _javaSignature);
    String _plus_3 = (_plus_2 + 
      " <Component: ");
    BasicComponent _findContainerComponent = this._pCMext.findContainerComponent(((EObject) call));
    String _entityName_1 = _findContainerComponent.getEntityName();
    String _plus_4 = (_plus_3 + _entityName_1);
    String _plus_5 = (_plus_4 + 
      ", AssemblyCtx: \"+this.assemblyContext.getId()+\", CallID: ");
    String _id = ((InternalAction) call).getId();
    String _plus_6 = (_plus_5 + _id);
    return (_plus_6 + ">");
  }
  
  public String entryLevelSystemCallActionDescription(final OperationSignature os, final Object call) {
    String _javaSignature = this._javaNamesExt.javaSignature(os);
    String _plus = ("Call_" + _javaSignature);
    String _plus_1 = (_plus + " <EntryLevelSystemCall id: ");
    String _id = ((Entity) call).getId();
    String _plus_2 = (_plus_1 + _id);
    return (_plus_2 + " >");
  }
  
  public String entryLevelSystemCallActionDescription(final InfrastructureSignature os, final Object call) {
    String _javaSignature = this._javaNamesExt.javaSignature(os);
    String _plus = ("Call_" + _javaSignature);
    String _plus_1 = (_plus + " <EntryLevelSystemCall id: ");
    String _id = ((Entity) call).getId();
    String _plus_2 = (_plus_1 + _id);
    return (_plus_2 + " >");
  }
  
  public Set<ExternalCallAction> getExternalCallActions(final BasicComponent component) {
    HashSet<ExternalCallAction> _xblockexpression = null;
    {
      final HashSet<ExternalCallAction> result = CollectionLiterals.<ExternalCallAction>newHashSet();
      EList<ServiceEffectSpecification> _serviceEffectSpecifications__BasicComponent = component.getServiceEffectSpecifications__BasicComponent();
      final Procedure1<ServiceEffectSpecification> _function = new Procedure1<ServiceEffectSpecification>() {
        public void apply(final ServiceEffectSpecification it) {
          TreeIterator<EObject> _eAllContents = it.eAllContents();
          Iterator<ExternalCallAction> _filter = Iterators.<ExternalCallAction>filter(_eAllContents, ExternalCallAction.class);
          List<ExternalCallAction> _list = IteratorExtensions.<ExternalCallAction>toList(_filter);
          result.addAll(_list);
        }
      };
      IterableExtensions.<ServiceEffectSpecification>forEach(_serviceEffectSpecifications__BasicComponent, _function);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
  
  public String seffDescription(final OperationSignature os, final RepositoryComponent component) {
    OperationInterface _interface__OperationSignature = os.getInterface__OperationSignature();
    String _entityName = _interface__OperationSignature.getEntityName();
    String _plus = ("SEFF " + _entityName);
    String _plus_1 = (_plus + ".");
    String _javaSignature = this._javaNamesExt.javaSignature(os);
    String _plus_2 = (_plus_1 + _javaSignature);
    String _plus_3 = (_plus_2 + " <Component: ");
    String _entityName_1 = component.getEntityName();
    String _plus_4 = (_plus_3 + _entityName_1);
    return (_plus_4 + ", AssemblyCtx: \"+this.assemblyContext.getId()+\">");
  }
  
  public String seffDescription(final InfrastructureSignature os, final RepositoryComponent component) {
    InfrastructureInterface _infrastructureInterface__InfrastructureSignature = os.getInfrastructureInterface__InfrastructureSignature();
    String _entityName = _infrastructureInterface__InfrastructureSignature.getEntityName();
    String _plus = ("SEFF " + _entityName);
    String _plus_1 = (_plus + ".");
    String _javaSignature = this._javaNamesExt.javaSignature(os);
    String _plus_2 = (_plus_1 + _javaSignature);
    String _plus_3 = (_plus_2 + 
      " <Component: ");
    String _entityName_1 = component.getEntityName();
    String _plus_4 = (_plus_3 + _entityName_1);
    return (_plus_4 + ", AssemblyCtx: \"+this.assemblyContext.getId()+\">");
  }
}
