package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.CallsXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;

@SuppressWarnings("all")
public class UserActionsXpt {
  @Inject
  @Extension
  private CallsXpt _callsXpt;
  
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;
  
  protected CharSequence _userAction(final Start start) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _userAction(final Stop stop) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _userAction(final EntryLevelSystemCall elsc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Set the priority for ");
    String _entityName = elsc.getEntityName();
    _builder.append(_entityName, "");
    _builder.newLineIfNotEmpty();
    _builder.append("thread.setPriority(");
    int _priority = elsc.getPriority();
    _builder.append(_priority, "");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    OperationSignature _operationSignature__EntryLevelSystemCall = elsc.getOperationSignature__EntryLevelSystemCall();
    OperationProvidedRole _providedRole_EntryLevelSystemCall = elsc.getProvidedRole_EntryLevelSystemCall();
    String _portMemberVar = this._javaNamesExt.portMemberVar(_providedRole_EntryLevelSystemCall);
    String _plus = (_portMemberVar + ".");
    EList<VariableUsage> _inputParameterUsages_EntryLevelSystemCall = elsc.getInputParameterUsages_EntryLevelSystemCall();
    CharSequence _call = this._callsXpt.call(_operationSignature__EntryLevelSystemCall, elsc, _plus, _inputParameterUsages_EntryLevelSystemCall, 
      new Function0<List<VariableUsage>>() {
        public List<VariableUsage> apply() {
          return null;
        }
      }.apply());
    _builder.append(_call, "");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _userAction(final Loop loop) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _userAction(final Branch branch) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _userAction(final Delay delay) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence userAction(final AbstractUserAction branch) {
    if (branch instanceof Branch) {
      return _userAction((Branch)branch);
    } else if (branch instanceof Delay) {
      return _userAction((Delay)branch);
    } else if (branch instanceof EntryLevelSystemCall) {
      return _userAction((EntryLevelSystemCall)branch);
    } else if (branch instanceof Loop) {
      return _userAction((Loop)branch);
    } else if (branch instanceof Start) {
      return _userAction((Start)branch);
    } else if (branch instanceof Stop) {
      return _userAction((Stop)branch);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(branch).toString());
    }
  }
}
