package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.AllocationXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim.SimResourcesXpt;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.subsystem.SubSystem;

@SuppressWarnings("all")
public class SimAllocationXpt extends AllocationXpt {
  @Inject
  @Extension
  private M2TFileSystemAccess fsa;
  
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;
  
  @Inject
  @Extension
  private PCMext _pCMext;
  
  @Inject
  @Extension
  private SimResourcesXpt _simResourcesXpt;
  
  public void allocation(final Allocation a) {
    ResourceEnvironment _targetResourceEnvironment_Allocation = a.getTargetResourceEnvironment_Allocation();
    this._simResourcesXpt.resourceEnvironmentRoot(_targetResourceEnvironment_Allocation);
    String _fqnAllocationContext = this._javaNamesExt.fqnAllocationContext(a);
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_fqnAllocationContext);
    final String fileName = (_fqnToDirectoryPath + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _fqnAllocationContextPackage = this._javaNamesExt.fqnAllocationContextPackage(a);
    _builder.append(_fqnAllocationContextPackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("public class ");
    String _fqnAllocationContextClass = this._javaNamesExt.fqnAllocationContextClass(a);
    _builder.append(_fqnAllocationContextClass, "");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("extends de.uka.ipd.sdq.simucomframework.Context {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _fqnAllocationContextClass_1 = this._javaNamesExt.fqnAllocationContextClass(a);
    _builder.append(_fqnAllocationContextClass_1, "\t");
    _builder.append("(de.uka.ipd.sdq.simucomframework.model.SimuComModel myModel) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(myModel);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected void initialiseAssemblyContextLookup() {");
    _builder.newLine();
    {
      EList<AllocationContext> _allocationContexts_Allocation = a.getAllocationContexts_Allocation();
      for(final AllocationContext context : _allocationContexts_Allocation) {
        _builder.append("\t\t");
        org.palladiosimulator.pcm.system.System _system_Allocation = a.getSystem_Allocation();
        CharSequence _assemblyContextLink = this.assemblyContextLink(context, _system_Allocation);
        _builder.append(_assemblyContextLink, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }
  
  public CharSequence assemblyContextLink(final AllocationContext context, final org.palladiosimulator.pcm.system.System system) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    String _xifexpression = null;
    boolean _or = false;
    AssemblyContext _assemblyContext_AllocationContext = context.getAssemblyContext_AllocationContext();
    ComposedStructure _parentStructure__AssemblyContext = _assemblyContext_AllocationContext.getParentStructure__AssemblyContext();
    if ((_parentStructure__AssemblyContext instanceof SubSystem)) {
      _or = true;
    } else {
      AssemblyContext _assemblyContext_AllocationContext_1 = context.getAssemblyContext_AllocationContext();
      ComposedStructure _parentStructure__AssemblyContext_1 = _assemblyContext_AllocationContext_1.getParentStructure__AssemblyContext();
      _or = (_parentStructure__AssemblyContext_1 instanceof Completion);
    }
    if (_or) {
      AssemblyContext _assemblyContext_AllocationContext_2 = context.getAssemblyContext_AllocationContext();
      String _id = _assemblyContext_AllocationContext_2.getId();
      AssemblyContext _assemblyContext_AllocationContext_3 = context.getAssemblyContext_AllocationContext();
      ComposedStructure _parentStructure__AssemblyContext_2 = _assemblyContext_AllocationContext_3.getParentStructure__AssemblyContext();
      String _parentSubsystemsIdConcatenationFor = this._pCMext.getParentSubsystemsIdConcatenationFor(system, 
        ((ComposedProvidingRequiringEntity) _parentStructure__AssemblyContext_2));
      _xifexpression = (_id + _parentSubsystemsIdConcatenationFor);
    } else {
      AssemblyContext _assemblyContext_AllocationContext_4 = context.getAssemblyContext_AllocationContext();
      _xifexpression = _assemblyContext_AllocationContext_4.getId();
    }
    final String fullAssemblyContextID = _xifexpression;
    _builder.newLineIfNotEmpty();
    _builder.append("linkAssemblyContextAndResourceContainer(\"");
    _builder.append(fullAssemblyContextID, "");
    _builder.append("\",\"");
    ResourceContainer _resourceContainer_AllocationContext = context.getResourceContainer_AllocationContext();
    String _id_1 = _resourceContainer_AllocationContext.getId();
    _builder.append(_id_1, "");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.newLine();
    {
      boolean _or_1 = false;
      if (((context.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext() instanceof CompositeComponent) || (context.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext() instanceof SubSystem))) {
        _or_1 = true;
      } else {
        AssemblyContext _assemblyContext_AllocationContext_5 = context.getAssemblyContext_AllocationContext();
        RepositoryComponent _encapsulatedComponent__AssemblyContext = _assemblyContext_AllocationContext_5.getEncapsulatedComponent__AssemblyContext();
        _or_1 = (_encapsulatedComponent__AssemblyContext instanceof Completion);
      }
      if (_or_1) {
        {
          AssemblyContext _assemblyContext_AllocationContext_6 = context.getAssemblyContext_AllocationContext();
          RepositoryComponent _encapsulatedComponent__AssemblyContext_1 = _assemblyContext_AllocationContext_6.getEncapsulatedComponent__AssemblyContext();
          EList<AssemblyContext> _assemblyContexts__ComposedStructure = ((CompositeComponent) _encapsulatedComponent__AssemblyContext_1).getAssemblyContexts__ComposedStructure();
          for(final AssemblyContext assemblyContext : _assemblyContexts__ComposedStructure) {
            String _compositeAllocation = this.compositeAllocation(assemblyContext, context, fullAssemblyContextID, system);
            _builder.append(_compositeAllocation, "");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  public String compositeAllocation(final AssemblyContext context, final AllocationContext allocCxt, final String parentid, final org.palladiosimulator.pcm.system.System system) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("linkAssemblyContextAndResourceContainer(\"");
    String _id = context.getId();
    _builder.append(_id, "");
    _builder.append("\"+\"");
    _builder.append(parentid, "");
    _builder.append("\",\"");
    ResourceContainer _resourceContainer_AllocationContext = allocCxt.getResourceContainer_AllocationContext();
    String _id_1 = _resourceContainer_AllocationContext.getId();
    _builder.append(_id_1, "");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    {
      boolean _or = false;
      if (((context.getEncapsulatedComponent__AssemblyContext() instanceof CompositeComponent) || (context.getEncapsulatedComponent__AssemblyContext() instanceof SubSystem))) {
        _or = true;
      } else {
        RepositoryComponent _encapsulatedComponent__AssemblyContext = context.getEncapsulatedComponent__AssemblyContext();
        _or = (_encapsulatedComponent__AssemblyContext instanceof Completion);
      }
      if (_or) {
        {
          RepositoryComponent _encapsulatedComponent__AssemblyContext_1 = context.getEncapsulatedComponent__AssemblyContext();
          EList<AssemblyContext> _assemblyContexts__ComposedStructure = ((CompositeComponent) _encapsulatedComponent__AssemblyContext_1).getAssemblyContexts__ComposedStructure();
          for(final AssemblyContext assemblyContext : _assemblyContexts__ComposedStructure) {
            String _id_2 = context.getId();
            String _plus = (_id_2 + parentid);
            String _compositeAllocation = this.compositeAllocation(assemblyContext, allocCxt, _plus, system);
            _builder.append(_compositeAllocation, "");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          RepositoryComponent _encapsulatedComponent__AssemblyContext_2 = context.getEncapsulatedComponent__AssemblyContext();
          EList<AssemblyContext> _assemblyContexts__ComposedStructure_1 = ((CompositeComponent) _encapsulatedComponent__AssemblyContext_2).getAssemblyContexts__ComposedStructure();
          for(final AssemblyContext assemblyContext_1 : _assemblyContexts__ComposedStructure_1) {
            String _id_3 = context.getId();
            String _compositeAllocation_1 = this.compositeAllocation(assemblyContext_1, allocCxt, _id_3, system);
            _builder.append(_compositeAllocation_1, "");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder.toString();
  }
  
  public String allocationTM(final Allocation allocation) {
    String _xblockexpression = null;
    {
      this.allocation(allocation);
      _xblockexpression = "";
    }
    return _xblockexpression;
  }
}
