package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.DummiesXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim.SimProvidedPortsXpt;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.qosannotations.SpecifiedQoSAnnotation;
import org.palladiosimulator.pcm.qosannotations.qos_performance.SpecifiedExecutionTime;
import org.palladiosimulator.pcm.qosannotations.qos_performance.SystemSpecifiedExecutionTime;
import org.palladiosimulator.pcm.qosannotations.qos_reliability.SpecifiedReliabilityAnnotation;
import org.palladiosimulator.pcm.reliability.ExternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.HardwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.NetworkInducedFailureType;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;

@SuppressWarnings("all")
public class SimDummiesXpt extends DummiesXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;
  
  protected CharSequence _dummyMethodBody(final OperationSignature os, final org.palladiosimulator.pcm.system.System s, final OperationRequiredRole r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe resultStackFrame = ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe();");
    _builder.newLine();
    EList<QoSAnnotations> _qosAnnotations_System = s.getQosAnnotations_System();
    final Function1<QoSAnnotations, EList<SpecifiedQoSAnnotation>> _function = new Function1<QoSAnnotations, EList<SpecifiedQoSAnnotation>>() {
      public EList<SpecifiedQoSAnnotation> apply(final QoSAnnotations it) {
        return it.getSpecifiedQoSAnnotations_QoSAnnotations();
      }
    };
    List<EList<SpecifiedQoSAnnotation>> _map = ListExtensions.<QoSAnnotations, EList<SpecifiedQoSAnnotation>>map(_qosAnnotations_System, _function);
    Iterable<SpecifiedQoSAnnotation> _flatten = Iterables.<SpecifiedQoSAnnotation>concat(_map);
    final Function1<SpecifiedQoSAnnotation, Boolean> _function_1 = new Function1<SpecifiedQoSAnnotation, Boolean>() {
      public Boolean apply(final SpecifiedQoSAnnotation it) {
        boolean _and = false;
        boolean _and_1 = false;
        if (!(it instanceof SpecifiedReliabilityAnnotation)) {
          _and_1 = false;
        } else {
          Role _role_SpecifiedQoSAnnotation = it.getRole_SpecifiedQoSAnnotation();
          boolean _equals = Objects.equal(_role_SpecifiedQoSAnnotation, r);
          _and_1 = _equals;
        }
        if (!_and_1) {
          _and = false;
        } else {
          Signature _signature_SpecifiedQoSAnnation = it.getSignature_SpecifiedQoSAnnation();
          boolean _equals_1 = Objects.equal(_signature_SpecifiedQoSAnnation, os);
          _and = _equals_1;
        }
        return Boolean.valueOf(_and);
      }
    };
    final Iterable<SpecifiedQoSAnnotation> annotations1 = IterableExtensions.<SpecifiedQoSAnnotation>filter(_flatten, _function_1);
    _builder.newLineIfNotEmpty();
    {
      int _size = IterableExtensions.size(annotations1);
      boolean _equals = (_size == 1);
      if (_equals) {
        _builder.append("// Simulate a failure that occurs with a predefined probability:");
        _builder.newLine();
        _builder.append("if (ctx.getModel().getConfig().getSimulateFailures()) {   ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("double accProbability = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("double randValue = ctx.getModel().getConfiguration().getRandomGenerator().random();");
        _builder.newLine();
        _builder.append("\t");
        {
          SpecifiedQoSAnnotation _head = IterableExtensions.<SpecifiedQoSAnnotation>head(annotations1);
          EList<ExternalFailureOccurrenceDescription> _externalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation = ((SpecifiedReliabilityAnnotation) _head).getExternalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation();
          for(final ExternalFailureOccurrenceDescription fod : _externalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation) {
            String _id = r.getId();
            String _id_1 = os.getId();
            CharSequence _failureOccurrence = this.failureOccurrence(fod, _id, _id_1);
            _builder.append(_failureOccurrence, "\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    EList<QoSAnnotations> _qosAnnotations_System_1 = s.getQosAnnotations_System();
    final Function1<QoSAnnotations, EList<SpecifiedQoSAnnotation>> _function_2 = new Function1<QoSAnnotations, EList<SpecifiedQoSAnnotation>>() {
      public EList<SpecifiedQoSAnnotation> apply(final QoSAnnotations it) {
        return it.getSpecifiedQoSAnnotations_QoSAnnotations();
      }
    };
    List<EList<SpecifiedQoSAnnotation>> _map_1 = ListExtensions.<QoSAnnotations, EList<SpecifiedQoSAnnotation>>map(_qosAnnotations_System_1, _function_2);
    Iterable<SpecifiedQoSAnnotation> _flatten_1 = Iterables.<SpecifiedQoSAnnotation>concat(_map_1);
    final Function1<SpecifiedQoSAnnotation, Boolean> _function_3 = new Function1<SpecifiedQoSAnnotation, Boolean>() {
      public Boolean apply(final SpecifiedQoSAnnotation it) {
        boolean _and = false;
        boolean _and_1 = false;
        if (!(it instanceof SystemSpecifiedExecutionTime)) {
          _and_1 = false;
        } else {
          Role _role_SpecifiedQoSAnnotation = it.getRole_SpecifiedQoSAnnotation();
          boolean _equals = Objects.equal(_role_SpecifiedQoSAnnotation, r);
          _and_1 = _equals;
        }
        if (!_and_1) {
          _and = false;
        } else {
          Signature _signature_SpecifiedQoSAnnation = it.getSignature_SpecifiedQoSAnnation();
          boolean _equals_1 = Objects.equal(_signature_SpecifiedQoSAnnation, os);
          _and = _equals_1;
        }
        return Boolean.valueOf(_and);
      }
    };
    final Iterable<SpecifiedQoSAnnotation> annotations2 = IterableExtensions.<SpecifiedQoSAnnotation>filter(_flatten_1, _function_3);
    _builder.newLineIfNotEmpty();
    {
      int _size_1 = IterableExtensions.size(annotations2);
      boolean _equals_1 = (_size_1 == 1);
      if (_equals_1) {
        _builder.append("double delay = de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter.toDouble(ctx.evaluate(\"");
        SpecifiedQoSAnnotation _head_1 = IterableExtensions.<SpecifiedQoSAnnotation>head(annotations2);
        PCMRandomVariable _specification_SpecifiedExecutionTime = ((SpecifiedExecutionTime) _head_1).getSpecification_SpecifiedExecutionTime();
        String _specification = _specification_SpecifiedExecutionTime.getSpecification();
        String _specificationString = this._javaNamesExt.specificationString(_specification);
        _builder.append(_specificationString, "");
        _builder.append("\"));");
        _builder.newLineIfNotEmpty();
        _builder.append("logger.info(\"SystemExternalCall ");
        SpecifiedQoSAnnotation _head_2 = IterableExtensions.<SpecifiedQoSAnnotation>head(annotations2);
        Signature _signature_SpecifiedQoSAnnation = _head_2.getSignature_SpecifiedQoSAnnation();
        String _entityName = _signature_SpecifiedQoSAnnation.getEntityName();
        _builder.append(_entityName, "");
        _builder.append(" delaying execution for \"+delay);");
        _builder.newLineIfNotEmpty();
        _builder.append("ctx.getThread().hold(delay);");
        _builder.newLine();
      }
    }
    _builder.append("return resultStackFrame;");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _dummyMethodBody(final InfrastructureSignature is, final org.palladiosimulator.pcm.system.System s, final InfrastructureRequiredRole r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe resultStackFrame = ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe();");
    _builder.newLine();
    EList<QoSAnnotations> _qosAnnotations_System = s.getQosAnnotations_System();
    final Function1<QoSAnnotations, EList<SpecifiedQoSAnnotation>> _function = new Function1<QoSAnnotations, EList<SpecifiedQoSAnnotation>>() {
      public EList<SpecifiedQoSAnnotation> apply(final QoSAnnotations it) {
        return it.getSpecifiedQoSAnnotations_QoSAnnotations();
      }
    };
    List<EList<SpecifiedQoSAnnotation>> _map = ListExtensions.<QoSAnnotations, EList<SpecifiedQoSAnnotation>>map(_qosAnnotations_System, _function);
    Iterable<SpecifiedQoSAnnotation> _flatten = Iterables.<SpecifiedQoSAnnotation>concat(_map);
    final Function1<SpecifiedQoSAnnotation, Boolean> _function_1 = new Function1<SpecifiedQoSAnnotation, Boolean>() {
      public Boolean apply(final SpecifiedQoSAnnotation it) {
        boolean _and = false;
        boolean _and_1 = false;
        if (!(it instanceof SpecifiedReliabilityAnnotation)) {
          _and_1 = false;
        } else {
          Role _role_SpecifiedQoSAnnotation = it.getRole_SpecifiedQoSAnnotation();
          boolean _equals = Objects.equal(_role_SpecifiedQoSAnnotation, r);
          _and_1 = _equals;
        }
        if (!_and_1) {
          _and = false;
        } else {
          Signature _signature_SpecifiedQoSAnnation = it.getSignature_SpecifiedQoSAnnation();
          boolean _equals_1 = Objects.equal(_signature_SpecifiedQoSAnnation, is);
          _and = _equals_1;
        }
        return Boolean.valueOf(_and);
      }
    };
    final Iterable<SpecifiedQoSAnnotation> annotations1 = IterableExtensions.<SpecifiedQoSAnnotation>filter(_flatten, _function_1);
    _builder.newLineIfNotEmpty();
    {
      int _size = IterableExtensions.size(annotations1);
      boolean _equals = (_size == 1);
      if (_equals) {
        _builder.append("// Simulate a failure that occurs with a predefined probability:");
        _builder.newLine();
        _builder.append("if (ctx.getModel().getConfig().getSimulateFailures()) {   ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("double accProbability = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("double randValue = Math.random();");
        _builder.newLine();
        _builder.append("\t");
        {
          SpecifiedQoSAnnotation _head = IterableExtensions.<SpecifiedQoSAnnotation>head(annotations1);
          EList<ExternalFailureOccurrenceDescription> _externalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation = ((SpecifiedReliabilityAnnotation) _head).getExternalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation();
          for(final ExternalFailureOccurrenceDescription fod : _externalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation) {
            String _id = r.getId();
            String _id_1 = is.getId();
            CharSequence _failureOccurrence = this.failureOccurrence(fod, _id, _id_1);
            _builder.append(_failureOccurrence, "\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    EList<QoSAnnotations> _qosAnnotations_System_1 = s.getQosAnnotations_System();
    final Function1<QoSAnnotations, EList<SpecifiedQoSAnnotation>> _function_2 = new Function1<QoSAnnotations, EList<SpecifiedQoSAnnotation>>() {
      public EList<SpecifiedQoSAnnotation> apply(final QoSAnnotations it) {
        return it.getSpecifiedQoSAnnotations_QoSAnnotations();
      }
    };
    List<EList<SpecifiedQoSAnnotation>> _map_1 = ListExtensions.<QoSAnnotations, EList<SpecifiedQoSAnnotation>>map(_qosAnnotations_System_1, _function_2);
    Iterable<SpecifiedQoSAnnotation> _flatten_1 = Iterables.<SpecifiedQoSAnnotation>concat(_map_1);
    final Function1<SpecifiedQoSAnnotation, Boolean> _function_3 = new Function1<SpecifiedQoSAnnotation, Boolean>() {
      public Boolean apply(final SpecifiedQoSAnnotation it) {
        boolean _and = false;
        boolean _and_1 = false;
        if (!(it instanceof SystemSpecifiedExecutionTime)) {
          _and_1 = false;
        } else {
          Role _role_SpecifiedQoSAnnotation = it.getRole_SpecifiedQoSAnnotation();
          boolean _equals = Objects.equal(_role_SpecifiedQoSAnnotation, r);
          _and_1 = _equals;
        }
        if (!_and_1) {
          _and = false;
        } else {
          Signature _signature_SpecifiedQoSAnnation = it.getSignature_SpecifiedQoSAnnation();
          boolean _equals_1 = Objects.equal(_signature_SpecifiedQoSAnnation, is);
          _and = _equals_1;
        }
        return Boolean.valueOf(_and);
      }
    };
    final Iterable<SpecifiedQoSAnnotation> annotations2 = IterableExtensions.<SpecifiedQoSAnnotation>filter(_flatten_1, _function_3);
    _builder.newLineIfNotEmpty();
    {
      int _size_1 = IterableExtensions.size(annotations2);
      boolean _equals_1 = (_size_1 == 1);
      if (_equals_1) {
        _builder.append("double delay = de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter.toDouble(ctx.evaluate(\"");
        SpecifiedQoSAnnotation _head_1 = IterableExtensions.<SpecifiedQoSAnnotation>head(annotations2);
        PCMRandomVariable _specification_SpecifiedExecutionTime = ((SpecifiedExecutionTime) _head_1).getSpecification_SpecifiedExecutionTime();
        String _specification = _specification_SpecifiedExecutionTime.getSpecification();
        String _specificationString = this._javaNamesExt.specificationString(_specification);
        _builder.append(_specificationString, "");
        _builder.append("\"));");
        _builder.newLineIfNotEmpty();
        _builder.append("logger.info(\"SystemExternalCall ");
        SpecifiedQoSAnnotation _head_2 = IterableExtensions.<SpecifiedQoSAnnotation>head(annotations2);
        Signature _signature_SpecifiedQoSAnnation = _head_2.getSignature_SpecifiedQoSAnnation();
        String _entityName = _signature_SpecifiedQoSAnnation.getEntityName();
        _builder.append(_entityName, "");
        _builder.append(" delaying execution for \"+delay);");
        _builder.newLineIfNotEmpty();
        _builder.append("ctx.getThread().hold(delay);");
        _builder.newLine();
      }
    }
    _builder.append("return resultStackFrame;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence failureOccurrence(final ExternalFailureOccurrenceDescription efod, final String roleId, final String signatureId) {
    StringConcatenation _builder = new StringConcatenation();
    FailureType _failureType__ExternalFailureOccurrenceDescription = efod.getFailureType__ExternalFailureOccurrenceDescription();
    String _javaName = this._javaNamesExt.javaName(_failureType__ExternalFailureOccurrenceDescription);
    final String fp = ("failureProbability" + _javaName);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("double ");
    _builder.append(fp, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t    ");
    _builder.append(fp, "\t\t    ");
    _builder.append(" = Double.parseDouble(\"");
    double _failureProbability = efod.getFailureProbability();
    _builder.append(_failureProbability, "\t\t    ");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} catch (NumberFormatException exception) {");
    _builder.newLine();
    _builder.append("\t\t    ");
    _builder.append(fp, "\t\t    ");
    _builder.append(" = 0.0;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("accProbability += ");
    _builder.append(fp, "\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("if ((");
    _builder.append(fp, "\t\t\t\t");
    _builder.append(" > 0.0) && (accProbability >= randValue)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    FailureType _failureType__ExternalFailureOccurrenceDescription_1 = efod.getFailureType__ExternalFailureOccurrenceDescription();
    CharSequence _raiseFailure = this.raiseFailure(_failureType__ExternalFailureOccurrenceDescription_1, roleId, signatureId);
    _builder.append(_raiseFailure, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _raiseFailure(final FailureType ft, final String roleId, final String signatureId) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _raiseFailure(final SoftwareInducedFailureType sift, final String roleId, final String signatureId) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.exceptions.FailureException.raise(");
    _builder.newLine();
    _builder.append("this.getModel(),this.getModel().getFailureStatistics().getExternalSoftwareFailureType(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\"");
    String _id = sift.getId();
    _builder.append(_id, "\t");
    _builder.append("\", \"");
    _builder.append(roleId, "\t");
    _builder.append("\", \"");
    _builder.append(signatureId, "\t");
    _builder.append("\"));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _raiseFailure(final HardwareInducedFailureType hift, final String roleId, final String signatureId) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("    ");
    _builder.append("de.uka.ipd.sdq.simucomframework.exceptions.FailureException.raise(");
    _builder.newLine();
    _builder.append("this.getModel(),this.getModel().getFailureStatistics().getExternalHardwareFailureType(");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("\"");
    ProcessingResourceType _processingResourceType__HardwareInducedFailureType = hift.getProcessingResourceType__HardwareInducedFailureType();
    String _id = _processingResourceType__HardwareInducedFailureType.getId();
    _builder.append(_id, "    ");
    _builder.append("\", \"");
    _builder.append(roleId, "    ");
    _builder.append("\", \"");
    _builder.append(signatureId, "    ");
    _builder.append("\"));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _raiseFailure(final NetworkInducedFailureType nift, final String roleId, final String signatureId) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.exceptions.FailureException.raise(");
    _builder.newLine();
    _builder.append("this.getModel(),this.getModel().getFailureStatistics().getExternalNetworkFailureType(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\"");
    CommunicationLinkResourceType _communicationLinkResourceType__NetworkInducedFailureType = nift.getCommunicationLinkResourceType__NetworkInducedFailureType();
    String _id = _communicationLinkResourceType__NetworkInducedFailureType.getId();
    _builder.append(_id, "\t");
    _builder.append("\", \"");
    _builder.append(roleId, "\t");
    _builder.append("\", \"");
    _builder.append(signatureId, "\t");
    _builder.append("\"));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Inject
  private SimProvidedPortsXpt simProvidedPorts;
  
  public CharSequence dummyComponentPortHelperMethodTM(final OperationInterface oi) {
    return this.simProvidedPorts.dummyComponentPortHelperMethod(oi);
  }
  
  public CharSequence dummyComponentPortHelperMethodTM(final InfrastructureInterface oi) {
    return this.simProvidedPorts.dummyComponentPortHelperMethod(oi);
  }
  
  public CharSequence dummyMethodBodyTM(final OperationSignature os, final org.palladiosimulator.pcm.system.System s, final OperationRequiredRole r) {
    return this.dummyMethodBody(os, s, r);
  }
  
  public CharSequence dummyMethodBodyTM(final InfrastructureSignature os, final org.palladiosimulator.pcm.system.System s, final InfrastructureRequiredRole r) {
    return this.dummyMethodBody(os, s, r);
  }
  
  public CharSequence dummyMethodBody(final Signature is, final org.palladiosimulator.pcm.system.System s, final RequiredRole r) {
    if (is instanceof InfrastructureSignature
         && r instanceof InfrastructureRequiredRole) {
      return _dummyMethodBody((InfrastructureSignature)is, s, (InfrastructureRequiredRole)r);
    } else if (is instanceof OperationSignature
         && r instanceof OperationRequiredRole) {
      return _dummyMethodBody((OperationSignature)is, s, (OperationRequiredRole)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(is, s, r).toString());
    }
  }
  
  public CharSequence raiseFailure(final FailureType hift, final String roleId, final String signatureId) {
    if (hift instanceof HardwareInducedFailureType) {
      return _raiseFailure((HardwareInducedFailureType)hift, roleId, signatureId);
    } else if (hift instanceof NetworkInducedFailureType) {
      return _raiseFailure((NetworkInducedFailureType)hift, roleId, signatureId);
    } else if (hift instanceof SoftwareInducedFailureType) {
      return _raiseFailure((SoftwareInducedFailureType)hift, roleId, signatureId);
    } else if (hift != null) {
      return _raiseFailure(hift, roleId, signatureId);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(hift, roleId, signatureId).toString());
    }
  }
}
