package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim.SimMeasuringPointExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim.SimUsageXpt;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.Workload;

@SuppressWarnings("all")
public class SimUsageFactoryXpt {
  @Inject
  private M2TFileSystemAccess fsa;
  
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;
  
  @Inject
  @Extension
  private PCMext _pCMext;
  
  @Inject
  @Extension
  private SimMeasuringPointExt _simMeasuringPointExt;
  
  @Inject
  @Extension
  private SimUsageXpt _simUsageXpt;
  
  public void usageScenarioFactory(final UsageScenario _this) {
    List<EntryLevelSystemCall> _querySystemCalls = this._pCMext.querySystemCalls(_this);
    final Function1<EntryLevelSystemCall, InterfaceProvidingEntity> _function = new Function1<EntryLevelSystemCall, InterfaceProvidingEntity>() {
      public InterfaceProvidingEntity apply(final EntryLevelSystemCall it) {
        OperationProvidedRole _providedRole_EntryLevelSystemCall = it.getProvidedRole_EntryLevelSystemCall();
        return _providedRole_EntryLevelSystemCall.getProvidingEntity_ProvidedRole();
      }
    };
    List<InterfaceProvidingEntity> _map = ListExtensions.<EntryLevelSystemCall, InterfaceProvidingEntity>map(_querySystemCalls, _function);
    final Function1<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System> _function_1 = new Function1<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System>() {
      public org.palladiosimulator.pcm.system.System apply(final InterfaceProvidingEntity it) {
        return ((org.palladiosimulator.pcm.system.System) it);
      }
    };
    List<org.palladiosimulator.pcm.system.System> _map_1 = ListExtensions.<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System>map(_map, _function_1);
    final List<org.palladiosimulator.pcm.system.System> systemList = this._pCMext.uniqueSystemList(_map_1);
    String _implementationPackage = this._javaNamesExt.implementationPackage(_this);
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_implementationPackage);
    String _plus = (_fqnToDirectoryPath + "/");
    String _javaName = this._javaNamesExt.javaName(_this);
    String _plus_1 = (_plus + _javaName);
    final String fileName = (_plus_1 + "Factory.java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _implementationPackage_1 = this._javaNamesExt.implementationPackage(_this);
    _builder.append(_implementationPackage_1, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _javaName_1 = this._javaNamesExt.javaName(_this);
    String _plus_2 = (_javaName_1 + "Factory");
    _builder.append(_plus_2, "");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("extends ");
    Workload _workload_UsageScenario = _this.getWorkload_UsageScenario();
    CharSequence _usageFactoryBaseClass = this.usageFactoryBaseClass(_workload_UsageScenario);
    _builder.append(_usageFactoryBaseClass, "");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    String _factoryConstructor = this.factoryConstructor(_this);
    _builder.append(_factoryConstructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public de.uka.ipd.sdq.simucomframework.usage.IScenarioRunner createScenarioRunner() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new ");
    String _implementationPackage_2 = this._javaNamesExt.implementationPackage(_this);
    String _plus_3 = (_implementationPackage_2 + ".");
    String _javaName_2 = this._javaNamesExt.javaName(_this);
    String _plus_4 = (_plus_3 + _javaName_2);
    _builder.append(_plus_4, "\t\t");
    _builder.append("(model,");
    {
      boolean _hasElements = false;
      for(final org.palladiosimulator.pcm.system.System system : systemList) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t\t");
        }
        CharSequence _systemVariableParameter = this._simUsageXpt.systemVariableParameter(system);
        _builder.append(_systemVariableParameter, "\t\t");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }
  
  protected CharSequence _usageFactoryBaseClass(final Workload _this) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _usageFactoryBaseClass(final ClosedWorkload _this) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.usage.ClosedWorkloadUserFactory");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _usageFactoryBaseClass(final OpenWorkload _this) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.usage.OpenWorkloadUserFactory");
    _builder.newLine();
    return _builder;
  }
  
  protected String _factoryConstructor(final UsageScenario _this) {
    StringConcatenation _builder = new StringConcatenation();
    List<EntryLevelSystemCall> _querySystemCalls = this._pCMext.querySystemCalls(_this);
    final Function1<EntryLevelSystemCall, InterfaceProvidingEntity> _function = new Function1<EntryLevelSystemCall, InterfaceProvidingEntity>() {
      public InterfaceProvidingEntity apply(final EntryLevelSystemCall it) {
        OperationProvidedRole _providedRole_EntryLevelSystemCall = it.getProvidedRole_EntryLevelSystemCall();
        return _providedRole_EntryLevelSystemCall.getProvidingEntity_ProvidedRole();
      }
    };
    List<InterfaceProvidingEntity> _map = ListExtensions.<EntryLevelSystemCall, InterfaceProvidingEntity>map(_querySystemCalls, _function);
    final Function1<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System> _function_1 = new Function1<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System>() {
      public org.palladiosimulator.pcm.system.System apply(final InterfaceProvidingEntity it) {
        return ((org.palladiosimulator.pcm.system.System) it);
      }
    };
    List<org.palladiosimulator.pcm.system.System> _map_1 = ListExtensions.<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System>map(_map, _function_1);
    final List<org.palladiosimulator.pcm.system.System> systemList = this._pCMext.uniqueSystemList(_map_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private final de.uka.ipd.sdq.simucomframework.model.SimuComModel model;");
    _builder.newLine();
    {
      for(final org.palladiosimulator.pcm.system.System system : systemList) {
        _builder.append("private ");
        String _fqn = this._javaNamesExt.fqn(system);
        _builder.append(_fqn, "");
        _builder.append(" my");
        String _javaName = this._javaNamesExt.javaName(system);
        _builder.append(_javaName, "");
        _builder.append(" = null;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("public ");
    String _javaName_1 = this._javaNamesExt.javaName(_this);
    String _plus = (_javaName_1 + "Factory");
    _builder.append(_plus, "");
    _builder.append("(de.uka.ipd.sdq.simucomframework.model.SimuComModel model, String usageID, ");
    {
      boolean _hasElements = false;
      for(final org.palladiosimulator.pcm.system.System system_1 : systemList) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "");
        }
        CharSequence _systemVariableDecl = this._simUsageXpt.systemVariableDecl(system_1);
        _builder.append(_systemVariableDecl, "");
      }
    }
    _builder.append("){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    Workload _workload_UsageScenario = _this.getWorkload_UsageScenario();
    String _factoryConstructor = this.factoryConstructor(_workload_UsageScenario);
    _builder.append(_factoryConstructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.model = model;");
    _builder.newLine();
    {
      for(final org.palladiosimulator.pcm.system.System system_2 : systemList) {
        _builder.append("\t");
        _builder.append("this.my");
        String _javaName_2 = this._javaNamesExt.javaName(system_2);
        _builder.append(_javaName_2, "\t");
        _builder.append(" = my");
        String _javaName_3 = this._javaNamesExt.javaName(system_2);
        _builder.append(_javaName_3, "\t");
        _builder.append("; ");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  protected String _factoryConstructor(final Workload _this) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder.toString();
  }
  
  protected String _factoryConstructor(final ClosedWorkload _this) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super(model, \"");
    PCMRandomVariable _thinkTime_ClosedWorkload = _this.getThinkTime_ClosedWorkload();
    String _specification = _thinkTime_ClosedWorkload.getSpecification();
    String _specificationString = this._javaNamesExt.specificationString(_specification);
    _builder.append(_specificationString, "");
    _builder.append("\", \"");
    UsageScenario _usageScenario_Workload = _this.getUsageScenario_Workload();
    String _resourceURI = this._simMeasuringPointExt.getResourceURI(_usageScenario_Workload);
    _builder.append(_resourceURI, "");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  protected String _factoryConstructor(final OpenWorkload _this) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super(model, \"");
    UsageScenario _usageScenario_Workload = _this.getUsageScenario_Workload();
    String _resourceURI = this._simMeasuringPointExt.getResourceURI(_usageScenario_Workload);
    _builder.append(_resourceURI, "");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  public CharSequence usageFactoryBaseClass(final Workload _this) {
    if (_this instanceof ClosedWorkload) {
      return _usageFactoryBaseClass((ClosedWorkload)_this);
    } else if (_this instanceof OpenWorkload) {
      return _usageFactoryBaseClass((OpenWorkload)_this);
    } else if (_this != null) {
      return _usageFactoryBaseClass(_this);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(_this).toString());
    }
  }
  
  public String factoryConstructor(final CDOObject _this) {
    if (_this instanceof UsageScenario) {
      return _factoryConstructor((UsageScenario)_this);
    } else if (_this instanceof ClosedWorkload) {
      return _factoryConstructor((ClosedWorkload)_this);
    } else if (_this instanceof OpenWorkload) {
      return _factoryConstructor((OpenWorkload)_this);
    } else if (_this instanceof Workload) {
      return _factoryConstructor((Workload)_this);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(_this).toString());
    }
  }
}
