/**
 */
package de.uka.ipd.sdq.pcm.designdecision;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.palladiosimulator.pcm.core.entity.EntityPackage;

import de.uka.ipd.sdq.featuremodel.featuremodelPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * The DesignDecisions metamodel represents degrees of freedom that can be exploited for optimisation.
 * 
 * The core idea is each degree of freedom can be represented by a DegreeOfFreedom element. Each DegreeOfFreedom has two parts: It links a model element that is the changeable entity in this DegreeOfFreedom, and it specifies a Domain of possible values that the model element can take. 
 * 
 * The actual making of a decision is represented in the Choice element. For a specific candidate architecture, one Choice for each DegreeOfFreedom in the Problem as to be made. The Choice contains a reference to the DegreeOfFreedom that it decides and a reference to a value from the DegreeOfFreedom's Domain that represent the selected value.  See the diagram "Design and Choice" for an overview of DegreeOfFreedom, Domain and Choice.
 * 
 * All of the above mentioned elements are abstract and are subclassed for the different generic degrees of freedom. For example, the degree of freedom of "component allocation" is represented in the AllocationDegree. See the documentation of each subclass of design decision for details. The diagram AssembledComponentDegree visualises the subclassing for the example degree of freedom of "component selection". 
 * 
 * 
 * <!-- end-model-doc -->
 * @see de.uka.ipd.sdq.pcm.designdecision.designdecisionFactory
 * @model kind="package"
 * @generated
 */
public interface designdecisionPackage extends EPackage {
    /**
     * The package name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNAME = "designdecision";

    /**
     * The package namespace URI.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_URI = "http://sdq.ipd.uka.de/DesignDecision/3.0";

    /**
     * The package namespace name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_PREFIX = "designdecision";

    /**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    designdecisionPackage eINSTANCE = de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl.init();

    /**
     * The meta object id for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.DegreeOfFreedomInstanceImpl <em>Degree Of Freedom Instance</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.DegreeOfFreedomInstanceImpl
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getDegreeOfFreedomInstance()
     * @generated
     */
    int DEGREE_OF_FREEDOM_INSTANCE = 2;

    /**
     * The meta object id for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.ChoiceImpl <em>Choice</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.ChoiceImpl
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getChoice()
     * @generated
     */
    int CHOICE = 1;

    /**
     * The feature id for the '<em><b>Is Active</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CHOICE__IS_ACTIVE = 0;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CHOICE__VALUE = 1;

    /**
     * The feature id for the '<em><b>Degree Of Freedom Instance</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CHOICE__DEGREE_OF_FREEDOM_INSTANCE = 2;

    /**
     * The number of structural features of the '<em>Choice</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CHOICE_FEATURE_COUNT = 3;

    /**
     * The meta object id for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.DiscreteRangeChoiceImpl <em>Discrete Range Choice</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.DiscreteRangeChoiceImpl
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getDiscreteRangeChoice()
     * @generated
     */
    int DISCRETE_RANGE_CHOICE = 0;

    /**
     * The feature id for the '<em><b>Is Active</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISCRETE_RANGE_CHOICE__IS_ACTIVE = CHOICE__IS_ACTIVE;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISCRETE_RANGE_CHOICE__VALUE = CHOICE__VALUE;

    /**
     * The feature id for the '<em><b>Degree Of Freedom Instance</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISCRETE_RANGE_CHOICE__DEGREE_OF_FREEDOM_INSTANCE = CHOICE__DEGREE_OF_FREEDOM_INSTANCE;

    /**
     * The feature id for the '<em><b>Chosen Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISCRETE_RANGE_CHOICE__CHOSEN_VALUE = CHOICE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Discrete Range Choice</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISCRETE_RANGE_CHOICE_FEATURE_COUNT = CHOICE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Entity Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEGREE_OF_FREEDOM_INSTANCE__ENTITY_NAME = EntityPackage.NAMED_ELEMENT__ENTITY_NAME;

    /**
     * The feature id for the '<em><b>Primary Changed</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEGREE_OF_FREEDOM_INSTANCE__PRIMARY_CHANGED = EntityPackage.NAMED_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Dof</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEGREE_OF_FREEDOM_INSTANCE__DOF = EntityPackage.NAMED_ELEMENT_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Changeable Elements</b></em>' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEGREE_OF_FREEDOM_INSTANCE__CHANGEABLE_ELEMENTS = EntityPackage.NAMED_ELEMENT_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Degree Of Freedom Instance</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEGREE_OF_FREEDOM_INSTANCE_FEATURE_COUNT = EntityPackage.NAMED_ELEMENT_FEATURE_COUNT + 3;

    /**
     * The meta object id for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.ClassChoiceImpl <em>Class Choice</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.ClassChoiceImpl
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getClassChoice()
     * @generated
     */
    int CLASS_CHOICE = 3;

    /**
     * The feature id for the '<em><b>Is Active</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLASS_CHOICE__IS_ACTIVE = CHOICE__IS_ACTIVE;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLASS_CHOICE__VALUE = CHOICE__VALUE;

    /**
     * The feature id for the '<em><b>Degree Of Freedom Instance</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLASS_CHOICE__DEGREE_OF_FREEDOM_INSTANCE = CHOICE__DEGREE_OF_FREEDOM_INSTANCE;

    /**
     * The feature id for the '<em><b>Chosen Value</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLASS_CHOICE__CHOSEN_VALUE = CHOICE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Class Choice</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLASS_CHOICE_FEATURE_COUNT = CHOICE_FEATURE_COUNT + 1;

    /**
     * The meta object id for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.ContinousRangeChoiceImpl <em>Continous Range Choice</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.ContinousRangeChoiceImpl
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getContinousRangeChoice()
     * @generated
     */
    int CONTINOUS_RANGE_CHOICE = 4;

    /**
     * The feature id for the '<em><b>Is Active</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTINOUS_RANGE_CHOICE__IS_ACTIVE = CHOICE__IS_ACTIVE;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTINOUS_RANGE_CHOICE__VALUE = CHOICE__VALUE;

    /**
     * The feature id for the '<em><b>Degree Of Freedom Instance</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTINOUS_RANGE_CHOICE__DEGREE_OF_FREEDOM_INSTANCE = CHOICE__DEGREE_OF_FREEDOM_INSTANCE;

    /**
     * The feature id for the '<em><b>Chosen Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTINOUS_RANGE_CHOICE__CHOSEN_VALUE = CHOICE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Continous Range Choice</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTINOUS_RANGE_CHOICE_FEATURE_COUNT = CHOICE_FEATURE_COUNT + 1;

    /**
     * The meta object id for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.DecisionSpaceImpl <em>Decision Space</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.DecisionSpaceImpl
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getDecisionSpace()
     * @generated
     */
    int DECISION_SPACE = 5;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DECISION_SPACE__ID = featuremodelPackage.NAMED_ELEMENT__ID;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DECISION_SPACE__NAME = featuremodelPackage.NAMED_ELEMENT__NAME;

    /**
     * The feature id for the '<em><b>Degrees Of Freedom</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DECISION_SPACE__DEGREES_OF_FREEDOM = featuremodelPackage.NAMED_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Decision Space</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DECISION_SPACE_FEATURE_COUNT = featuremodelPackage.NAMED_ELEMENT_FEATURE_COUNT + 1;

    /**
     * The meta object id for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.CandidateImpl <em>Candidate</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.CandidateImpl
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getCandidate()
     * @generated
     */
    int CANDIDATE = 6;

    /**
     * The feature id for the '<em><b>Entity Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CANDIDATE__ENTITY_NAME = EntityPackage.NAMED_ELEMENT__ENTITY_NAME;

    /**
     * The feature id for the '<em><b>Choices</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CANDIDATE__CHOICES = EntityPackage.NAMED_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Quality Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CANDIDATE__QUALITY_PROPERTY = EntityPackage.NAMED_ELEMENT_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Candidate</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CANDIDATE_FEATURE_COUNT = EntityPackage.NAMED_ELEMENT_FEATURE_COUNT + 2;

    /**
     * The meta object id for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.CandidatesImpl <em>Candidates</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.CandidatesImpl
     * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getCandidates()
     * @generated
     */
    int CANDIDATES = 7;

    /**
     * The feature id for the '<em><b>Candidate</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CANDIDATES__CANDIDATE = 0;

    /**
     * The feature id for the '<em><b>Problem</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CANDIDATES__PROBLEM = 1;

    /**
     * The number of structural features of the '<em>Candidates</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CANDIDATES_FEATURE_COUNT = 2;

    /**
     * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice <em>Discrete Range Choice</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Discrete Range Choice</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice
     * @generated
     */
    EClass getDiscreteRangeChoice();

    /**
     * Returns the meta object for the attribute '{@link de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice#getChosenValue <em>Chosen Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Chosen Value</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice#getChosenValue()
     * @see #getDiscreteRangeChoice()
     * @generated
     */
    EAttribute getDiscreteRangeChoice_ChosenValue();

    /**
     * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance <em>Degree Of Freedom Instance</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Degree Of Freedom Instance</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance
     * @generated
     */
    EClass getDegreeOfFreedomInstance();

    /**
     * Returns the meta object for the reference '{@link de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance#getPrimaryChanged <em>Primary Changed</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Primary Changed</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance#getPrimaryChanged()
     * @see #getDegreeOfFreedomInstance()
     * @generated
     */
    EReference getDegreeOfFreedomInstance_PrimaryChanged();

    /**
     * Returns the meta object for the reference '{@link de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance#getDof <em>Dof</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Dof</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance#getDof()
     * @see #getDegreeOfFreedomInstance()
     * @generated
     */
    EReference getDegreeOfFreedomInstance_Dof();

    /**
     * Returns the meta object for the reference list '{@link de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance#getChangeableElements <em>Changeable Elements</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Changeable Elements</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance#getChangeableElements()
     * @see #getDegreeOfFreedomInstance()
     * @generated
     */
    EReference getDegreeOfFreedomInstance_ChangeableElements();

    /**
     * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.designdecision.Choice <em>Choice</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Choice</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Choice
     * @generated
     */
    EClass getChoice();

    /**
     * Returns the meta object for the attribute '{@link de.uka.ipd.sdq.pcm.designdecision.Choice#isActive <em>Is Active</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Is Active</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Choice#isActive()
     * @see #getChoice()
     * @generated
     */
    EAttribute getChoice_IsActive();

    /**
     * Returns the meta object for the attribute '{@link de.uka.ipd.sdq.pcm.designdecision.Choice#getValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Value</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Choice#getValue()
     * @see #getChoice()
     * @generated
     */
    EAttribute getChoice_Value();

    /**
     * Returns the meta object for the reference '{@link de.uka.ipd.sdq.pcm.designdecision.Choice#getDegreeOfFreedomInstance <em>Degree Of Freedom Instance</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Degree Of Freedom Instance</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Choice#getDegreeOfFreedomInstance()
     * @see #getChoice()
     * @generated
     */
    EReference getChoice_DegreeOfFreedomInstance();

    /**
     * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.designdecision.ClassChoice <em>Class Choice</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Class Choice</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.ClassChoice
     * @generated
     */
    EClass getClassChoice();

    /**
     * Returns the meta object for the reference '{@link de.uka.ipd.sdq.pcm.designdecision.ClassChoice#getChosenValue <em>Chosen Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Chosen Value</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.ClassChoice#getChosenValue()
     * @see #getClassChoice()
     * @generated
     */
    EReference getClassChoice_ChosenValue();

    /**
     * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice <em>Continous Range Choice</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Continous Range Choice</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice
     * @generated
     */
    EClass getContinousRangeChoice();

    /**
     * Returns the meta object for the attribute '{@link de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice#getChosenValue <em>Chosen Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Chosen Value</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice#getChosenValue()
     * @see #getContinousRangeChoice()
     * @generated
     */
    EAttribute getContinousRangeChoice_ChosenValue();

    /**
     * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.designdecision.DecisionSpace <em>Decision Space</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Decision Space</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.DecisionSpace
     * @generated
     */
    EClass getDecisionSpace();

    /**
     * Returns the meta object for the containment reference list '{@link de.uka.ipd.sdq.pcm.designdecision.DecisionSpace#getDegreesOfFreedom <em>Degrees Of Freedom</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Degrees Of Freedom</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.DecisionSpace#getDegreesOfFreedom()
     * @see #getDecisionSpace()
     * @generated
     */
    EReference getDecisionSpace_DegreesOfFreedom();

    /**
     * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.designdecision.Candidate <em>Candidate</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Candidate</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Candidate
     * @generated
     */
    EClass getCandidate();

    /**
     * Returns the meta object for the containment reference list '{@link de.uka.ipd.sdq.pcm.designdecision.Candidate#getChoices <em>Choices</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Choices</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Candidate#getChoices()
     * @see #getCandidate()
     * @generated
     */
    EReference getCandidate_Choices();

    /**
     * Returns the meta object for the containment reference list '{@link de.uka.ipd.sdq.pcm.designdecision.Candidate#getQualityProperty <em>Quality Property</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Quality Property</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Candidate#getQualityProperty()
     * @see #getCandidate()
     * @generated
     */
    EReference getCandidate_QualityProperty();

    /**
     * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.designdecision.Candidates <em>Candidates</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Candidates</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Candidates
     * @generated
     */
    EClass getCandidates();

    /**
     * Returns the meta object for the containment reference list '{@link de.uka.ipd.sdq.pcm.designdecision.Candidates#getCandidate <em>Candidate</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Candidate</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Candidates#getCandidate()
     * @see #getCandidates()
     * @generated
     */
    EReference getCandidates_Candidate();

    /**
     * Returns the meta object for the reference '{@link de.uka.ipd.sdq.pcm.designdecision.Candidates#getProblem <em>Problem</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Problem</em>'.
     * @see de.uka.ipd.sdq.pcm.designdecision.Candidates#getProblem()
     * @see #getCandidates()
     * @generated
     */
    EReference getCandidates_Problem();

    /**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
    designdecisionFactory getdesigndecisionFactory();

    /**
     * <!-- begin-user-doc -->
     * Defines literals for the meta objects that represent
     * <ul>
     *   <li>each class,</li>
     *   <li>each feature of each class,</li>
     *   <li>each enum,</li>
     *   <li>and each data type</li>
     * </ul>
     * <!-- end-user-doc -->
     * @generated
     */
    interface Literals {
        /**
         * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.DiscreteRangeChoiceImpl <em>Discrete Range Choice</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.DiscreteRangeChoiceImpl
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getDiscreteRangeChoice()
         * @generated
         */
        EClass DISCRETE_RANGE_CHOICE = eINSTANCE.getDiscreteRangeChoice();

        /**
         * The meta object literal for the '<em><b>Chosen Value</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute DISCRETE_RANGE_CHOICE__CHOSEN_VALUE = eINSTANCE.getDiscreteRangeChoice_ChosenValue();

        /**
         * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.DegreeOfFreedomInstanceImpl <em>Degree Of Freedom Instance</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.DegreeOfFreedomInstanceImpl
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getDegreeOfFreedomInstance()
         * @generated
         */
        EClass DEGREE_OF_FREEDOM_INSTANCE = eINSTANCE.getDegreeOfFreedomInstance();

        /**
         * The meta object literal for the '<em><b>Primary Changed</b></em>' reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference DEGREE_OF_FREEDOM_INSTANCE__PRIMARY_CHANGED = eINSTANCE.getDegreeOfFreedomInstance_PrimaryChanged();

        /**
         * The meta object literal for the '<em><b>Dof</b></em>' reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference DEGREE_OF_FREEDOM_INSTANCE__DOF = eINSTANCE.getDegreeOfFreedomInstance_Dof();

        /**
         * The meta object literal for the '<em><b>Changeable Elements</b></em>' reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference DEGREE_OF_FREEDOM_INSTANCE__CHANGEABLE_ELEMENTS = eINSTANCE
                .getDegreeOfFreedomInstance_ChangeableElements();

        /**
         * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.ChoiceImpl <em>Choice</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.ChoiceImpl
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getChoice()
         * @generated
         */
        EClass CHOICE = eINSTANCE.getChoice();

        /**
         * The meta object literal for the '<em><b>Is Active</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute CHOICE__IS_ACTIVE = eINSTANCE.getChoice_IsActive();

        /**
         * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute CHOICE__VALUE = eINSTANCE.getChoice_Value();

        /**
         * The meta object literal for the '<em><b>Degree Of Freedom Instance</b></em>' reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference CHOICE__DEGREE_OF_FREEDOM_INSTANCE = eINSTANCE.getChoice_DegreeOfFreedomInstance();

        /**
         * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.ClassChoiceImpl <em>Class Choice</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.ClassChoiceImpl
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getClassChoice()
         * @generated
         */
        EClass CLASS_CHOICE = eINSTANCE.getClassChoice();

        /**
         * The meta object literal for the '<em><b>Chosen Value</b></em>' reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference CLASS_CHOICE__CHOSEN_VALUE = eINSTANCE.getClassChoice_ChosenValue();

        /**
         * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.ContinousRangeChoiceImpl <em>Continous Range Choice</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.ContinousRangeChoiceImpl
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getContinousRangeChoice()
         * @generated
         */
        EClass CONTINOUS_RANGE_CHOICE = eINSTANCE.getContinousRangeChoice();

        /**
         * The meta object literal for the '<em><b>Chosen Value</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute CONTINOUS_RANGE_CHOICE__CHOSEN_VALUE = eINSTANCE.getContinousRangeChoice_ChosenValue();

        /**
         * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.DecisionSpaceImpl <em>Decision Space</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.DecisionSpaceImpl
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getDecisionSpace()
         * @generated
         */
        EClass DECISION_SPACE = eINSTANCE.getDecisionSpace();

        /**
         * The meta object literal for the '<em><b>Degrees Of Freedom</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference DECISION_SPACE__DEGREES_OF_FREEDOM = eINSTANCE.getDecisionSpace_DegreesOfFreedom();

        /**
         * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.CandidateImpl <em>Candidate</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.CandidateImpl
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getCandidate()
         * @generated
         */
        EClass CANDIDATE = eINSTANCE.getCandidate();

        /**
         * The meta object literal for the '<em><b>Choices</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference CANDIDATE__CHOICES = eINSTANCE.getCandidate_Choices();

        /**
         * The meta object literal for the '<em><b>Quality Property</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference CANDIDATE__QUALITY_PROPERTY = eINSTANCE.getCandidate_QualityProperty();

        /**
         * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.designdecision.impl.CandidatesImpl <em>Candidates</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.CandidatesImpl
         * @see de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionPackageImpl#getCandidates()
         * @generated
         */
        EClass CANDIDATES = eINSTANCE.getCandidates();

        /**
         * The meta object literal for the '<em><b>Candidate</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference CANDIDATES__CANDIDATE = eINSTANCE.getCandidates_Candidate();

        /**
         * The meta object literal for the '<em><b>Problem</b></em>' reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference CANDIDATES__PROBLEM = eINSTANCE.getCandidates_Problem();

    }

} //designdecisionPackage
