/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.distribution;

import de.uka.ipd.sdq.probfunction.math.apache.distribution.LognormalDistributionImpl;
import org.apache.commons.math.MathException;

public class LognormalDistributionFromMomentsImpl
extends LognormalDistributionImpl {
    private static final long serialVersionUID = -7504569402218262740L;

    public LognormalDistributionFromMomentsImpl(double mean, double variance) throws MathException {
        super(LognormalDistributionFromMomentsImpl.calculateMu(mean, variance), LognormalDistributionFromMomentsImpl.calculateSigma(mean, variance));
    }

    private static double calculateMu(double mean, double var) throws MathException {
        double sigma2 = LognormalDistributionFromMomentsImpl.calculateSigma2(mean, var);
        return Math.log(mean) - sigma2 / 2.0;
    }

    private static double calculateSigma(double mean, double var) throws MathException {
        double sigma2 = LognormalDistributionFromMomentsImpl.calculateSigma2(mean, var);
        return Math.sqrt(sigma2);
    }

    private static double calculateSigma2(double mean, double var) throws MathException {
        if (mean <= 0.0) {
            throw new MathException("Mean has to be positive", new Object[0]);
        }
        if (var <= 0.0) {
            throw new MathException("Variance has to be positive", new Object[0]);
        }
        double o2 = var;
        double u2 = mean * mean;
        return Math.log(o2 / u2 + 1.0);
    }
}

