/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.scheduler.resources.active;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.resources.AbstractSimResource;
import de.uka.ipd.sdq.scheduler.sensors.IActiveResourceStateSensor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractActiveResource
extends AbstractSimResource
implements IActiveResource {
    private static Map<ISchedulableProcess, AbstractActiveResource> currentResourceTable = new ConcurrentHashMap<ISchedulableProcess, AbstractActiveResource>();
    private final List<IActiveResourceStateSensor> observers = new ArrayList<IActiveResourceStateSensor>();

    public AbstractActiveResource(SchedulerModel model, long capacity, String name, String id) {
        super(model, capacity, name, id);
    }

    @Override
    public final void process(ISchedulableProcess process, int resourceServiceID, Map<String, Serializable> parameterMap, double demand) {
        if (!this.getModel().getSimulationControl().isRunning()) {
            return;
        }
        AbstractActiveResource last = AbstractActiveResource.getLastResource(process);
        if (!this.equals(last)) {
            if (last != null) {
                last.dequeue(process);
            }
            this.enqueue(process);
            AbstractActiveResource.setLastResource(process, this);
        }
        if (parameterMap != null && parameterMap.isEmpty()) {
            this.doProcessing(process, resourceServiceID, demand);
        } else {
            this.doProcessing(process, resourceServiceID, parameterMap, demand);
        }
    }

    protected abstract void doProcessing(ISchedulableProcess var1, int var2, double var3);

    protected void doProcessing(ISchedulableProcess process, int resourceServiceID, Map<String, Serializable> parameterMap, double demand) {
        throw new RuntimeException("doProcessing has to be overwritten to allow additional Parameters for active Resources");
    }

    protected abstract void enqueue(ISchedulableProcess var1);

    protected abstract void dequeue(ISchedulableProcess var1);

    private static AbstractActiveResource getLastResource(ISchedulableProcess process) {
        return currentResourceTable.get(process);
    }

    private static void setLastResource(ISchedulableProcess process, AbstractActiveResource resource) {
        if (!currentResourceTable.containsKey(process)) {
            process.addTerminatedObserver(resource);
        }
        currentResourceTable.put(process, resource);
    }

    public static void cleanProcesses() {
        for (ISchedulableProcess process : currentResourceTable.keySet()) {
            if (process.isFinished()) continue;
            try {
                process.activate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        assert (currentResourceTable.size() == 0);
    }

    @Override
    public void notifyTerminated(ISchedulableProcess simProcess) {
        currentResourceTable.remove(simProcess);
    }

    @Override
    public void addObserver(IActiveResourceStateSensor observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(IActiveResourceStateSensor observer) {
        this.observers.remove(observer);
    }

    protected void fireStateChange(long state, int instanceId) {
        for (IActiveResourceStateSensor l : this.observers) {
            l.update(state, instanceId);
        }
    }

    protected void fireDemandCompleted(ISchedulableProcess simProcess) {
        for (IActiveResourceStateSensor l : this.observers) {
            l.demandCompleted(simProcess);
        }
    }
}

