/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.scheduler.resources.active;

import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.entities.SchedulerEntity;
import de.uka.ipd.sdq.scheduler.resources.active.AbstractActiveResource;
import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimEventDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationModel;
import java.util.Hashtable;

public class SimDelayResource
extends AbstractActiveResource {
    private final Hashtable<String, ISchedulableProcess> running_processes = new Hashtable();

    public SimDelayResource(SchedulerModel model, String name, String id) {
        super(model, -1L, name, id);
    }

    @Override
    public void start() {
        this.running_processes.clear();
    }

    @Override
    protected void dequeue(ISchedulableProcess process) {
        if (!this.running_processes.containsKey(process.getId())) {
            return;
        }
        this.running_processes.remove(process.getId());
        this.fireStateChange(this.running_processes.size(), 0);
        this.fireDemandCompleted(process);
        process.activate();
    }

    @Override
    protected void doProcessing(ISchedulableProcess process, int resourceServiceId, double demand) {
        LoggingWrapper.log("Delay: " + process + " demands " + demand);
        if (!this.running_processes.containsKey(process.getId())) {
            this.enqueue(process);
        }
        new DelayEvent(this.getModel()).schedule(process, demand);
        process.passivate();
    }

    @Override
    public double getRemainingDemand(ISchedulableProcess process) {
        throw new UnsupportedOperationException("getRemainingDemand() not yet supported!");
    }

    @Override
    public void updateDemand(ISchedulableProcess process, double demand) {
        throw new UnsupportedOperationException("updateDemand() not yet supported!");
    }

    @Override
    protected void enqueue(ISchedulableProcess process) {
        this.running_processes.put(process.getId(), process);
        this.fireStateChange(this.running_processes.size(), 0);
    }

    @Override
    public void stop() {
        this.running_processes.clear();
    }

    @Override
    public void registerProcess(ISchedulableProcess process) {
    }

    @Override
    public int getQueueLengthFor(SchedulerEntity schedulerEntity, int coreID) {
        return this.running_processes.size();
    }

    private class DelayEvent
    extends AbstractSimEventDelegator<ISchedulableProcess> {
        public DelayEvent(SchedulerModel model) {
            super((ISimulationModel)model, "DelayEvent");
        }

        public void eventRoutine(ISchedulableProcess process) {
            SimDelayResource.this.dequeue(process);
        }
    }
}

