/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.HistogramBucketInformation;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import java.util.HashMap;

public class TimeSpanToHistogramAdapter
extends DataAdapter {
    public static final String HISTOGRAM_WIDTH = "HISTOGRAM_WIDTH";
    private final SensorAndMeasurements samInformation;

    public TimeSpanToHistogramAdapter(SensorAndMeasurements sensorAndMeasurements) {
        this.samInformation = sensorAndMeasurements;
        TimeSpanMeasurement timeSpanMeasurement = null;
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        for (Measurement measurement : this.samInformation.getMeasurements()) {
            timeSpanMeasurement = (TimeSpanMeasurement)measurement;
            minValue = minValue < timeSpanMeasurement.getTimeSpan() ? minValue : timeSpanMeasurement.getTimeSpan();
            double d = maxValue = maxValue > timeSpanMeasurement.getTimeSpan() ? maxValue : timeSpanMeasurement.getTimeSpan();
        }
        if (maxValue - minValue < 1.0) {
            this.adapterProperties.put(HISTOGRAM_WIDTH, (Object)((maxValue - minValue) / 2.0));
        } else {
            double currentNumberOfBuckets = (maxValue - minValue) / 1.0;
            if (currentNumberOfBuckets > 100.0) {
                double widthFactor = currentNumberOfBuckets / 100.0;
                double newNumberOfBuckets = Math.ceil(1.0 * widthFactor);
                this.adapterProperties.put(HISTOGRAM_WIDTH, (Object)newNumberOfBuckets);
            } else {
                this.adapterProperties.put(HISTOGRAM_WIDTH, (Object)1.0);
            }
        }
    }

    public Object getAdaptedObject() {
        double histWidth = (Double)this.adapterProperties.get(HISTOGRAM_WIDTH);
        if (histWidth <= 0.0) {
            throw new RuntimeException("Histogram width must be > 0");
        }
        Histogram histogram = new Histogram(this.samInformation.getSensor().getSensorName(), histWidth);
        HashMap<Integer, Integer> histClasses = new HashMap<Integer, Integer>();
        int maxHistClass = this.assignMeasurementsToClasses(histClasses, histWidth);
        this.storeClassifiedMeasurementsInHistogram(histogram, histClasses, maxHistClass);
        return histogram;
    }

    private void storeClassifiedMeasurementsInHistogram(Histogram histogram, HashMap<Integer, Integer> histClasses, int maxHistClass) {
        double histWidth = histogram.getBucketWidth();
        boolean firstValueFound = false;
        int i = 0;
        while (i <= maxHistClass) {
            Integer histClass = histClasses.get(i);
            if (histClass == null) {
                if (firstValueFound) {
                    histogram.addEntity(new HistogramBucketInformation(0.0, (double)i * histWidth));
                }
            } else {
                firstValueFound = true;
                histogram.addEntity(new HistogramBucketInformation(histClass.doubleValue() / (double)this.samInformation.getMeasurements().size(), (double)i * histWidth));
            }
            ++i;
        }
    }

    private int assignMeasurementsToClasses(HashMap<Integer, Integer> histClasses, double histWidth) {
        int maxHistClass = 0;
        for (Measurement measurement : this.samInformation.getMeasurements()) {
            TimeSpanMeasurement tsm = (TimeSpanMeasurement)measurement;
            int histogramClassNumber = (int)(tsm.getTimeSpan() / histWidth);
            Integer classNumber = histClasses.get(histogramClassNumber);
            if (classNumber == null) {
                histClasses.put(histogramClassNumber, 1);
            } else {
                histClasses.put(histogramClassNumber, classNumber + 1);
            }
            if (maxHistClass >= histogramClassNumber) continue;
            maxHistClass = histogramClassNumber;
        }
        return maxHistClass;
    }
}

