/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.HistogramBucketInformation;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.AbstractJFreeChartWidthViewer;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ExportCSV;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ExportDoublePDF;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IHistSeriesExporter;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IHistogramAccepter;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.LoadCSVHistogram;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;

public class JFreeChartHistogramViewer
extends AbstractJFreeChartWidthViewer
implements IHistogramAccepter,
IHistSeriesExporter {
    public JFreeChartHistogramViewer(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initializeContextMenu(MenuManager menu_manager) {
        super.initializeContextMenu(menu_manager);
        menu_manager.add((IAction)new LoadCSVHistogram(this));
        menu_manager.add((IAction)new ExportCSV(this));
        menu_manager.add((IAction)new ExportDoublePDF(this));
    }

    @Override
    public void addHistogram(Histogram histogram) {
        XYSeries density = new XYSeries((Comparable)((Object)histogram.getTitle()), true, false);
        for (HistogramBucketInformation e : histogram.getBucketInformation()) {
            density.add(e.getValue(), e.getProbability());
        }
        this.densityDataset.addSeries(density);
        this.densityDataset.setAutoWidth(true);
        this.initChart();
        this.redraw();
    }

    @Override
    protected void initChart() {
        this.chart = ChartFactory.createHistogram((String)"Histogram", (String)"Time", (String)"Probability", (IntervalXYDataset)this.densityDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.getRangeAxis().setAutoRange(true);
        plot.setForegroundAlpha(0.8f);
        if (this.densityDataset != null) {
            this.densityDataset.setAutoWidth(true);
        }
    }

    @Override
    protected XYSeries computeDensities(Histogram hist) {
        XYSeries density = new XYSeries((Comparable)((Object)hist.getTitle()), true, false);
        for (HistogramBucketInformation bucketInformation : hist.getBucketInformation()) {
            density.add(bucketInformation.getValue() + hist.getBucketWidth() / 2.0, bucketInformation.getProbability());
        }
        return density;
    }

    @Override
    public XYSeries getSeries() {
        return this.densityDataset.getSeries(0);
    }

    @Override
    public double getHistogramWidth() {
        return this.densityDataset.getIntervalWidth();
    }
}

