/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.TimeSeries;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.TimeSeriesEntity;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.AbstractJFreeChartChart;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.CopyClipboardAsR;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ExportCSV;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ISeriesExporter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class JFreeChartTimeSeriesViewer
extends AbstractJFreeChartChart<TimeSeries>
implements ISeriesExporter {
    DefaultTableXYDataset dataset = new DefaultTableXYDataset();

    public JFreeChartTimeSeriesViewer(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initializeContextMenu(MenuManager menu_manager) {
        super.initializeContextMenu(menu_manager);
        menu_manager.add((IAction)new ExportCSV(this));
        menu_manager.add((IAction)new CopyClipboardAsR(this));
    }

    @Override
    protected void initChart() {
        this.chart = ChartFactory.createScatterPlot((String)"Time Series", (String)"Number of Measurement", (String)"Time", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        NumberAxis yAxis = (NumberAxis)this.chart.getXYPlot().getRangeAxis();
        yAxis.setAutoRangeIncludesZero(false);
        yAxis.setAutoRangeMinimumSize(1.0E-16);
        yAxis.setStandardTickUnits(JFreeChartTimeSeriesViewer.createAdvancedTickUnits());
    }

    private static final TickUnitSource createAdvancedTickUnits() {
        TickUnits tu = (TickUnits)NumberAxis.createStandardTickUnits();
        DecimalFormat df16 = new DecimalFormat("0.0000000000000000");
        DecimalFormat df15 = new DecimalFormat("0.000000000000000");
        DecimalFormat df14 = new DecimalFormat("0.00000000000000");
        DecimalFormat df13 = new DecimalFormat("0.0000000000000");
        DecimalFormat df12 = new DecimalFormat("0.000000000000");
        DecimalFormat df11 = new DecimalFormat("0.00000000000");
        DecimalFormat df10 = new DecimalFormat("0.0000000000");
        DecimalFormat df9 = new DecimalFormat("0.000000000");
        DecimalFormat df8 = new DecimalFormat("0.00000000");
        tu.add((TickUnit)new NumberTickUnit(1.0E-16, (NumberFormat)df16));
        tu.add((TickUnit)new NumberTickUnit(1.0E-15, (NumberFormat)df15));
        tu.add((TickUnit)new NumberTickUnit(1.0E-14, (NumberFormat)df14));
        tu.add((TickUnit)new NumberTickUnit(1.0E-13, (NumberFormat)df13));
        tu.add((TickUnit)new NumberTickUnit(1.0E-12, (NumberFormat)df12));
        tu.add((TickUnit)new NumberTickUnit(1.0E-11, (NumberFormat)df11));
        tu.add((TickUnit)new NumberTickUnit(1.0E-10, (NumberFormat)df10));
        tu.add((TickUnit)new NumberTickUnit(1.0E-9, (NumberFormat)df9));
        tu.add((TickUnit)new NumberTickUnit(1.0E-8, (NumberFormat)df8));
        tu.add((TickUnit)new NumberTickUnit(5.0E-16, (NumberFormat)df16));
        tu.add((TickUnit)new NumberTickUnit(5.0E-15, (NumberFormat)df15));
        tu.add((TickUnit)new NumberTickUnit(5.0E-14, (NumberFormat)df14));
        tu.add((TickUnit)new NumberTickUnit(5.0E-13, (NumberFormat)df13));
        tu.add((TickUnit)new NumberTickUnit(5.0E-12, (NumberFormat)df12));
        tu.add((TickUnit)new NumberTickUnit(5.0E-11, (NumberFormat)df11));
        tu.add((TickUnit)new NumberTickUnit(5.0E-10, (NumberFormat)df10));
        tu.add((TickUnit)new NumberTickUnit(5.0E-9, (NumberFormat)df9));
        tu.add((TickUnit)new NumberTickUnit(5.0E-8, (NumberFormat)df8));
        tu.add((TickUnit)new NumberTickUnit(2.5E-15, (NumberFormat)df16));
        tu.add((TickUnit)new NumberTickUnit(2.5E-14, (NumberFormat)df15));
        tu.add((TickUnit)new NumberTickUnit(2.5E-13, (NumberFormat)df14));
        tu.add((TickUnit)new NumberTickUnit(2.5E-12, (NumberFormat)df13));
        tu.add((TickUnit)new NumberTickUnit(2.5E-11, (NumberFormat)df12));
        tu.add((TickUnit)new NumberTickUnit(2.5E-10, (NumberFormat)df11));
        tu.add((TickUnit)new NumberTickUnit(2.5E-9, (NumberFormat)df10));
        tu.add((TickUnit)new NumberTickUnit(2.5E-8, (NumberFormat)df9));
        return tu;
    }

    @Override
    public void setData(Collection<TimeSeries> data) {
        this.dataset.removeAllSeries();
        for (TimeSeries timeSeries : data) {
            this.dataset.addSeries(this.getSeries(timeSeries));
        }
        this.initChart();
        this.setChart(this.chart);
        this.forceRedraw();
    }

    private XYSeries getSeries(TimeSeries ts) {
        XYSeries series = new XYSeries((Comparable)((Object)ts.getLabel()), true, false);
        for (TimeSeriesEntity te : ts.getValues()) {
            series.add(te.getXValue(), te.getYValue());
        }
        return series;
    }

    @Override
    public XYSeries getSeries() {
        return this.dataset.getSeries(0);
    }
}

