/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.SimuComConfigExtension;
import de.uka.ipd.sdq.simucomframework.SimuComDefaultRandomNumberGenerator;
import de.uka.ipd.sdq.simulation.AbstractSimulationConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.analyzer.workflow.runconfig.ExperimentRunDescriptor;

public class SimuComConfig
extends AbstractSimulationConfig
implements Serializable,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger(SimuComConfig.class);
    private static final long serialVersionUID = -3364130550065874984L;
    public static final String SHOULD_THROW_EXCEPTION = "shouldThrowException";
    public static final String DEFAULT_CONFIDENCE_MODELELEMENT_NAME = "";
    public static final String DEFAULT_CONFIDENCE_MODELELEMENT_URI = "";
    public static final Boolean DEFAULT_USE_CONFIDENCE = false;
    public static final Integer DEFAULT_CONFIDENCE_LEVEL = 95;
    public static final Integer DEFAULT_CONFIDENCE_HALFWIDTH = 10;
    public static final Boolean DEFAULT_CONFIDENCE_USE_AUTOMATIC_BATCHES = true;
    public static final Integer DEFAULT_CONFIDENCE_BATCH_SIZE = 200;
    public static final Integer DEFAULT_CONFIDENCE_MIN_NUMBER_OF_BATCHES = 60;
    public static final String SIMULATE_FAILURES = "simulateFailures";
    public static final String SIMULATE_LINKING_RESOURCES = "simulateLinkingResources";
    public static final String SIMULATE_THROUGHPUT_OF_LINKING_RESOURCES = "simulateThroughputOfLinkingResources";
    public static final String USE_CONFIDENCE = "useConfidenceStopCondition";
    public static final String CONFIDENCE_LEVEL = "confidenceLevel";
    public static final String CONFIDENCE_HALFWIDTH = "confidenceHalfWidth";
    public static final String CONFIDENCE_MODELELEMENT_URI = "confidenceModelElementURI";
    public static final String CONFIDENCE_MODELELEMENT_NAME = "confidenceModelElementName";
    public static final String CONFIDENCE_USE_AUTOMATIC_BATCHES = "confidenceUseAutomaticBatches";
    public static final String CONFIDENCE_BATCH_SIZE = "confidenceBatchSize";
    public static final String CONFIDENCE_MIN_NUMBER_OF_BATCHES = "confidenceMinNumberOfBatches";
    private final HashMap<String, SimuComConfigExtension> simuComConfigExtensions = new HashMap();
    private boolean simulateFailures = false;
    private boolean simulateLinkingResources = false;
    private boolean simulateThroughputOfLinkingResources = true;
    private boolean useConfidence = false;
    private int confidenceLevel = 0;
    private int confidenceHalfWidth = 0;
    private URI confidenceModelElementURI;
    private String confidenceModelElementName;
    private boolean automaticBatches;
    private int batchSize;
    private int minNumberOfBatches;

    public SimuComConfig(Map<String, Object> configuration, boolean debug) {
        super(configuration, debug);
        try {
            if (configuration.containsKey(SIMULATE_FAILURES)) {
                this.simulateFailures = (Boolean)configuration.get(SIMULATE_FAILURES);
            }
            if (configuration.containsKey(SIMULATE_LINKING_RESOURCES)) {
                this.simulateLinkingResources = (Boolean)configuration.get(SIMULATE_LINKING_RESOURCES);
            }
            if (configuration.containsKey(SIMULATE_THROUGHPUT_OF_LINKING_RESOURCES)) {
                this.simulateThroughputOfLinkingResources = (Boolean)configuration.get(SIMULATE_THROUGHPUT_OF_LINKING_RESOURCES);
            }
            if (configuration.containsKey(USE_CONFIDENCE)) {
                this.useConfidence = (Boolean)configuration.get(USE_CONFIDENCE);
                this.confidenceLevel = Integer.valueOf((String)configuration.get(CONFIDENCE_LEVEL));
                this.confidenceHalfWidth = Integer.valueOf((String)configuration.get(CONFIDENCE_HALFWIDTH));
                this.confidenceModelElementName = (String)configuration.get(CONFIDENCE_MODELELEMENT_NAME);
                this.confidenceModelElementURI = URI.createURI((String)((String)configuration.get(CONFIDENCE_MODELELEMENT_URI)));
                this.automaticBatches = (Boolean)configuration.get(CONFIDENCE_USE_AUTOMATIC_BATCHES);
                if (!this.automaticBatches) {
                    this.batchSize = Integer.valueOf((String)configuration.get(CONFIDENCE_BATCH_SIZE));
                    this.minNumberOfBatches = Integer.valueOf((String)configuration.get(CONFIDENCE_MIN_NUMBER_OF_BATCHES));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up properties failed, please check launch config (check all tabs).", e);
        }
    }

    public void addSimuComConfigExtension(String id, SimuComConfigExtension simuComConfigExtension) {
        this.simuComConfigExtensions.put(id, simuComConfigExtension);
    }

    public SimuComConfigExtension getSimuComConfigExtension(String id) {
        return this.simuComConfigExtensions.get(id);
    }

    public boolean getSimulateFailures() {
        return this.simulateFailures;
    }

    public boolean getSimulateLinkingResources() {
        return this.simulateLinkingResources;
    }

    public boolean getSimulateThroughputOfLinkingResources() {
        return this.simulateThroughputOfLinkingResources;
    }

    public boolean isUseConfidence() {
        return this.useConfidence;
    }

    public int getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public int getConfidenceHalfWidth() {
        return this.confidenceHalfWidth;
    }

    public String getConfidenceModelElementName() {
        return this.confidenceModelElementName;
    }

    public URI getConfidenceModelElementURI() {
        return this.confidenceModelElementURI;
    }

    public SimuComConfig copy(ExperimentRunDescriptor descriptor) {
        SimuComConfig result = this.getClone();
        result.descriptor = descriptor;
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        SimuComConfig config = (SimuComConfig)super.clone();
        config.confidenceHalfWidth = this.confidenceHalfWidth;
        config.confidenceLevel = this.confidenceLevel;
        config.confidenceModelElementName = new String(this.confidenceModelElementName);
        config.maxMeasurementsCount = this.maxMeasurementsCount;
        config.nameExperimentRun = new String(this.nameExperimentRun);
        config.recorderName = new String(this.recorderName);
        config.simulateFailures = this.simulateFailures;
        config.simulateLinkingResources = this.simulateLinkingResources;
        config.simulateThroughputOfLinkingResources = this.simulateThroughputOfLinkingResources;
        config.simuTime = this.simuTime;
        config.useConfidence = this.useConfidence;
        config.confidenceModelElementURI = this.confidenceModelElementURI;
        config.descriptor = this.descriptor;
        config.randomNumberGenerator = this.randomNumberGenerator;
        config.randomSeed = this.randomSeed;
        return config;
    }

    public SimuComConfig getClone() {
        SimuComConfig config;
        block2: {
            config = null;
            try {
                config = (SimuComConfig)this.clone();
            }
            catch (CloneNotSupportedException e) {
                if (!LOGGER.isEnabledFor((Priority)Level.FATAL)) break block2;
                LOGGER.fatal((Object)"Could not clone configuration.", (Throwable)e);
            }
        }
        return config;
    }

    public void setAutomaticBatches(boolean automaticBatches) {
        this.automaticBatches = automaticBatches;
    }

    public boolean isAutomaticBatches() {
        return this.automaticBatches;
    }

    public void getBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setMinNumberOfBatches(int minNumberOfBatches) {
        this.minNumberOfBatches = minNumberOfBatches;
    }

    public int getMinNumberOfBatches() {
        return this.minNumberOfBatches;
    }

    public IRandomGenerator getRandomGenerator() {
        if (this.randomNumberGenerator == null) {
            this.randomNumberGenerator = new SimuComDefaultRandomNumberGenerator(this.randomSeed);
        }
        return this.randomNumberGenerator;
    }
}

