/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.calculator;

import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.recorderframework.IRecorder;
import org.palladiosimulator.recorderframework.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.utils.RecorderExtensionHelper;

public class RecorderAttachingCalculatorFactoryDecorator
implements ICalculatorFactory {
    private final SimuComConfig configuration;
    private final String experimentRunName;
    private final ICalculatorFactory decoratedCalculatorFactory;
    private final MeasuringpointFactory measuringpointFactory = MeasuringpointFactory.eINSTANCE;

    public RecorderAttachingCalculatorFactoryDecorator(ICalculatorFactory decoratedCalculatorFactory, SimuComConfig configuration) {
        this.decoratedCalculatorFactory = decoratedCalculatorFactory;
        this.experimentRunName = "Run " + new Date();
        this.configuration = configuration;
    }

    public Calculator buildResponseTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildResponseTimeCalculator(measuringPoint, probes));
    }

    public Calculator buildDemandBasedWaitingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildDemandBasedWaitingTimeCalculator(measuringPoint, probes));
    }

    public Calculator buildWaitingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildWaitingTimeCalculator(measuringPoint, probes));
    }

    public Calculator buildHoldingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildHoldingTimeCalculator(measuringPoint, probes));
    }

    public Calculator buildStateOfActiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildStateOfActiveResourceCalculator(measuringPoint, probe));
    }

    public Calculator buildOverallStateOfActiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildOverallStateOfActiveResourceCalculator(measuringPoint, probe));
    }

    public Calculator buildStateOfPassiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildStateOfPassiveResourceCalculator(measuringPoint, probe));
    }

    public Calculator buildOverallStateOfPassiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildOverallStateOfPassiveResourceCalculator(measuringPoint, probe));
    }

    public Calculator buildResourceDemandCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildResourceDemandCalculator(measuringPoint, probe));
    }

    public Calculator buildExecutionResultCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildExecutionResultCalculator(measuringPoint, probe));
    }

    public Calculator buildNumberOfResourceContainersCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildNumberOfResourceContainersCalculator(measuringPoint, probe));
    }

    private Calculator setupRecorder(Calculator calculator) {
        HashMap<String, Object> recorderConfigurationMap = new HashMap<String, Object>();
        recorderConfigurationMap.put("recorderAcceptedMetric", calculator.getMetricDesciption());
        recorderConfigurationMap.put("measuringPoint", calculator.getMeasuringPoint());
        IRecorder recorder = RecorderExtensionHelper.instantiateRecorderImplementationForRecorder((String)this.configuration.getRecorderName());
        IRecorderConfiguration recorderConfiguration = this.configuration.getRecorderConfigurationFactory().createRecorderConfiguration(recorderConfigurationMap);
        recorder.initialize(recorderConfiguration);
        calculator.addObserver((IMeasurementSourceListener)recorder);
        return calculator;
    }

    public Calculator buildReconfigurationTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildReconfigurationTimeCalculator(measuringPoint, probe));
    }

    public Calculator buildCostOverTimeCalculator(MeasuringPoint measuringPoint, Probe probes) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildCostOverTimeCalculator(measuringPoint, probes));
    }

    public Calculator buildOptimisationTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildOptimisationTimeCalculator(measuringPoint, probe));
    }
}

