/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.sensors.IPassiveResourceSensor;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simucomframework.probes.TakePassiveResourceStateProbe;
import de.uka.ipd.sdq.simucomframework.probes.TakeScheduledResourceDemandProbe;
import de.uka.ipd.sdq.simucomframework.probes.TakeScheduledResourceStateProbe;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.IOverallUtilizationListener;
import de.uka.ipd.sdq.simucomframework.resources.IStateListener;
import de.uka.ipd.sdq.simucomframework.resources.ScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedLinkingResource;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.ResourceURIMeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyPassiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.LinkingResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointFactory;
import org.palladiosimulator.probeframework.ProbeFrameworkContext;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.EventProbe;
import org.palladiosimulator.probeframework.probes.EventProbeList;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.probeframework.probes.TriggeredProbeList;

public final class CalculatorHelper {
    private static final MeasuringpointFactory MEASURINGPOINT_FACTORY = MeasuringpointFactory.eINSTANCE;
    private static final PcmmeasuringpointFactory PCM_MEASURINGPOINT_FACTORY = PcmmeasuringpointFactory.eINSTANCE;
    private static final MeasuringPointRepository MEASURING_POINT_REPOSITORY = MEASURINGPOINT_FACTORY.createMeasuringPointRepository();

    public static void setupWaitingTimeCalculator(IPassiveResource resource, SimuComModel model, MeasuringPoint measuringPoint) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        final List<Probe> startStopProbes = CalculatorHelper.buildStartStopProbes(model);
        ctx.getCalculatorFactory().buildWaitingTimeCalculator(measuringPoint, startStopProbes);
        resource.addObserver(new IPassiveResourceSensor(){

            public void request(ISchedulableProcess process, long num) {
                ((TriggeredProbe)startStopProbes.get(0)).takeMeasurement(new RequestContext(process.getId()));
            }

            public void acquire(ISchedulableProcess process, long num) {
                ((TriggeredProbe)startStopProbes.get(1)).takeMeasurement(new RequestContext(process.getId()));
            }

            public void release(ISchedulableProcess process, long num) {
            }
        });
    }

    public static void setupWaitingTimeCalculator(IPassiveResource resource, SimuComModel model) {
        CalculatorHelper.setupWaitingTimeCalculator(resource, model, CalculatorHelper.createMeasuringPoint(resource));
    }

    public static void setupHoldTimeCalculator(IPassiveResource resource, SimuComModel model, MeasuringPoint measuringPoint) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        final List<Probe> startStopProbes = CalculatorHelper.buildStartStopProbes(model);
        ctx.getCalculatorFactory().buildHoldingTimeCalculator(measuringPoint, startStopProbes);
        resource.addObserver(new IPassiveResourceSensor(resource){
            long capacity;
            {
                this.capacity = iPassiveResource.getCapacity();
            }

            public void request(ISchedulableProcess process, long num) {
            }

            public void acquire(ISchedulableProcess process, long num) {
                if (this.capacity == 1L) {
                    ((TriggeredProbe)startStopProbes.get(0)).takeMeasurement(new RequestContext("1"));
                } else {
                    ((TriggeredProbe)startStopProbes.get(0)).takeMeasurement(new RequestContext(process.getId()));
                }
            }

            public void release(ISchedulableProcess process, long num) {
                if (this.capacity == 1L) {
                    ((TriggeredProbe)startStopProbes.get(1)).takeMeasurement(new RequestContext("1"));
                } else {
                    ((TriggeredProbe)startStopProbes.get(1)).takeMeasurement(new RequestContext(process.getId()));
                }
            }
        });
    }

    public static void setupHoldTimeCalculator(IPassiveResource resource, SimuComModel model) {
        CalculatorHelper.setupHoldTimeCalculator(resource, model, CalculatorHelper.createMeasuringPoint(resource));
    }

    protected static List<Probe> buildStartStopProbes(SimuComModel model) {
        return Arrays.asList(new Probe[]{new TakeCurrentSimulationTimeProbe(model.getSimulationControl()), new TakeCurrentSimulationTimeProbe(model.getSimulationControl())});
    }

    public static void setupDemandCalculator(AbstractScheduledResource scheduledResource, SimuComModel model, MeasuringPoint measuringPoint) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        EventProbeList scheduledResourceProbe = CalculatorHelper.getEventProbeSetWithCurrentTime(MetricDescriptionConstants.RESOURCE_DEMAND_METRIC_TUPLE, model.getSimulationControl(), new TakeScheduledResourceDemandProbe(scheduledResource));
        ctx.getCalculatorFactory().buildResourceDemandCalculator(measuringPoint, (Probe)scheduledResourceProbe);
    }

    public static void setupDemandCalculator(AbstractScheduledResource scheduledResource, SimuComModel model) {
        CalculatorHelper.setupDemandCalculator(scheduledResource, model, CalculatorHelper.createMeasuringPoint(scheduledResource));
    }

    public static void setupActiveResourceStateCalculator(AbstractScheduledResource scheduledResource, SimuComModel model, MeasuringPoint measuringPoint, int replicaID) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        TriggeredProbeList scheduledResourceProbe = CalculatorHelper.getTriggeredProbeSetWithCurrentTime(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE, model.getSimulationControl(), (TriggeredProbe)new TakeScheduledResourceStateProbe(scheduledResource, replicaID));
        ctx.getCalculatorFactory().buildStateOfActiveResourceCalculator(measuringPoint, (Probe)scheduledResourceProbe);
        scheduledResource.addStateListener(new IStateListener((TriggeredProbe)scheduledResourceProbe){
            private final /* synthetic */ TriggeredProbe val$scheduledResourceProbe;
            {
                this.val$scheduledResourceProbe = triggeredProbe;
            }

            @Override
            public void stateChanged(long state, int instanceId) {
                this.val$scheduledResourceProbe.takeMeasurement();
            }
        }, replicaID);
        scheduledResourceProbe.takeMeasurement();
    }

    public static void setupActiveResourceStateCalculator(AbstractScheduledResource scheduledResource, SimuComModel model) {
        int instance = 0;
        while (instance < scheduledResource.getNumberOfInstances()) {
            MeasuringPoint measurementPoint = CalculatorHelper.createMeasuringPoint(scheduledResource, instance);
            CalculatorHelper.setupActiveResourceStateCalculator(scheduledResource, model, measurementPoint, instance);
            ++instance;
        }
    }

    public static void setupOverallUtilizationCalculator(AbstractScheduledResource scheduledResource, SimuComModel model, MeasuringPoint measuringPoint) {
        TriggeredProbeList scheduledResourceProbe = CalculatorHelper.getTriggeredProbeSetWithCurrentTime(MetricDescriptionConstants.OVERALL_STATE_OF_ACTIVE_RESOURCE_METRIC, model.getSimulationControl(), (TriggeredProbe)new TakeScheduledResourceStateProbe(scheduledResource, 0));
        model.getProbeFrameworkContext().getCalculatorFactory().buildOverallStateOfActiveResourceCalculator(measuringPoint, (Probe)scheduledResourceProbe);
        scheduledResource.addOverallUtilizationListener(new IOverallUtilizationListener((TriggeredProbe)scheduledResourceProbe){
            private final /* synthetic */ TriggeredProbe val$scheduledResourceProbe;
            {
                this.val$scheduledResourceProbe = triggeredProbe;
            }

            @Override
            public void utilizationChanged(double resourceDemand, double totalTime) {
                this.val$scheduledResourceProbe.takeMeasurement();
            }
        });
    }

    public static void setupOverallUtilizationCalculator(AbstractScheduledResource resource, SimuComModel model) {
        CalculatorHelper.setupOverallUtilizationCalculator(resource, model, CalculatorHelper.createMeasuringPoint(resource));
    }

    public static void setupPassiveResourceStateCalculator(IPassiveResource resource, SimuComModel model, MeasuringPoint measuringPoint) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        TriggeredProbeList scheduledResourceProbe = CalculatorHelper.getTriggeredProbeSetWithCurrentTime(MetricDescriptionConstants.STATE_OF_PASSIVE_RESOURCE_METRIC_TUPLE, model.getSimulationControl(), (TriggeredProbe)new TakePassiveResourceStateProbe(resource));
        ctx.getCalculatorFactory().buildStateOfPassiveResourceCalculator(measuringPoint, (Probe)scheduledResourceProbe);
        resource.addObserver(new IPassiveResourceSensor((TriggeredProbe)scheduledResourceProbe){
            private final /* synthetic */ TriggeredProbe val$scheduledResourceProbe;
            {
                this.val$scheduledResourceProbe = triggeredProbe;
            }

            public void request(ISchedulableProcess process, long num) {
            }

            public void release(ISchedulableProcess process, long num) {
                this.val$scheduledResourceProbe.takeMeasurement();
            }

            public void acquire(ISchedulableProcess process, long num) {
                this.val$scheduledResourceProbe.takeMeasurement();
            }
        });
        scheduledResourceProbe.takeMeasurement();
    }

    public static void setupPassiveResourceStateCalculator(IPassiveResource resource, SimuComModel model) {
        CalculatorHelper.setupPassiveResourceStateCalculator(resource, model, CalculatorHelper.createMeasuringPoint(resource));
    }

    public static TriggeredProbeList getTriggeredProbeSetWithCurrentTime(MetricSetDescription metricSetDescription, ISimulationControl control, TriggeredProbe additionalProbe) {
        return new TriggeredProbeList((MetricDescription)metricSetDescription, Arrays.asList(new TriggeredProbe[]{new TakeCurrentSimulationTimeProbe(control), additionalProbe}));
    }

    public static EventProbeList getEventProbeSetWithCurrentTime(MetricSetDescription metricSetDescription, ISimulationControl control, EventProbe<?> additionalProbe) {
        return new EventProbeList((MetricDescription)metricSetDescription, additionalProbe, Arrays.asList(new TriggeredProbe[]{new TakeCurrentSimulationTimeProbe(control)}));
    }

    private static MeasuringPoint createMeasuringPoint(IPassiveResource resource) {
        AssemblyPassiveResourceMeasuringPoint mp = PCM_MEASURINGPOINT_FACTORY.createAssemblyPassiveResourceMeasuringPoint();
        mp.setAssembly(resource.getAssemblyContext());
        mp.setPassiveResource(resource.getResource());
        ResourceURIMeasuringPoint measuringPoint = MEASURINGPOINT_FACTORY.createResourceURIMeasuringPoint();
        measuringPoint.setResourceURI(EMFLoadHelper.getResourceURI((EObject)resource.getResource()));
        measuringPoint.setMeasuringPoint(mp.getStringRepresentation());
        CalculatorHelper.putIntoRepository((MeasuringPoint)measuringPoint);
        return measuringPoint;
    }

    private static MeasuringPoint createMeasuringPoint(AbstractScheduledResource scheduledResource) {
        return CalculatorHelper.createMeasuringPoint(scheduledResource, 0);
    }

    private static MeasuringPoint createMeasuringPoint(AbstractScheduledResource scheduledResource, int replicaID) {
        ActiveResourceMeasuringPoint measuringPoint;
        if (scheduledResource instanceof ScheduledResource) {
            measuringPoint = CalculatorHelper.createActiveResourceMeasuringPoint((ScheduledResource)scheduledResource, replicaID);
        } else if (scheduledResource instanceof SimulatedLinkingResource) {
            measuringPoint = CalculatorHelper.createLinkingResourceMeasuringPoint((SimulatedLinkingResource)scheduledResource);
        } else {
            throw new IllegalArgumentException("Unknown variant of AbstractScheduledResource");
        }
        CalculatorHelper.putIntoRepository((MeasuringPoint)measuringPoint);
        return measuringPoint;
    }

    private static ActiveResourceMeasuringPoint createActiveResourceMeasuringPoint(ScheduledResource scheduledResource, int replicaID) {
        ActiveResourceMeasuringPoint measuringPoint = PCM_MEASURINGPOINT_FACTORY.createActiveResourceMeasuringPoint();
        measuringPoint.setActiveResource(scheduledResource.getActiveResource());
        measuringPoint.setReplicaID(replicaID);
        return measuringPoint;
    }

    private static LinkingResourceMeasuringPoint createLinkingResourceMeasuringPoint(SimulatedLinkingResource simulatedLinkingResource) {
        LinkingResourceMeasuringPoint measuringPoint = PCM_MEASURINGPOINT_FACTORY.createLinkingResourceMeasuringPoint();
        measuringPoint.setLinkingResource(simulatedLinkingResource.getLinkingResource());
        return measuringPoint;
    }

    private static void putIntoRepository(MeasuringPoint measuringPoint) {
        MEASURING_POINT_REPOSITORY.getMeasuringPoints().add((Object)measuringPoint);
        measuringPoint.setMeasuringPointRepository(MEASURING_POINT_REPOSITORY);
    }
}

