/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureException;
import de.uka.ipd.sdq.simucomframework.exceptions.ThroughputZeroOrNegativeException;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;

public class SimulatedLinkingResource
extends AbstractScheduledResource {
    private static final Logger LOGGER = Logger.getLogger((String)SimulatedLinkingResource.class.getName());
    private static long resourceId = 1L;
    private final LinkingResource linkingResource;
    private final String throughput;
    private final String latencySpec;
    private final boolean canFail;
    private final double failureProbability;
    private boolean utilizationSet = false;

    public SimulatedLinkingResource(LinkingResource linkingResource, SimuComModel simuComModel, String resourceContainerID) {
        super(simuComModel, linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification().getEntityName(), resourceContainerID, linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification().getId(), String.valueOf(linkingResource.getEntityName()) + " [" + linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification().getEntityName() + "] <" + linkingResource.getId() + ">", "FCFS", 1, false);
        this.linkingResource = linkingResource;
        this.latencySpec = this.linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getLatency_CommunicationLinkResourceSpecification().getSpecification();
        this.throughput = this.linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getThroughput_CommunicationLinkResourceSpecification().getSpecification();
        this.failureProbability = this.linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getFailureProbability();
        this.canFail = simuComModel.getConfiguration().getSimulateFailures() && this.failureProbability > 0.0;
    }

    public String getId() {
        return this.linkingResource.getId();
    }

    @Override
    protected IActiveResource createActiveResource(SimuComModel simuComModel) {
        IActiveResource aResource = this.getModel().getSchedulingFactory().createSimFCFSResource("FCFS".toString(), SimulatedLinkingResource.getNextResourceId());
        return aResource;
    }

    @Override
    protected double calculateDemand(double demand) {
        double calculatedThroughput = NumberConverter.toDouble((Object)StackContext.evaluateStatic((String)this.throughput));
        if (calculatedThroughput <= 0.0) {
            throw new ThroughputZeroOrNegativeException("Throughput at resource " + this.getName() + " was less or equal zero");
        }
        double result = NumberConverter.toDouble((Object)StackContext.evaluateStatic((String)this.latencySpec)) + demand / calculatedThroughput;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("A network load of " + result + " has been determined."));
        }
        return result;
    }

    @Override
    public void consumeResource(SimuComSimProcess process, int resourceServiceID, Map<String, Serializable> parameterMap, double abstractDemand) {
        double concreteDemand;
        if (this.canFail && Math.random() < this.failureProbability) {
            FailureException.raise(this.getModel(), this.getModel().getFailureStatistics().getInternalNetworkFailureType(this.linkingResource.getId(), this.getResourceTypeId()));
        }
        if ((concreteDemand = this.calculateDemand(abstractDemand)) <= 0.0) {
            return;
        }
        this.fireDemand(concreteDemand);
        this.getUnderlyingResource().process((ISchedulableProcess)process, resourceServiceID, parameterMap, concreteDemand);
    }

    @Override
    public double getRemainingDemandForProcess(SimuComSimProcess thread) {
        return this.getUnderlyingResource().getRemainingDemand((ISchedulableProcess)thread);
    }

    @Override
    public void updateDemand(SimuComSimProcess thread, double demand) {
        this.getUnderlyingResource().updateDemand((ISchedulableProcess)thread, demand);
    }

    @Override
    public IActiveResource getScheduledResource() {
        return this.getUnderlyingResource();
    }

    @Override
    public void activateResource() {
        this.getUnderlyingResource().start();
    }

    @Override
    public void deactivateResource() {
        if (!this.utilizationSet) {
            this.utilizationSet = true;
        }
        this.getUnderlyingResource().stop();
    }

    public static String getNextResourceId() {
        return "NETWORK_" + Long.toString(resourceId++);
    }

    public LinkingResource getLinkingResource() {
        return this.linkingResource;
    }
}

