/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.ResourceContainerIsMissingRequiredResourceType;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.CalculatorHelper;
import de.uka.ipd.sdq.simucomframework.resources.ScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.SimSimpleFairPassiveResource;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;

public class SimulatedResourceContainer
extends AbstractSimulatedResourceContainer {
    private final List<SimulatedResourceContainer> nestedResourceContainers;
    private SimulatedResourceContainer parentResourceContainer;

    public SimulatedResourceContainer(SimuComModel myModel, String containerID) {
        this(myModel, containerID, new LinkedList<SimulatedResourceContainer>(), null);
    }

    protected SimulatedResourceContainer(SimuComModel myModel, String containerID, List<SimulatedResourceContainer> nestedContainer, SimulatedResourceContainer parent) {
        super(myModel, containerID);
        this.nestedResourceContainers = nestedContainer;
        this.parentResourceContainer = parent;
    }

    public IPassiveResource createPassiveResource(PassiveResource resource, AssemblyContext assemblyContext, long capacity) {
        IPassiveResource newPassiveResource = this.getSimplePassiveResource(resource, assemblyContext, this.myModel, capacity);
        CalculatorHelper.setupPassiveResourceStateCalculator(newPassiveResource, this.myModel);
        CalculatorHelper.setupWaitingTimeCalculator(newPassiveResource, this.myModel);
        CalculatorHelper.setupHoldTimeCalculator(newPassiveResource, this.myModel);
        return newPassiveResource;
    }

    public List<SimulatedResourceContainer> getNestedResourceContainers() {
        return this.nestedResourceContainers;
    }

    public SimulatedResourceContainer getParentResourceContainer() {
        return this.parentResourceContainer;
    }

    public void addNestedResourceContainer(String nestedResourceContainerId) {
        AbstractSimulatedResourceContainer resourceContainer = this.myModel.getResourceRegistry().getResourceContainer(nestedResourceContainerId);
        if (resourceContainer == null || !(resourceContainer instanceof SimulatedResourceContainer)) {
            throw new RuntimeException("Could not initialize resouce container " + this.myContainerID + ": Nested resource container " + nestedResourceContainerId + " is not available.");
        }
        this.nestedResourceContainers.add((SimulatedResourceContainer)resourceContainer);
    }

    public void setParentResourceContainer(String parentResourceContainerId) {
        AbstractSimulatedResourceContainer resourceContainer = this.myModel.getResourceRegistry().getResourceContainer(parentResourceContainerId);
        if (resourceContainer == null || !(resourceContainer instanceof SimulatedResourceContainer)) {
            throw new RuntimeException("Could not initialize resouce container " + this.myContainerID + ": Parent resource container " + parentResourceContainerId + " is not available.");
        }
        this.parentResourceContainer = (SimulatedResourceContainer)resourceContainer;
    }

    public void addActiveResource(ProcessingResourceSpecification activeResource, String[] providedInterfaceIds, String resourceContainerID, String schedulingStrategyID) {
        ScheduledResource r = this.addActiveResourceWithoutCalculators(activeResource, providedInterfaceIds, resourceContainerID, schedulingStrategyID);
        CalculatorHelper.setupDemandCalculator(r, this.myModel);
        if (schedulingStrategyID.equals("PROCESSOR_SHARING")) {
            if (r.getNumberOfInstances() == 1) {
                CalculatorHelper.setupActiveResourceStateCalculator(r, this.myModel);
            } else {
                CalculatorHelper.setupOverallUtilizationCalculator(r, this.myModel);
            }
        } else if (schedulingStrategyID.equals("DELAY") || schedulingStrategyID.equals("FCFS")) {
            assert (r.getNumberOfInstances() == 1) : "DELAY and FCFS resources are expected to have exactly one core";
            CalculatorHelper.setupActiveResourceStateCalculator(r, this.myModel);
        } else {
            CalculatorHelper.setupOverallUtilizationCalculator(r, this.myModel);
        }
    }

    public ScheduledResource addActiveResourceWithoutCalculators(ProcessingResourceSpecification activeResource, String[] providedInterfaceIds, String resourceContainerID, String schedulingStrategyID) {
        ScheduledResource scheduledResource = new ScheduledResource(activeResource, this.myModel, resourceContainerID, schedulingStrategyID);
        String resourceType = activeResource.getActiveResourceType_ActiveResourceSpecification().getId();
        this.activeResources.put(resourceType, scheduledResource);
        if (providedInterfaceIds != null) {
            String[] stringArray = providedInterfaceIds;
            int n = providedInterfaceIds.length;
            int n2 = 0;
            while (n2 < n) {
                String providedInterfaceId = stringArray[n2];
                this.activeResourceProvidedInterfaces.put(providedInterfaceId, resourceType);
                ++n2;
            }
        }
        return scheduledResource;
    }

    private IPassiveResource getSimplePassiveResource(PassiveResource resource, AssemblyContext assemblyContext, SimuComModel simuComModel, long capacity) {
        return new SimSimpleFairPassiveResource(resource, assemblyContext, simuComModel, capacity);
    }

    @Override
    public void loadActiveResource(SimuComSimProcess requestingProcess, String typeID, double demand) {
        try {
            super.loadActiveResource(requestingProcess, typeID, demand);
        }
        catch (ResourceContainerIsMissingRequiredResourceType e) {
            if (this.parentResourceContainer == null) {
                if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                    LOGGER.error((Object)("Resource container is missing a resource which was attempted to be loaded by a component and has no parent Resource Container to look in. ID of resource type was: " + typeID));
                }
                throw new ResourceContainerIsMissingRequiredResourceType(typeID);
            }
            this.parentResourceContainer.loadActiveResource(requestingProcess, typeID, demand);
        }
    }

    @Override
    public void loadActiveResource(SimuComSimProcess requestingProcess, String providedInterfaceID, int resourceServiceID, double demand) {
        try {
            super.loadActiveResource(requestingProcess, providedInterfaceID, resourceServiceID, demand);
        }
        catch (ResourceContainerIsMissingRequiredResourceType e) {
            if (this.parentResourceContainer == null) {
                if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                    LOGGER.error((Object)("Resource container is missing a resource which was attempted to be loaded by a component and has no parent Resource Container to look in. ID of resource type was: " + e.getTypeID()));
                }
                throw new ResourceContainerIsMissingRequiredResourceType(e.getTypeID());
            }
            this.parentResourceContainer.loadActiveResource(requestingProcess, providedInterfaceID, resourceServiceID, demand);
        }
    }

    @Override
    public void loadActiveResource(SimuComSimProcess requestingProcess, String providedInterfaceID, int resourceServiceID, Map<String, Serializable> parameterMap, double demand) {
        try {
            super.loadActiveResource(requestingProcess, providedInterfaceID, resourceServiceID, parameterMap, demand);
        }
        catch (ResourceContainerIsMissingRequiredResourceType e) {
            if (this.parentResourceContainer == null) {
                if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                    LOGGER.error((Object)("Resource container is missing a resource which was attempted to be loaded by a component and has no parent Resource Container to look in. ID of resource type was: " + e.getTypeID()));
                }
                throw new ResourceContainerIsMissingRequiredResourceType(e.getTypeID());
            }
            this.parentResourceContainer.loadActiveResource(requestingProcess, providedInterfaceID, resourceServiceID, parameterMap, demand);
        }
    }
}

