/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.simucomframework.usage.ClosedWorkloadUser;
import de.uka.ipd.sdq.simucomframework.usage.IUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver;
import java.util.LinkedList;
import java.util.Queue;

public class ClosedWorkload
implements IWorkloadDriver {
    private final int population;
    private final IUserFactory userFactory;
    private final Queue<ClosedWorkloadUser> users;

    public ClosedWorkload(IUserFactory userFactory, int population) {
        this.userFactory = userFactory;
        this.population = population;
        this.users = new LinkedList<ClosedWorkloadUser>();
    }

    @Override
    public void run() {
        this.startUsers(this.population);
    }

    @Override
    public IUserFactory getUserFactory() {
        return this.userFactory;
    }

    public void setPopulation(int newPopulation) {
        if (this.users.size() > newPopulation) {
            this.stopUsers(this.users.size() - newPopulation);
        } else if (this.users.size() < newPopulation) {
            this.startUsers(newPopulation - this.users.size());
        }
    }

    private void stopUsers(int count) {
        int i = 0;
        while (i < count) {
            ClosedWorkloadUser user = this.users.poll();
            user.requestStop();
            ++i;
        }
    }

    private void startUsers(int count) {
        int i = 0;
        while (i < count) {
            ClosedWorkloadUser user = (ClosedWorkloadUser)this.userFactory.createUser();
            user.startUserLife();
            this.users.add(user);
            ++i;
        }
    }
}

