/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.usage.IUser;
import de.uka.ipd.sdq.simucomframework.usage.IUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class OpenWorkload
extends SimuComSimProcess
implements IWorkloadDriver {
    private String interArrivalTime;
    private final IUserFactory userFactory;
    private static final Logger LOGGER = Logger.getLogger((String)OpenWorkload.class.getName());

    public OpenWorkload(SimuComModel model, IUserFactory userFactory, String interArrivalTime) {
        super(model, "OpenWorkloadUserMaturationChamber");
        this.interArrivalTime = interArrivalTime;
        this.userFactory = userFactory;
    }

    @Override
    public void run() {
        this.scheduleAt(0.0);
    }

    @Override
    protected void internalLifeCycle() {
        while (this.getModel().getSimulationControl().isRunning()) {
            try {
                this.generateUser();
                this.waitForNextUser();
                if (!this.getModel().getConfiguration().getSimulateFailures()) continue;
                this.getModel().getFailureStatistics().increaseRunCount();
                this.getModel().getFailureStatistics().printRunCount(LOGGER, this.getModel().getSimulationControl().getCurrentSimulationTime());
            }
            catch (OutOfMemoryError e) {
                if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                    LOGGER.info((Object)"Stopping simulation run due to memory constraints.");
                }
                this.getModel().getSimulationControl().stop();
            }
        }
        if (this.getModel().getConfiguration().getSimulateFailures()) {
            this.getModel().getFailureStatistics().printHandledFailuresStatistics(LOGGER, this.getModel().getSimulationControl().getCurrentSimulationTime());
        }
    }

    private void waitForNextUser() {
        double interArrivalTimeSample = (Double)Context.evaluateStatic((String)this.interArrivalTime, Double.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Waiting for " + interArrivalTimeSample + " before spawing the next user"));
        }
        this.hold(interArrivalTimeSample);
    }

    private IUser generateUser() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Spawning New User...");
        }
        IUser user = this.userFactory.createUser();
        user.startUserLife();
        return user;
    }

    @Override
    public IUserFactory getUserFactory() {
        return this.userFactory;
    }

    public void setInterarrivalTime(String newInterarrivalTime) {
        this.interArrivalTime = newInterarrivalTime;
    }
}

