/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simulation.abstractsimengine.processes;

import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimProcessDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcess;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcessListener;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.ISimProcessStrategy;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.ProcessState;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class SimulatedProcess
implements ISimProcess {
    public static final Logger LOGGER = Logger.getLogger(SimulatedProcess.class);
    public ProcessState myProcessState = ProcessState.READY;
    protected final List<ISimProcessListener> listeners;
    public final ISimProcessStrategy processStrategy;

    public SimulatedProcess(ISimProcessStrategy processStrategy) {
        this.processStrategy = processStrategy;
        this.listeners = new ArrayList<ISimProcessListener>();
    }

    public void startProcess(ISimProcessStrategy processStrategy) {
        Runnable myRunnable = new Runnable(){

            @Override
            public void run() {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Starting sim process [ID: " + SimulatedProcess.this.getAbstractProcess().getId() + "]"));
                }
                SimulatedProcess.this.actions();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Sim process ended [ID: " + SimulatedProcess.this.getAbstractProcess().getId() + "]"));
                }
            }
        };
        processStrategy.startProcess(myRunnable);
    }

    public void actions() {
        this.myProcessState = ProcessState.RUNNING;
        this.suspend();
        this.getAbstractProcess().lifeCycle();
        this.notifyListeners(this, this.myProcessState, ProcessState.TERMINATED);
        this.myProcessState = ProcessState.TERMINATED;
        this.processStrategy.finishProcess();
    }

    @Override
    public boolean isTerminated() {
        return this.myProcessState == ProcessState.TERMINATED;
    }

    @Override
    public void passivate() {
        this.suspend();
    }

    protected abstract AbstractSimProcessDelegator getAbstractProcess();

    public void suspend() {
        if (this.myProcessState != ProcessState.RUNNING) {
            throw new IllegalStateException("Tried to suspend non-running process [" + this.getAbstractProcess().getId() + "]");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Suspending thread [" + this.getAbstractProcess().getId() + "]"));
        }
        this.notifyListeners(this, ProcessState.RUNNING, ProcessState.SUSPENDED);
        this.myProcessState = ProcessState.SUSPENDED;
        this.processStrategy.suspendProcess();
        this.notifyListeners(this, ProcessState.SUSPENDED, ProcessState.RUNNING);
    }

    protected void resume() {
        if (this.myProcessState != ProcessState.SUSPENDED) {
            throw new IllegalStateException("Tried to resume thread which was not suspended [" + this.getAbstractProcess().getId() + "]");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Resuming thread [" + this.getAbstractProcess().getId() + "]"));
        }
        this.myProcessState = ProcessState.RUNNING;
        this.processStrategy.resumeProcess();
    }

    @Override
    public void addProcessListener(ISimProcessListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeProcessListener(ISimProcessListener l) {
        this.listeners.remove(l);
    }

    protected void notifyListeners(ISimProcess process, ProcessState oldState, ProcessState newState) {
        LinkedList<ISimProcessListener> listCopy = new LinkedList<ISimProcessListener>(this.listeners);
        for (ISimProcessListener l : listCopy) {
            if (oldState == ProcessState.RUNNING && newState == ProcessState.SUSPENDED) {
                l.notifySuspending(process);
                continue;
            }
            if (oldState == ProcessState.SUSPENDED && newState == ProcessState.RUNNING) {
                l.notifyResuming(process);
                continue;
            }
            if (newState == ProcessState.TERMINATED) {
                l.notifyTerminated(process);
                continue;
            }
            throw new RuntimeException("Unknown state transition triggered. From " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
        }
    }
}

