/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics;

import de.uka.ipd.sdq.statistics.ABatchAlgorithm;
import de.uka.ipd.sdq.statistics.Batch;
import de.uka.ipd.sdq.statistics.independence.IIndependenceTest;
import de.uka.ipd.sdq.statistics.independence.RunUpTest;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class PhiMixingBatchAlgorithm
extends ABatchAlgorithm {
    private static final Logger LOGGER = Logger.getLogger((String)"de.uka.ipd.sdq.statistics.PhiMixingBatchAlgorithm.log");
    private final IIndependenceTest independenceTest;
    private QuasiIndependentSampleSequence qiSamples;
    private int k = 0;
    private int demandedQiSamples;
    private int totalSamples;
    private State state;

    public PhiMixingBatchAlgorithm() {
        this(new RunUpTest());
    }

    public PhiMixingBatchAlgorithm(IIndependenceTest test) {
        this.independenceTest = test;
        this.initialize();
    }

    private void initialize() {
        this.qiSamples = new QuasiIndependentSampleSequence();
        this.state = new Iteration0();
    }

    @Override
    public void offerSample(double value) {
        this.state.offerSample(value);
    }

    private void setState(State state) {
        this.state = state;
    }

    private void mergeAdjacentBatches(List<Batch> batches) {
        assert (batches.size() % 2 == 0);
        int i = 0;
        while (i < batches.size() / 2) {
            Double mergedSum = batches.get(2 * i).getSum() + batches.get(2 * i + 1).getSum();
            Integer mergedCount = batches.get(2 * i).getSize() + batches.get(2 * i + 1).getSize();
            batches.set(i, new Batch(mergedSum, mergedCount));
            ++i;
        }
        batches.subList(batches.size() / 2, batches.size()).clear();
    }

    private void computeBatches(int number) {
        assert (this.qiSamples.size() % number == 0);
        int batchSize = this.qiSamples.size() / number;
        int i = 0;
        while (i < number) {
            double batchSum = 0.0;
            int batchCount = 0;
            int j = 0;
            while (j < batchSize) {
                int idx = i * batchSize + j;
                batchSum += this.qiSamples.get(idx);
                ++batchCount;
                ++j;
            }
            this.batches.add(new Batch(batchSum, batchCount));
            ++i;
        }
    }

    private class IncreaseBatches
    extends State {
        private int demandedSamples;

        private IncreaseBatches() {
        }

        @Override
        public void start() {
            int batchSize;
            LOGGER.info((Object)"Start increasing batches.");
            if (PhiMixingBatchAlgorithm.this.batches.size() == 30) {
                PhiMixingBatchAlgorithm.this.mergeAdjacentBatches(PhiMixingBatchAlgorithm.this.batches);
            }
            PhiMixingBatchAlgorithm.this.batches.add(new Batch());
            this.demandedSamples = batchSize = ((Batch)PhiMixingBatchAlgorithm.this.batches.get(0)).getSize();
        }

        @Override
        public void offerSample(double sample) {
            super.offerSample(sample);
            ((Batch)PhiMixingBatchAlgorithm.this.batches.get(PhiMixingBatchAlgorithm.this.batches.size() - 1)).addSample(sample);
            --this.demandedSamples;
            if (this.demandedSamples == 0) {
                this.changeState(new IncreaseBatches());
            }
        }

        @Override
        public void end() {
            LOGGER.info((Object)"Stop increasing batches.");
            super.logBatchStatus();
        }
    }

    private class Iteration0
    extends State {
        private Iteration0() {
        }

        @Override
        public void start() {
            PhiMixingBatchAlgorithm.this.k = 0;
            LOGGER.info((Object)"Start of iteration 0.");
            PhiMixingBatchAlgorithm phiMixingBatchAlgorithm = PhiMixingBatchAlgorithm.this;
            phiMixingBatchAlgorithm.demandedQiSamples = phiMixingBatchAlgorithm.demandedQiSamples + 4000;
        }

        @Override
        public void offerSample(double sample) {
            super.offerSample(sample);
            PhiMixingBatchAlgorithm.this.qiSamples.offerSample(sample);
            if (PhiMixingBatchAlgorithm.this.demandedQiSamples == 0) {
                super.independenceConditionalStateChange(1, new IncreaseBatches(), new Iteration1a());
            }
        }

        @Override
        public void end() {
            LOGGER.info((Object)"End of iteration 0.");
            super.logBatchStatus();
        }
    }

    private class Iteration1a
    extends State {
        private Iteration1a() {
        }

        @Override
        public void start() {
            LOGGER.info((Object)"Start of iteration 1a");
            PhiMixingBatchAlgorithm.this.k = 1;
            PhiMixingBatchAlgorithm phiMixingBatchAlgorithm = PhiMixingBatchAlgorithm.this;
            phiMixingBatchAlgorithm.demandedQiSamples = phiMixingBatchAlgorithm.demandedQiSamples + 4000;
        }

        @Override
        public void offerSample(double sample) {
            super.offerSample(sample);
            PhiMixingBatchAlgorithm.this.qiSamples.offerSample(sample);
            if (PhiMixingBatchAlgorithm.this.demandedQiSamples == 0) {
                super.independenceConditionalStateChange(2, new IncreaseBatches(), new Iteration1b());
            }
        }

        @Override
        public void end() {
            LOGGER.info((Object)"End of iteration 1a.");
            super.logBatchStatus();
        }
    }

    private class Iteration1b
    extends State {
        private Iteration1b() {
        }

        @Override
        public void start() {
            LOGGER.info((Object)"Start of iteration 1b");
            PhiMixingBatchAlgorithm phiMixingBatchAlgorithm = PhiMixingBatchAlgorithm.this;
            phiMixingBatchAlgorithm.demandedQiSamples = phiMixingBatchAlgorithm.demandedQiSamples + 4000;
        }

        @Override
        public void offerSample(double sample) {
            super.offerSample(sample);
            PhiMixingBatchAlgorithm.this.qiSamples.offerSample(sample);
            if (PhiMixingBatchAlgorithm.this.demandedQiSamples == 0) {
                super.independenceConditionalStateChange(3, new IncreaseBatches(), new IterationKa());
            }
        }

        @Override
        public void end() {
            LOGGER.info((Object)"End of iteration 1b");
            super.logBatchStatus();
        }
    }

    private class IterationKa
    extends State {
        private IterationKa() {
        }

        @Override
        public void start() {
            PhiMixingBatchAlgorithm phiMixingBatchAlgorithm = PhiMixingBatchAlgorithm.this;
            phiMixingBatchAlgorithm.k = phiMixingBatchAlgorithm.k + 1;
            LOGGER.info((Object)("Start of iteration " + PhiMixingBatchAlgorithm.this.k + "a."));
            if (PhiMixingBatchAlgorithm.this.batches.isEmpty()) {
                PhiMixingBatchAlgorithm.this.computeBatches(3);
            } else assert (PhiMixingBatchAlgorithm.this.batches.size() == 3);
            PhiMixingBatchAlgorithm.this.batches.add(new Batch());
            PhiMixingBatchAlgorithm.this.qiSamples.discardAndRearrange();
            PhiMixingBatchAlgorithm.this.demandedQiSamples = 2000;
            PhiMixingBatchAlgorithm.this.qiSamples.setLag((int)Math.pow(2.0, PhiMixingBatchAlgorithm.this.k - 1));
        }

        @Override
        public void offerSample(double sample) {
            super.offerSample(sample);
            PhiMixingBatchAlgorithm.this.qiSamples.offerSample(sample);
            ((Batch)PhiMixingBatchAlgorithm.this.batches.get(PhiMixingBatchAlgorithm.this.batches.size() - 1)).addSample(sample);
            if (PhiMixingBatchAlgorithm.this.demandedQiSamples == 0) {
                super.independenceConditionalStateChange(2, new IncreaseBatches(), new IterationKb());
            }
        }

        @Override
        public void end() {
            LOGGER.info((Object)("End of iteration " + PhiMixingBatchAlgorithm.this.k + "a."));
            super.logBatchStatus();
        }
    }

    private class IterationKb
    extends State {
        private IterationKb() {
        }

        @Override
        public void start() {
            LOGGER.info((Object)("Start of iteration " + PhiMixingBatchAlgorithm.this.k + "b."));
            assert (PhiMixingBatchAlgorithm.this.batches.size() == 4);
            PhiMixingBatchAlgorithm.this.mergeAdjacentBatches(PhiMixingBatchAlgorithm.this.batches);
            PhiMixingBatchAlgorithm.this.demandedQiSamples = 4000;
            PhiMixingBatchAlgorithm.this.qiSamples.setLag((int)Math.pow(2.0, PhiMixingBatchAlgorithm.this.k - 1));
            PhiMixingBatchAlgorithm.this.batches.add(new Batch());
        }

        @Override
        public void offerSample(double sample) {
            super.offerSample(sample);
            PhiMixingBatchAlgorithm.this.qiSamples.offerSample(sample);
            ((Batch)PhiMixingBatchAlgorithm.this.batches.get(PhiMixingBatchAlgorithm.this.batches.size() - 1)).addSample(sample);
            if (PhiMixingBatchAlgorithm.this.demandedQiSamples == 0) {
                super.independenceConditionalStateChange(3, new IncreaseBatches(), new IterationKa());
            }
        }

        @Override
        public void end() {
            LOGGER.info((Object)("End of iteration " + PhiMixingBatchAlgorithm.this.k + "b."));
            super.logBatchStatus();
        }
    }

    private class QuasiIndependentSampleSequence {
        private final List<Double> buffer = new LinkedList<Double>();
        private int lag = 1;
        private int ignoredSamples;

        public void setLag(int lag) {
            assert (lag >= 1);
            this.lag = lag;
        }

        public void offerSample(double sample) {
            if (this.ignoredSamples == this.lag - 1) {
                this.buffer.add(sample);
                PhiMixingBatchAlgorithm phiMixingBatchAlgorithm = PhiMixingBatchAlgorithm.this;
                phiMixingBatchAlgorithm.demandedQiSamples = phiMixingBatchAlgorithm.demandedQiSamples - 1;
                this.ignoredSamples = 0;
            } else {
                ++this.ignoredSamples;
                assert (this.ignoredSamples <= this.ignoredSamples);
            }
        }

        public double get(int index) {
            return this.buffer.get(index);
        }

        public int size() {
            return this.buffer.size();
        }

        public List<Double> lagSublist(int lag) {
            ArrayList<Double> res = new ArrayList<Double>();
            int i = 0;
            while (i < this.buffer.size()) {
                res.add(this.buffer.get(i));
                i += lag;
            }
            return res;
        }

        public void discardAndRearrange() {
            int i = 0;
            while (i < this.buffer.size() / 2) {
                this.buffer.set(i, this.buffer.get(2 * i));
                ++i;
            }
            this.buffer.subList(this.buffer.size() / 2, this.buffer.size()).clear();
        }
    }

    private abstract class State {
        private static final int INITIALIZE = 1;
        private static final int READY = 2;
        private static final int FINISH = 1;
        private int internalState = 1;

        private State() {
        }

        abstract void start();

        public void offerSample(double sample) {
            if (this.internalState == 1) {
                this.start();
                this.internalState = 2;
            }
            PhiMixingBatchAlgorithm phiMixingBatchAlgorithm = PhiMixingBatchAlgorithm.this;
            phiMixingBatchAlgorithm.totalSamples = phiMixingBatchAlgorithm.totalSamples + 1;
        }

        abstract void end();

        protected void changeState(State state) {
            this.internalState = 1;
            this.end();
            PhiMixingBatchAlgorithm.this.setState(state);
        }

        protected void independenceConditionalStateChange(int lag, State independent, State notIndependent) {
            if (PhiMixingBatchAlgorithm.this.independenceTest.testIndependence(PhiMixingBatchAlgorithm.this.qiSamples.lagSublist(lag))) {
                LOGGER.info((Object)"Independence test passed. Batch means are valid.");
                if (PhiMixingBatchAlgorithm.this.batches.isEmpty()) {
                    PhiMixingBatchAlgorithm.this.computeBatches(4);
                }
                PhiMixingBatchAlgorithm.this.setValid(true);
                this.changeState(independent);
            } else {
                LOGGER.info((Object)"Independence test not passed. Need more samples.");
                this.changeState(notIndependent);
            }
        }

        protected void logBatchStatus() {
            if (PhiMixingBatchAlgorithm.this.batches.isEmpty()) {
                LOGGER.info((Object)("No batches determinined so far. Total samples seen: " + PhiMixingBatchAlgorithm.this.totalSamples));
            } else {
                LOGGER.info((Object)("There are " + PhiMixingBatchAlgorithm.this.batches.size() + " batches of size " + ((Batch)PhiMixingBatchAlgorithm.this.batches.get(0)).getSize() + ". Total samples seen: " + PhiMixingBatchAlgorithm.this.totalSamples));
            }
        }
    }
}

