/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.config;

import de.uka.ipd.sdq.tcfmoop.config.AbstractConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.TerminationCriteriaNames;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;

public class ParetoOptimalSetStabilityConfig
extends AbstractConfiguration {
    private Integer minimumSurvivors;
    private Double minimumSurvivorsInPercentage;
    private Integer minimumIterationsToSurvive;
    private EvaluationMode mode = EvaluationMode.NOT_SET;

    public ParetoOptimalSetStabilityConfig() {
        super(TerminationCriteriaNames.PARETO_OPTIMAL_SET_STABILITY);
    }

    @Override
    public boolean validateConfiguration() {
        return this.getTerminationCriterionName() == TerminationCriteriaNames.PARETO_OPTIMAL_SET_STABILITY && this.mode != EvaluationMode.NOT_SET && this.minimumIterationsToSurvive != null && (this.mode != EvaluationMode.EXACT_NUMBER || this.minimumSurvivors != null) && (this.mode != EvaluationMode.PERCENTAGE || this.minimumSurvivorsInPercentage != null);
    }

    public void setMinimumIterationsToSurvive(int minimumIterationsToSurvive) throws InvalidConfigException {
        if (minimumIterationsToSurvive < 2) {
            throw new InvalidConfigException("ParetoOptimalSetStabilityConfig.setMinNumberOfGenerationsToSurvive: The minimum number of generations that the pareto optimal candidates need to survive must be at least 2, or there is no set stability.");
        }
        this.minimumIterationsToSurvive = minimumIterationsToSurvive;
    }

    public int getMinimumIterationsToSurvive() {
        return this.minimumIterationsToSurvive;
    }

    public void setMinimumSurvivors(int minimumSurvivors) throws InvalidConfigException {
        if (minimumSurvivors < 1) {
            throw new InvalidConfigException("ParetoOptimalSetStabilityConfig.setMinimumNumberOfSurvivors: The minimum number of pareto optimal candidate that need to survive must be at least 1.");
        }
        this.minimumSurvivors = minimumSurvivors;
    }

    public int getMinimumSurvivors() {
        return this.minimumSurvivors;
    }

    public void setMinimumSurvivorsInPercentage(double minimumSurvivorsInPercentage) throws InvalidConfigException {
        if (minimumSurvivorsInPercentage < 0.0 || minimumSurvivorsInPercentage > 1.0) {
            throw new InvalidConfigException("ParetoOptimalSetStabilityConfig.setMinimumSurvivorsInPercentage: The minimum percentage number of pareto optimal candidates that need to survive must be at a value in the interval [0, 1].");
        }
        this.minimumSurvivorsInPercentage = minimumSurvivorsInPercentage;
    }

    public double getMinimumSurvivorsInPercentage() {
        return this.minimumSurvivorsInPercentage;
    }

    public void setEvaluationMode(EvaluationMode mode) throws InvalidConfigException {
        if (mode != EvaluationMode.EXACT_NUMBER && mode != EvaluationMode.PERCENTAGE) {
            throw new InvalidConfigException("ParetoOptimalSetStabilityConfig.setEvaluationMode: The evaluation mode can be either EXACT_NUMBER or PERCENTAGE.");
        }
        this.mode = mode;
    }

    public EvaluationMode getEvaluationMode() {
        return this.mode;
    }

    public static enum EvaluationMode {
        EXACT_NUMBER,
        PERCENTAGE,
        NOT_SET;

    }
}

