/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.uka.ipd.sdq.units.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;

import de.uka.ipd.sdq.units.BaseUnit;
import de.uka.ipd.sdq.units.Unit;
import de.uka.ipd.sdq.units.UnitCarryingElement;
import de.uka.ipd.sdq.units.UnitDivision;
import de.uka.ipd.sdq.units.UnitMultiplication;
import de.uka.ipd.sdq.units.UnitPower;
import de.uka.ipd.sdq.units.UnitRepository;
import de.uka.ipd.sdq.units.UnitsPackage;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance hierarchy. It supports the
 * call {@link #doSwitch(EObject) doSwitch(object)} to invoke the <code>caseXXX</code> method for
 * each class of the model, starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the result of the switch.
 * <!-- end-user-doc -->
 * 
 * @see de.uka.ipd.sdq.units.UnitsPackage
 * @generated
 */
public class UnitsSwitch<T> extends Switch<T> {

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public static final String copyright = "Copyright 2007-2009, SDQ, IPD, U Karlsruhe";
    /**
     * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected static UnitsPackage modelPackage;

    /**
     * Creates an instance of the switch. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public UnitsSwitch() {
        if (modelPackage == null) {
            modelPackage = UnitsPackage.eINSTANCE;
        }
    }

    /**
     * Checks whether this is a switch for the given package. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @parameter ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
    @Override
    protected boolean isSwitchFor(final EPackage ePackage) {
        return ePackage == modelPackage;
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result;
     * it yields that result. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    @Override
    protected T doSwitch(final int classifierID, final EObject theEObject) {
        switch (classifierID) {
        case UnitsPackage.UNIT_CARRYING_ELEMENT: {
            final UnitCarryingElement unitCarryingElement = (UnitCarryingElement) theEObject;
            T result = this.caseUnitCarryingElement(unitCarryingElement);
            if (result == null) {
                result = this.defaultCase(theEObject);
            }
            return result;
        }
        case UnitsPackage.UNIT: {
            final Unit unit = (Unit) theEObject;
            T result = this.caseUnit(unit);
            if (result == null) {
                result = this.defaultCase(theEObject);
            }
            return result;
        }
        case UnitsPackage.BASE_UNIT: {
            final BaseUnit baseUnit = (BaseUnit) theEObject;
            T result = this.caseBaseUnit(baseUnit);
            if (result == null) {
                result = this.caseUnit(baseUnit);
            }
            if (result == null) {
                result = this.defaultCase(theEObject);
            }
            return result;
        }
        case UnitsPackage.UNIT_REPOSITORY: {
            final UnitRepository unitRepository = (UnitRepository) theEObject;
            T result = this.caseUnitRepository(unitRepository);
            if (result == null) {
                result = this.defaultCase(theEObject);
            }
            return result;
        }
        case UnitsPackage.UNIT_MULTIPLICATION: {
            final UnitMultiplication unitMultiplication = (UnitMultiplication) theEObject;
            T result = this.caseUnitMultiplication(unitMultiplication);
            if (result == null) {
                result = this.caseUnit(unitMultiplication);
            }
            if (result == null) {
                result = this.defaultCase(theEObject);
            }
            return result;
        }
        case UnitsPackage.UNIT_POWER: {
            final UnitPower unitPower = (UnitPower) theEObject;
            T result = this.caseUnitPower(unitPower);
            if (result == null) {
                result = this.caseUnit(unitPower);
            }
            if (result == null) {
                result = this.defaultCase(theEObject);
            }
            return result;
        }
        case UnitsPackage.UNIT_DIVISION: {
            final UnitDivision unitDivision = (UnitDivision) theEObject;
            T result = this.caseUnitDivision(unitDivision);
            if (result == null) {
                result = this.caseUnit(unitDivision);
            }
            if (result == null) {
                result = this.defaultCase(theEObject);
            }
            return result;
        }
        default:
            return this.defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpreting the object as an instance of '
     * <em>Unit Carrying Element</em>'. <!-- begin-user-doc --> This implementation returns null;
     * returning a non-null result will terminate the switch. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '
     *         <em>Unit Carrying Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseUnitCarryingElement(final UnitCarryingElement object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Unit</em>'. <!--
     * begin-user-doc --> This implementation returns null; returning a non-null result will
     * terminate the switch. <!-- end-user-doc -->
     *
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Unit</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseUnit(final Unit object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Base Unit</em>'. <!--
     * begin-user-doc --> This implementation returns null; returning a non-null result will
     * terminate the switch. <!-- end-user-doc -->
     *
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Base Unit</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseBaseUnit(final BaseUnit object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Unit Repository</em>'.
     * <!-- begin-user-doc --> This implementation returns null; returning a non-null result will
     * terminate the switch. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Unit Repository</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseUnitRepository(final UnitRepository object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Unit Multiplication</em>
     * '. <!-- begin-user-doc --> This implementation returns null; returning a non-null result will
     * terminate the switch. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Unit Multiplication</em>
     *         '.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseUnitMultiplication(final UnitMultiplication object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Unit Power</em>'. <!--
     * begin-user-doc --> This implementation returns null; returning a non-null result will
     * terminate the switch. <!-- end-user-doc -->
     *
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Unit Power</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseUnitPower(final UnitPower object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Unit Division</em>'.
     * <!-- begin-user-doc --> This implementation returns null; returning a non-null result will
     * terminate the switch. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Unit Division</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseUnitDivision(final UnitDivision object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'. <!--
     * begin-user-doc --> This implementation returns null; returning a non-null result will
     * terminate the switch, but this is the last case anyway. <!-- end-user-doc -->
     *
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    @Override
    public T defaultCase(final EObject object) {
        return null;
    }

} // UnitsSwitch
