/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow;

import de.uka.ipd.sdq.workflow.Workflow;
import de.uka.ipd.sdq.workflow.WorkflowExceptionHandler;
import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BlackboardBasedWorkflow<T extends Blackboard<?>>
extends Workflow {
    private T myBlackboard;

    public BlackboardBasedWorkflow(IJob job, T blackboard) {
        this(job, null, new WorkflowExceptionHandler(false), blackboard);
    }

    public BlackboardBasedWorkflow(IJob job, WorkflowExceptionHandler handler, T blackboard) {
        this(job, null, new WorkflowExceptionHandler(false), blackboard);
    }

    public BlackboardBasedWorkflow(IJob job, IProgressMonitor monitor, WorkflowExceptionHandler handler, T blackboard) {
        super(job, monitor, handler);
        this.myBlackboard = blackboard;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        for (IJob job : this.myJobs) {
            if (!(job instanceof IBlackboardInteractingJob)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting Blackboard of job " + job.getClass().getCanonicalName()));
            }
            ((IBlackboardInteractingJob)job).setBlackboard(this.myBlackboard);
        }
        super.execute(monitor);
    }
}

